/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.charts;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import org.ut.biolab.medsavant.client.view.genetics.charts.Ring;

public class RingChart
extends JPanel {
    List<Ring> rings;

    public RingChart() {
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                RingChart.this.repaint();
            }
        });
        this.rings = new ArrayList<Ring>();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setComposite(AlphaComposite.getInstance(3, 0.4f));
        BasicStroke s = new BasicStroke(1.25f);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(s);
        Insets insets = this.getInsets();
        int h = this.getHeight() - insets.top - insets.bottom;
        int w = this.getWidth() - insets.left - insets.right;
        int m = Math.min(h, w);
        for (int r = 0; r < this.rings.size(); ++r) {
            Ring ring = this.rings.get(r);
            double rw = (double)m / ((double)this.rings.size() + 1.0) / 2.0;
            ring.setRingWidth(rw);
            ring.setRadius(2.0 * rw + rw * (double)r);
            ring.setCenter((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
            ring.createSegments();
            for (int index = 0; index < ring.count(); ++index) {
                g2.setColor(ring.getColor(index));
                g2.fill(ring.getSegment(index));
            }
        }
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip tooltip = super.createToolTip();
        tooltip.setBackground(new Color(255, 255, 140, 128));
        this.repaint();
        return tooltip;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        for (int r = 0; r < this.rings.size(); ++r) {
            Ring ring = this.rings.get(r);
            for (int index = 0; index < ring.count(); ++index) {
                if (!ring.getSegment(index).contains(e.getPoint())) continue;
                return ring.getLabel(index) + ": " + ring.getValue(index);
            }
        }
        return super.getToolTipText(e);
    }

    public void setRings(List<Ring> r) {
        this.rings = r;
        this.repaint();
    }
}

