/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.charts;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Legend;
import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.CategoryAxis;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.InvertibleTransform;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.DefaultBarRenderer;
import com.jidesoft.chart.render.DefaultPieSegmentRenderer;
import com.jidesoft.chart.render.LinePieLabelRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import net.ericaro.surfaceplotter.JSurfacePanel;
import net.ericaro.surfaceplotter.Mapper;
import net.ericaro.surfaceplotter.ProgressiveSurfaceModel;
import net.ericaro.surfaceplotter.surface.SurfaceModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.filter.SearchBar;
import org.ut.biolab.medsavant.client.filter.WhichTable;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.query.QueryViewController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.util.ThreadController;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.genetics.QueryUtils;
import org.ut.biolab.medsavant.client.view.genetics.charts.ChartFrequencyMap;
import org.ut.biolab.medsavant.client.view.genetics.charts.ChartMapGenerator;
import org.ut.biolab.medsavant.client.view.genetics.charts.FrequencyEntry;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.ScatterChartEntry;
import org.ut.biolab.medsavant.shared.model.ScatterChartMap;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class SummaryChart
extends JLayeredPane
implements BasicPatientColumns,
BasicVariantColumns {
    private static final Log LOG = LogFactory.getLog(SummaryChart.class);
    private boolean isLogScaleY = false;
    private boolean isLogScaleX = false;
    private boolean showComparedToOriginal = false;
    private boolean isPie = false;
    private boolean isSorted = false;
    private MedSavantWorker mapWorker;
    private ChartMapGenerator mapGenerator;
    private ChartMapGenerator mapGeneratorScatter;
    private boolean isSortedKaryotypically;
    private String pageName;
    private final Object updateLock = new Object();
    private boolean updateRequired = false;
    private GridBagConstraints c;
    private WaitPanel waitPanel = new WaitPanel("Getting chart data");
    private boolean isScatter = false;
    private String chartName;

    public boolean doesCompareToOriginal() {
        return this.showComparedToOriginal;
    }

    void setDoesCompareToOriginal(boolean b) {
        this.showComparedToOriginal = b;
        this.updateDataAndDrawChart();
    }

    public SummaryChart(String pageName) {
        this.pageName = pageName;
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.fill = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.add(this.waitPanel, this.c, JLayeredPane.MODAL_LAYER);
    }

    void setChartName(String s) {
        this.chartName = s;
    }

    public void setIsLogScale(boolean isLogScale, ChartAxis axis) {
        if (!isLogScale) {
            this.isLogScaleY = false;
            this.isLogScaleX = false;
        } else {
            this.isLogScaleY = axis == ChartAxis.Y;
            this.isLogScaleX = axis == ChartAxis.X;
        }
        this.updateDataAndDrawChart();
    }

    public void setIsSorted(boolean isSorted) {
        this.isSorted = isSorted;
        this.updateDataAndDrawChart();
    }

    public void setIsPie(boolean b) {
        this.isPie = b;
        this.updateDataAndDrawChart();
    }

    public boolean isLogScaleY() {
        return this.isLogScaleY;
    }

    public boolean isLogScaleX() {
        return this.isLogScaleX;
    }

    public boolean isPie() {
        return this.isPie;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public boolean isSortedKaryotypically() {
        return this.isSortedKaryotypically;
    }

    public void setChartMapGenerator(ChartMapGenerator cmg) {
        this.mapGenerator = cmg;
    }

    public void setScatterChartMapGenerator(ChartMapGenerator cmg) {
        this.mapGeneratorScatter = cmg;
    }

    public void setIsScatterChart(boolean scatter) {
        this.isScatter = scatter;
    }

    public boolean isScatterChart() {
        return this.isScatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIfRequired() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.updateRequired) {
                this.updateRequired = false;
                this.updateDataAndDrawChart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateRequired(boolean required) {
        Object object = this.updateLock;
        synchronized (object) {
            this.updateRequired = required;
        }
    }

    private void updateDataAndDrawChart() {
        this.removeAll();
        this.add(this.waitPanel, this.c, JLayeredPane.MODAL_LAYER);
        this.waitPanel.setVisible(true);
        this.setLayer(this.waitPanel, JLayeredPane.MODAL_LAYER);
        this.mapWorker = this.isScatter ? new ScatterChartMapWorker() : new ChartMapWorker();
        this.mapWorker.execute();
    }

    private ChartStyle barStyle(Paint fill) {
        ChartStyle style = new ChartStyle();
        style.setBarsVisible(true);
        style.setBarPaint(fill);
        return style;
    }

    private synchronized Chart drawChart(ChartFrequencyMap[] chartMaps) {
        List<ChartCategory> chartCategories;
        ChartFrequencyMap filteredChartMap = chartMaps[0];
        ChartFrequencyMap unfilteredChartMap = null;
        DefaultChartModel filteredChartModel = new DefaultChartModel();
        DefaultChartModel unfilteredChartModel = null;
        if (this.showComparedToOriginal) {
            unfilteredChartMap = ChartFrequencyMap.subtract(chartMaps[1], filteredChartMap, this.isLogScaleY());
            unfilteredChartModel = new DefaultChartModel();
        }
        final Chart chart = new Chart();
        JPanel panel = new JPanel();
        Legend legend = new Legend(chart, 0);
        panel.add((Component)legend);
        legend.addChart(chart);
        boolean multiColor = !this.mapGenerator.isNumeric() || this.isPie;
        chart.setRolloverEnabled(true);
        chart.setSelectionEnabled(true);
        chart.setSelectionShowsOutline(true);
        chart.setSelectionShowsExplodedSegments(true);
        chart.setAntiAliasing(true);
        chart.setBarGap(5);
        chart.setBorder(ViewUtil.getBigBorder());
        chart.setLabellingTraces(true);
        chart.setAnimateOnShow(false);
        chart.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu popup = SummaryChart.this.createPopup(chart);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        DefaultPieSegmentRenderer rpie = new DefaultPieSegmentRenderer();
        chart.setPieSegmentRenderer((PieSegmentRenderer)rpie);
        LinePieLabelRenderer plr = new LinePieLabelRenderer();
        plr.setLabelColor(Color.black);
        plr.setLineColor(Color.black);
        rpie.setPieLabelRenderer((PieLabelRenderer)plr);
        DefaultBarRenderer rbar = new DefaultBarRenderer();
        chart.setBarRenderer((BarRenderer)rbar);
        rpie.setSelectionColor(Color.gray);
        rbar.setSelectionColor(Color.gray);
        if (this.isSortedKaryotypically()) {
            filteredChartMap.sortKaryotypically();
            if (this.showComparedToOriginal) {
                unfilteredChartMap.sortKaryotypically();
            }
        }
        if (this.isSorted() && !this.mapGenerator.isNumeric() && !this.isSortedKaryotypically()) {
            filteredChartMap.sortNumerically();
            if (this.showComparedToOriginal) {
                chartMaps[1].sortNumerically();
            }
        } else {
            filteredChartMap.undoSortNumerically();
            if (this.showComparedToOriginal) {
                chartMaps[1].undoSortNumerically();
            }
        }
        long max = filteredChartMap.getMax();
        if (this.showComparedToOriginal) {
            chartCategories = chartMaps[1].getCategories();
            max = chartMaps[1].getMax();
        } else {
            chartCategories = filteredChartMap.getCategories();
        }
        CategoryRange range = new CategoryRange();
        ArrayList<Highlight> highlights = new ArrayList<Highlight>();
        Color color = new Color(72, 181, 249);
        int catNum = 0;
        int totalCats = filteredChartMap.getEntries().size();
        for (ChartCategory category : chartCategories) {
            range.add((Category)category);
            if (multiColor) {
                color = ViewUtil.getColor(catNum++, totalCats);
            }
            Highlight h = new Highlight(category.getName());
            highlights.add(h);
            chart.setHighlightStyle(h, this.barStyle(color));
        }
        CategoryAxis xaxis = new CategoryAxis(range, "Category");
        chart.setXAxis((Axis)xaxis);
        if (this.isLogScaleY()) {
            chart.setYAxis(new Axis((Range)new NumericRange(0.0, Math.log10(max) * 1.1), "log(Frequency)"));
        } else {
            chart.setYAxis(new Axis((Range)new NumericRange(0.0, (double)max * 1.1), "Frequency"));
        }
        this.addEntriesToChart(filteredChartModel, filteredChartMap, chartCategories, highlights);
        if (this.showComparedToOriginal) {
            this.addEntriesToChart(unfilteredChartModel, unfilteredChartMap, chartCategories, null);
        }
        chart.getXAxis().getLabel().setFont(ViewUtil.getMediumTitleFont());
        chart.getYAxis().getLabel().setFont(ViewUtil.getMediumTitleFont());
        chart.getXAxis().setTickLabelRotation(1.57079633);
        if (this.isPie) {
            System.out.println("Setting chart type to pie");
            chart.setChartType(ChartType.PIE);
            chart.getXAxis().getLabel().setColor(Color.BLUE);
        }
        for (int i = 1; i < this.getComponentCount(); ++i) {
            this.remove(i);
        }
        chart.addModel((ChartModel)filteredChartModel, new ChartStyle().withBars());
        if (this.showComparedToOriginal) {
            chart.addModel((ChartModel)unfilteredChartModel, new ChartStyle(new Color(10, 10, 10, 100)).withBars());
        }
        return chart;
    }

    private void addEntriesToChart(DefaultChartModel chartModel, ChartFrequencyMap chartMap, List<ChartCategory> chartCategories, List<Highlight> highlights) {
        boolean addHighlights = highlights != null;
        int index = 0;
        for (ChartCategory cat : chartCategories) {
            FrequencyEntry fe = chartMap.getEntry(cat.getName());
            long value = 0L;
            if (fe != null) {
                value = fe.getFrequency();
            }
            ChartPoint p = new ChartPoint((Positionable)cat, (double)value);
            ChartPoint logp = new ChartPoint((Positionable)cat, Math.log10(value));
            if (addHighlights) {
                p.setHighlight(highlights.get(index));
                logp.setHighlight(highlights.get(index));
            }
            if (this.isLogScaleY()) {
                chartModel.addPoint((Chartable)logp);
            } else {
                chartModel.addPoint((Chartable)p);
            }
            ++index;
        }
    }

    private synchronized void drawScatterChart(ScatterChartMap entries) {
        int i;
        Chart chart = new Chart(new Dimension(200, 200));
        Legend legend = new Legend(chart);
        int max = 0;
        CategoryRange range = new CategoryRange();
        for (int i2 = 0; i2 < entries.getNumX(); ++i2) {
            range.add((Category)new ChartCategory((Object)entries.getXValueAt(i2)));
        }
        DefaultChartModel[] models = new DefaultChartModel[entries.getNumY()];
        for (i = 0; i < entries.getNumY(); ++i) {
            models[i] = new DefaultChartModel();
        }
        for (i = 0; i < entries.getNumX(); ++i) {
            for (int j = 0; j < entries.getNumY(); ++j) {
                ScatterChartEntry entry = entries.getValueAt(i, j);
                if (entry != null) {
                    max = Math.max(max, entry.getFrequency());
                    models[j].addPoint((Chartable)new ChartPoint((Positionable)range.getCategoryValues().get(i), (double)entry.getFrequency()));
                    models[j].setName(entry.getYRange());
                    continue;
                }
                models[j].addPoint((Chartable)new ChartPoint((Positionable)range.getCategoryValues().get(i), 0.0));
            }
        }
        for (i = 0; i < models.length; ++i) {
            Color translucentGreen = ViewUtil.getColor(i, models.length);
            ChartStyle style = new ChartStyle(translucentGreen, PointShape.DISC);
            style.setPointSize(10);
            chart.addModel((ChartModel)models[i], style);
        }
        CategoryAxis xaxis = new CategoryAxis(range, this.mapGenerator.getName());
        chart.setXAxis((Axis)xaxis);
        chart.setYAxis(new Axis((Range)new NumericRange(0.0, (double)max * 1.1), "Frequency"));
        this.add((Component)chart, this.c, JLayeredPane.DEFAULT_LAYER);
        JScrollPane scroll = new JScrollPane((Component)legend);
        scroll.setPreferredSize(new Dimension(150, 100));
        this.c.gridx = 1;
        this.c.weightx = 0.0;
        this.add(scroll, this.c, JLayeredPane.DEFAULT_LAYER);
        this.c.weightx = 1.0;
        this.c.gridx = 0;
    }

    private synchronized void drawSurface(final ScatterChartMap entries) {
        String[] firstX = entries.getXValueAt(0).split("[^(\\d|\\.|E)]");
        String[] firstY = entries.getYValueAt(0).split("[^(\\d|\\.|E)]");
        String[] lastX = entries.getXValueAt(entries.getNumX() - 1).split("[^(\\d|\\.|E)]");
        String[] lastY = entries.getYValueAt(entries.getNumY() - 1).split("[^(\\d|\\.|E)]");
        float startX = Float.parseFloat(firstX[0]);
        float endX = Float.parseFloat(lastX[lastX.length - 1]);
        final float binSizeX = Float.parseFloat(firstX[firstX.length - 1]) - startX;
        float startY = Float.parseFloat(firstY[0]);
        float endY = Float.parseFloat(lastY[lastY.length - 1]);
        final float binSizeY = Float.parseFloat(firstY[firstY.length - 1]) - startY;
        JSurfacePanel panel = new JSurfacePanel();
        panel.setTitleText("");
        ProgressiveSurfaceModel model = new ProgressiveSurfaceModel();
        panel.setModel((SurfaceModel)model);
        model.setXMin(startX);
        model.setXMax(endX);
        model.setYMin(startY);
        model.setYMax(endY);
        model.setZMin(0.0f);
        model.setZMax((float)(entries.getMaxFrequency() + 1));
        model.setDisplayXY(true);
        model.setDisplayZ(true);
        model.setMapper(new Mapper(){

            public float f1(float x, float y) {
                try {
                    int binX = (int)(x / binSizeX);
                    int binY = (int)(y / binSizeY);
                    ScatterChartEntry entry = entries.getValueAt(binX, binY);
                    if (entry == null) {
                        return 0.0f;
                    }
                    return entry.getFrequency();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Exception thrown by mapper.", (Throwable)ex);
                    return x;
                }
            }

            public float f2(float x, float y) {
                return 0.0f;
            }
        });
        model.plot().execute();
        this.add((Component)panel, this.c, JLayeredPane.DEFAULT_LAYER);
    }

    void setIsSortedKaryotypically(boolean b) {
        this.isSortedKaryotypically = b;
    }

    private JPopupMenu createPopup(final Chart chart) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem filter1Item = new JMenuItem("Filter by Selection" + (this.mapGenerator.isNumeric() ? "" : "(s)"));
        filter1Item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadController.getInstance().cancelWorkers(SummaryChart.this.pageName);
                boolean isGender = SummaryChart.this.mapGenerator.getName().equalsIgnoreCase(BasicPatientColumns.GENDER.getAlias());
                try {
                    ArrayList<String> values = new ArrayList<String>();
                    ListSelectionModel selectionModel = chart.getSelectionsForModel(chart.getModel(0));
                    QueryViewController qvc = SearchBar.getInstance().getQueryViewController();
                    for (int i = selectionModel.getMinSelectionIndex(); i <= selectionModel.getMaxSelectionIndex(); ++i) {
                        if (!selectionModel.isSelectedIndex(i)) continue;
                        String v = ((ChartPoint)chart.getModel().getPoint(i)).getHighlight().name();
                        values.add(v);
                        if (!SummaryChart.this.mapGenerator.isNumeric() || isGender) continue;
                        double low = 0.0;
                        double high = 0.0;
                        String[] s = v.split(" - ");
                        if (s.length < 2) {
                            LOG.error((Object)("Invalid range detected for numeric condition " + SummaryChart.this.mapGenerator.getName() + " val=" + v));
                        }
                        NumberFormat format = NumberFormat.getInstance();
                        low = format.parse(s[0]).doubleValue();
                        high = format.parse(s[1]).doubleValue();
                        QueryUtils.addNumericQuery(SummaryChart.this.chartName, low, high, false);
                    }
                    if (values.isEmpty()) {
                        return;
                    }
                    if (!SummaryChart.this.mapGenerator.isNumeric() || isGender) {
                        QueryUtils.addMultiStringQuery(SummaryChart.this.chartName, values);
                    }
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Error filtering by selection: %s", ex);
                }
            }
        });
        menu.add(filter1Item);
        return menu;
    }

    class LogTransform
    implements InvertibleTransform<Double> {
        LogTransform() {
        }

        public Double transform(Double pos) {
            return Math.log10(pos);
        }

        public Double inverseTransform(Double t) {
            return Math.pow(10.0, t);
        }
    }

    static class ValueComparator
    implements Comparator {
        Map base;

        public ValueComparator(Map base) {
            this.base = base;
        }

        public int compare(Object a, Object b) {
            if ((Integer)this.base.get(a) < (Integer)this.base.get(b)) {
                return 1;
            }
            if ((Integer)this.base.get(a) == (Integer)this.base.get(b)) {
                return 0;
            }
            return -1;
        }
    }

    public class ScatterChartMapWorker
    extends MedSavantWorker<ScatterChartMap> {
        ScatterChartMapWorker() {
            super(SummaryChart.this.pageName);
            if (SummaryChart.this.mapWorker != null) {
                SummaryChart.this.mapWorker.cancel(true);
            }
        }

        private ScatterChartMap mapPatientField(ScatterChartMap scatterMap, ChartMapGenerator generator, boolean isX) throws SQLException, RemoteException {
            Map<Object, List<String>> map;
            try {
                map = MedSavantClient.PatientManager.getDNAIDsForValues(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), generator.getFilterId());
            }
            catch (SessionExpiredException ex) {
                MedSavantExceptionHandler.handleSessionExpiredException(ex);
                return null;
            }
            if (generator.getFilterId().equals(BasicPatientColumns.GENDER.getColumnName())) {
                map = ClientMiscUtils.modifyGenderMap(map);
            }
            ArrayList<String> rangesA = new ArrayList<String>();
            for (Object o : map.keySet()) {
                rangesA.add(o.toString());
            }
            List<String> rangesB = isX ? scatterMap.getYRanges() : scatterMap.getXRanges();
            ArrayList<ScatterChartEntry> entries = new ArrayList<ScatterChartEntry>();
            for (Object a : map.keySet()) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (String dnaId : map.get(a)) {
                    int index = isX ? scatterMap.getIndexOnX(dnaId) : scatterMap.getIndexOnY(dnaId);
                    if (index == -1) continue;
                    indices.add(index);
                }
                for (int b = 0; b < rangesB.size(); ++b) {
                    int sum = 0;
                    for (Integer index : indices) {
                        if ((isX ? scatterMap.getValueAt(index, b) : scatterMap.getValueAt(b, index)) == null) continue;
                        sum += (isX ? scatterMap.getValueAt(index, b) : scatterMap.getValueAt(b, index)).getFrequency();
                    }
                    entries.add(isX ? new ScatterChartEntry(a.toString(), rangesB.get(b), sum) : new ScatterChartEntry(rangesB.get(b), a.toString(), sum));
                }
            }
            return isX ? new ScatterChartMap(rangesA, rangesB, entries) : new ScatterChartMap(rangesB, rangesA, entries);
        }

        @Override
        protected ScatterChartMap doInBackground() throws Exception {
            if (SummaryChart.this.mapGenerator == null) {
                return null;
            }
            String columnX = SummaryChart.this.mapGenerator.getFilterId();
            String columnY = SummaryChart.this.mapGeneratorScatter.getFilterId();
            if (SummaryChart.this.mapGenerator.getTable() == WhichTable.PATIENT) {
                columnX = BasicVariantColumns.DNA_ID.getColumnName();
            }
            if (SummaryChart.this.mapGeneratorScatter.getTable() == WhichTable.PATIENT) {
                columnY = BasicVariantColumns.DNA_ID.getColumnName();
            }
            ScatterChartMap scatterMap = MedSavantClient.VariantManager.getFilteredFrequencyValuesForScatter(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), FilterController.getInstance().getAllFilterConditions(), columnX, columnY, !SummaryChart.this.mapGenerator.isNumeric() || SummaryChart.this.mapGenerator.getTable() == WhichTable.PATIENT, !SummaryChart.this.mapGeneratorScatter.isNumeric() || SummaryChart.this.mapGeneratorScatter.getTable() == WhichTable.PATIENT, SummaryChart.this.isSortedKaryotypically());
            if (SummaryChart.this.mapGenerator.getTable() == WhichTable.PATIENT) {
                scatterMap = this.mapPatientField(scatterMap, SummaryChart.this.mapGenerator, true);
            }
            if (SummaryChart.this.mapGeneratorScatter.getTable() == WhichTable.PATIENT) {
                scatterMap = this.mapPatientField(scatterMap, SummaryChart.this.mapGeneratorScatter, false);
            }
            return scatterMap;
        }

        @Override
        public void showSuccess(ScatterChartMap result) {
            if (SummaryChart.this.mapGenerator.isNumeric() && SummaryChart.this.mapGeneratorScatter.isNumeric() && !SummaryChart.this.mapGenerator.getFilterId().equals(BasicPatientColumns.GENDER.getColumnName()) && !SummaryChart.this.mapGeneratorScatter.getFilterId().equals(BasicPatientColumns.GENDER.getColumnName())) {
                SummaryChart.this.drawSurface(result);
            } else {
                SummaryChart.this.drawScatterChart(result);
            }
            SummaryChart.this.waitPanel.setVisible(false);
            SummaryChart.this.revalidate();
        }

        @Override
        public void showProgress(double prog) {
            if (prog == 1.0) {
                SummaryChart.this.mapWorker = null;
            }
        }
    }

    public class ChartMapWorker
    extends MedSavantWorker<ChartFrequencyMap[]> {
        ChartMapWorker() {
            super(SummaryChart.this.pageName);
            if (SummaryChart.this.mapWorker != null) {
                SummaryChart.this.mapWorker.cancel(true);
            }
        }

        @Override
        protected ChartFrequencyMap[] doInBackground() throws Exception {
            ChartFrequencyMap[] result;
            if (SummaryChart.this.mapGenerator == null) {
                return null;
            }
            if (SummaryChart.this.showComparedToOriginal) {
                result = new ChartFrequencyMap[2];
                result[1] = SummaryChart.this.mapGenerator.generateChartMap(false, SummaryChart.this.isLogScaleX && SummaryChart.this.mapGenerator.isNumeric());
            } else {
                result = new ChartFrequencyMap[]{SummaryChart.this.mapGenerator.generateChartMap(true, SummaryChart.this.isLogScaleX && SummaryChart.this.mapGenerator.isNumeric())};
            }
            return result;
        }

        @Override
        public void showSuccess(ChartFrequencyMap[] result) {
            if (result != null && result[0] != null && result[0].getEntries().size() < 200 && !result[0].getEntries().isEmpty()) {
                Chart chart = SummaryChart.this.drawChart(result);
                SummaryChart.this.add((Component)chart, SummaryChart.this.c, JLayeredPane.DEFAULT_LAYER);
            } else if (result != null && result[0] != null && result[0].getEntries().isEmpty()) {
                SummaryChart.this.add((Component)ViewUtil.getMessagePanelBig("No variants pass query"), SummaryChart.this.c);
            } else if (result != null && result[0] != null && result[0].getEntries().size() >= 200) {
                SummaryChart.this.add((Component)ViewUtil.getMessagePanelBig("Too many values to display chart"), SummaryChart.this.c);
            } else {
                SummaryChart.this.add((Component)ViewUtil.getMessagePanelBig("Error creating chart"), SummaryChart.this.c);
            }
            SummaryChart.this.waitPanel.setVisible(false);
            SummaryChart.this.revalidate();
        }

        @Override
        public void showProgress(double prog) {
            if (prog == 1.0) {
                SummaryChart.this.mapWorker = null;
            }
        }
    }

    public static enum ChartAxis {
        X,
        Y;

    }
}

