/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.inspector.stat;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.view.genetics.TablePanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.CollapsibleInspector;
import org.ut.biolab.medsavant.client.view.genetics.inspector.stat.StaticInspectorPanel;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.BasicVariantSubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SocialVariantSubInspector;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class StaticVariantInspector
extends CollapsibleInspector
implements Listener<VariantRecord> {
    private static StaticVariantInspector instance;
    private static List<Listener<VariantRecord>> listeners;
    private static VariantRecord record;

    public static StaticVariantInspector getInstance() {
        if (instance == null) {
            instance = new StaticVariantInspector();
        }
        return instance;
    }

    private StaticVariantInspector() {
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(ViewUtil.getHugeBorder());
        ViewUtil.applyVerticalBoxLayout(messagePanel);
        JLabel h1 = new JLabel("No Variant Selected");
        h1.setFont(ViewUtil.getMediumTitleFont());
        String m = "<html><div style=\"text-align: center;\">Choose one from the list on the left</div></html>";
        JLabel h2 = new JLabel(m);
        h2.setPreferredSize(new Dimension(190, 300));
        h2.setMinimumSize(new Dimension(190, 300));
        h2.setBackground(Color.red);
        messagePanel.add(ViewUtil.centerHorizontally(h1));
        messagePanel.add(Box.createVerticalStrut(10));
        messagePanel.add(ViewUtil.centerHorizontally(h2));
        this.setMessage(messagePanel);
        TablePanel.addVariantSelectionChangedListener(this);
        this.addSubInspector(new BasicVariantSubInspector());
        this.addSubInspector(new SocialVariantSubInspector());
    }

    @Override
    public String getName() {
        return "Variant Inspector";
    }

    public static void addVariantSelectionChangedListener(Listener<VariantRecord> l) {
        listeners.add(l);
    }

    @Override
    public void handleEvent(VariantRecord r) {
        if (r == null) {
            this.switchToMessage();
        } else {
            this.switchToPanes();
        }
        StaticInspectorPanel.getInstance().switchToVariantInspector();
        for (Listener<VariantRecord> l : listeners) {
            l.handleEvent(r);
        }
        record = r;
    }

    static {
        listeners = new ArrayList<Listener<VariantRecord>>();
    }
}

