/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.util.VisibleMedSavantWorker;

public abstract class DownloadTask
extends VisibleMedSavantWorker<Void> {
    private static final Log LOG = LogFactory.getLog(DownloadTask.class);
    private final String URLStr;
    private final String destPath;
    private final long filesize;
    private long totalBytesRead = 0L;
    private final String filename;
    private static final int BUFFER_SIZE = 4096;
    private DownloadState downloadState = DownloadState.NOT_STARTED;

    @Override
    protected void jobDone() {
        super.jobDone();
        this.setDownloadState(DownloadState.FINISHED);
    }

    protected void setDownloadState(DownloadState downloadState) {
        DownloadState oldDownloadState = this.downloadState;
        this.downloadState = downloadState;
        this.firePropertyChange("downloadState", (Object)oldDownloadState, (Object)downloadState);
    }

    public DownloadState getDownloadState() {
        return this.downloadState;
    }

    private String extractFileFromURL() {
        return this.URLStr.substring(this.URLStr.lastIndexOf("/") + 1, this.URLStr.length());
    }

    public String getDestPath() {
        if (this.destPath.charAt(this.destPath.length() - 1) == File.separatorChar) {
            return this.destPath + this.filename;
        }
        return this.destPath + File.separator + this.filename;
    }

    public DownloadTask(String URLStr, String destPath, String notificationTitle) throws IOException {
        super(DownloadTask.class.getSimpleName(), notificationTitle);
        int index;
        this.URLStr = URLStr;
        this.destPath = destPath;
        this.showResultsOnFinish(false);
        URL url = new URL(URLStr);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        if (responseCode != 200) {
            throw new IOException("File " + URLStr + "unavailable from server");
        }
        String disposition = httpConn.getHeaderField("Content-Disposition");
        int filesize = httpConn.getContentLength();
        String filename = disposition != null ? ((index = disposition.indexOf("filename=")) > 0 ? disposition.substring(index + 10, disposition.length() - 1) : this.extractFileFromURL()) : this.extractFileFromURL();
        this.filename = filename;
        this.filesize = filesize;
        httpConn.disconnect();
    }

    public long getFileSize() {
        return this.filesize;
    }

    public long getTotalBytesSoFar() {
        return this.totalBytesRead;
    }

    public void cancelDownload() {
        this.setDownloadState(DownloadState.CANCELLED);
        this.cancel(true);
    }

    @Override
    protected void cancelJob() {
        super.cancelJob();
        this.setDownloadState(DownloadState.CANCELLED);
    }

    @Override
    protected Void runInBackground() {
        try {
            LOG.debug((Object)"Starting download of genemania");
            this.setDownloadState(DownloadState.RUNNING);
            String saveFilePath = this.getDestPath();
            URL url = new URL(this.URLStr);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            InputStream inputStream = httpConn.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            this.totalBytesRead = 0L;
            int percentCompleted = 0;
            int op = -1;
            while ((bytesRead = inputStream.read(buffer)) != -1 && !this.isCancelled()) {
                outputStream.write(buffer, 0, bytesRead);
                this.totalBytesRead += (long)bytesRead;
                percentCompleted = (int)(this.totalBytesRead * 1000L / this.filesize);
                if (op != percentCompleted) {
                    this.setProgress((double)this.totalBytesRead / (double)this.filesize);
                    this.setStatusMessage(Math.round((double)this.totalBytesRead / 1024.0 / 1024.0) + "M of " + Math.round((double)this.filesize / 1024.0 / 1024.0) + "M");
                }
                op = percentCompleted;
            }
            outputStream.close();
            httpConn.disconnect();
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            this.cancelDownload();
        }
        catch (Exception ex) {
            LOG.error((Object)("Unexpected exception: " + ex));
            this.cancelDownload();
        }
        return null;
    }

    public static enum DownloadState {
        RUNNING,
        FINISHED,
        CANCELLED,
        NOT_STARTED;

    }
}

