/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.region.RegionController;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.component.ProgressWheel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.DownloadTask;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.EntrezButton;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GeneManiaSettingsDialog;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GeneSetFetcher;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.GenemaniaInfoRetriever;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.RegionSet;

public class GeneManiaSubInspector
extends SubInspector
implements Listener<Gene> {
    private static final Log LOG = LogFactory.getLog(GeneManiaSubInspector.class);
    private final String name;
    private GenemaniaInfoRetriever genemania;
    private JPanel panel;
    private ProgressWheel progressBar;
    private JLabel progressMessage;
    protected KeyValuePairPanel kvp;
    private JPanel kvpPanel;
    private JPanel settingsPanel;
    private JButton settingsButton;
    private Set<Gene> genes;
    private GeneManiaSettingsDialog genemaniaSettings;
    private boolean rankByVarFreq;
    private Thread genemaniaAlgorithmThread;
    private boolean dataPresent = true;
    private int currSizeOfArray;
    private JPanel graph;
    private Listener<Object> geneListener;
    private DownloadTask currentDownloadTask;
    private JButton downloadGeneManiaButton = new JButton("Download GeneMANIA");

    public GeneManiaSubInspector() {
        this.name = "Related Genes";
    }

    public void setGeneListener(Listener<Object> geneListener) {
        this.geneListener = geneListener;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void buildPanel() {
        this.kvp = new KeyValuePairPanel(2);
        this.kvp.setKeysVisible(false);
        this.kvpPanel = new JPanel();
        this.kvpPanel.setLayout(new BorderLayout());
        this.kvpPanel.add((Component)this.kvp, "Center");
        JPanel currGenePanel = ViewUtil.getClearPanel();
        JPanel pMessagePanel = ViewUtil.getClearPanel();
        this.settingsPanel = ViewUtil.getClearPanel();
        this.progressBar = new ProgressWheel();
        this.progressBar.setVisible(false);
        this.progressMessage = new JLabel();
        this.progressMessage.setVisible(false);
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.settingsButton = new JButton("Settings");
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneManiaSubInspector.this.genemaniaSettings.showSettings();
                if (GeneManiaSubInspector.this.genemaniaSettings.getUpdateQueryNeeded()) {
                    GeneManiaSubInspector.this.rankByVarFreq = GeneManiaSubInspector.this.genemaniaSettings.getRankByVarFreq();
                    GeneManiaSubInspector.this.updateRelatedGenesPanel(GeneManiaSubInspector.this.genes);
                }
            }
        });
        pMessagePanel.add(this.progressMessage);
        this.settingsPanel.setLayout(new BorderLayout());
        this.settingsPanel.add((Component)this.settingsButton, "East");
        this.graph = ViewUtil.getClearPanel();
        this.panel.add(this.kvpPanel);
        this.panel.add(currGenePanel);
        this.panel.add(pMessagePanel);
        this.panel.add(this.progressBar);
        this.panel.add(this.settingsPanel);
        this.panel.add(this.graph);
    }

    private void showDownloadingLabel() {
        this.panel.removeAll();
        this.panel.add(new JLabel("GeneMANIA Downloading..."));
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void registerDownloadListener() {
        try {
            DownloadTask downloadTask = GenemaniaInfoRetriever.getGeneManiaDownloadTask();
            if (this.currentDownloadTask != downloadTask) {
                this.currentDownloadTask = downloadTask;
                DownloadTask dt = downloadTask;
                dt.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("downloadState")) {
                            DownloadTask.DownloadState ds = (DownloadTask.DownloadState)((Object)evt.getNewValue());
                            if (ds == DownloadTask.DownloadState.CANCELLED) {
                                GeneManiaSubInspector.this.panel.removeAll();
                                GeneManiaSubInspector.this.panel.add(GeneManiaSubInspector.this.downloadGeneManiaButton);
                                GeneManiaSubInspector.this.panel.revalidate();
                                GeneManiaSubInspector.this.panel.repaint();
                            } else if (ds == DownloadTask.DownloadState.FINISHED) {
                                if (DirectorySettings.isGeneManiaInstalled()) {
                                    try {
                                        GeneManiaSubInspector.this.dataPresent = true;
                                        GeneManiaSubInspector.this.genemania = new GenemaniaInfoRetriever();
                                        GeneManiaSubInspector.this.genemaniaSettings = new GeneManiaSettingsDialog(GeneManiaSubInspector.this.genemania);
                                        GeneManiaSubInspector.this.panel.removeAll();
                                        GeneManiaSubInspector.this.buildPanel();
                                        GeneManiaSubInspector.this.updateRelatedGenesPanel(GeneManiaSubInspector.this.genes);
                                    }
                                    catch (IOException e) {
                                        DialogUtils.displayMessage("Error downloading GeneMANIA files");
                                        LOG.error((Object)("Error downloading GeneMANIA files " + e));
                                        GeneManiaSubInspector.this.dataPresent = false;
                                    }
                                } else {
                                    LOG.error((Object)"Error downloading GeneMANIA files.");
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public JPanel getInfoPanel() {
        this.panel = ViewUtil.getClearPanel();
        try {
            if (!DirectorySettings.isGeneManiaInstalled()) {
                if (GenemaniaInfoRetriever.isGeneManiaDownloading()) {
                    this.showDownloadingLabel();
                    this.registerDownloadListener();
                } else {
                    this.downloadGeneManiaButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            try {
                                GeneManiaSubInspector.this.showDownloadingLabel();
                                GeneManiaSubInspector.this.registerDownloadListener();
                                GenemaniaInfoRetriever.getGeneManiaDownloadTask().execute();
                            }
                            catch (IOException e) {
                                DialogUtils.displayMessage("Error downloading GeneMANIA files " + e);
                                GeneManiaSubInspector.this.dataPresent = false;
                            }
                        }
                    });
                    this.panel.add(this.downloadGeneManiaButton);
                }
                this.dataPresent = false;
                LOG.debug((Object)("Returning panel " + (this.panel == null)));
                return this.panel;
            }
            this.genemania = new GenemaniaInfoRetriever();
            this.genemaniaSettings = new GeneManiaSettingsDialog(this.genemania);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
        }
        this.buildPanel();
        return this.panel;
    }

    public void setGenes(Set<Gene> geneSet) {
        if (geneSet != null) {
            if (!this.dataPresent) {
                this.genes = geneSet;
            } else {
                LOG.debug((Object)("Received genes " + geneSet));
                if (this.genes == null || !this.genes.equals(geneSet)) {
                    this.updateRelatedGenesPanel(geneSet);
                }
            }
        }
    }

    @Override
    public void handleEvent(Gene g) {
        if (g != null) {
            CopyOnWriteArraySet<Gene> gs = new CopyOnWriteArraySet<Gene>();
            gs.add(g);
            this.setGenes(gs);
        }
    }

    private JPopupMenu getRegionSetsMenu(Gene gene) {
        JPopupMenu regionSets = new JPopupMenu();
        final RegionController regionController = RegionController.getInstance();
        final Gene g = gene;
        try {
            Iterator<RegionSet> i$ = regionController.getRegionSets().iterator();
            while (i$.hasNext()) {
                RegionSet s;
                final RegionSet finalRegionSet = s = i$.next();
                JMenuItem menuItem = new JMenuItem(s.getName());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        try {
                            regionController.addToRegionSet(finalRegionSet, g.getChrom(), g.getStart(), g.getEnd(), g.getName());
                            DialogUtils.displayMessage(String.format("Successfully added %s to %s list", g.getName(), finalRegionSet.getName()));
                        }
                        catch (Exception ex) {
                            ClientMiscUtils.reportError(String.format("Unable to add %s to %s list: %%s", g.getName(), finalRegionSet.getName()), ex);
                        }
                    }
                });
                regionSets.add(menuItem);
            }
        }
        catch (Exception ex) {
            return new JPopupMenu();
        }
        return regionSets;
    }

    protected JButton[] getRowButtons(final Gene finalGene, String kvpKey) {
        JButton geneInspectorButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.INSPECTOR));
        geneInspectorButton.setToolTipText("Inspect this gene");
        geneInspectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (GeneManiaSubInspector.this.geneListener != null) {
                    GeneManiaSubInspector.this.geneListener.handleEvent(finalGene);
                }
            }
        });
        final JButton addToRegionListButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.ADDKVP));
        addToRegionListButton.setToolTipText("Add to Region List");
        addToRegionListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GeneManiaSubInspector.this.getRegionSetsMenu(finalGene).show(addToRegionListButton, 0, addToRegionListButton.getHeight());
            }
        });
        EntrezButton geneLinkButton = new EntrezButton(finalGene.getName());
        return new JButton[]{geneInspectorButton, addToRegionListButton, geneLinkButton};
    }

    private void addGeneToKeyValuePanel(Gene finalGene, int i) throws SQLException, RemoteException, InterruptedException {
        if (finalGene != null) {
            String key = Integer.toString(i);
            this.kvp.addKey(key);
            JLabel geneName = new JLabel(finalGene.getName());
            this.kvp.setValue(key, geneName);
            JButton[] buttons = this.getRowButtons(finalGene, key);
            DecimalFormat df = new DecimalFormat("######.##");
            JLabel vc = new JLabel(df.format(GeneSetFetcher.getInstance().getNormalizedVariantCount(finalGene)));
            this.kvp.setAdditionalColumn(key, 0, vc);
            int colInd = 2;
            for (JButton button : buttons) {
                this.kvp.setAdditionalColumn(key, colInd++, button);
            }
        }
    }

    protected void updateRelatedGenesPanel(Set<Gene> g) {
        this.genes = g;
        this.kvpPanel.removeAll();
        this.kvpPanel.invalidate();
        this.kvpPanel.updateUI();
        this.kvp = new KeyValuePairPanel(5);
        this.kvp.setKeysVisible(false);
        this.kvpPanel.add(this.kvp);
        this.progressBar.setVisible(true);
        this.progressMessage.setVisible(true);
        this.progressBar.setIndeterminate(true);
        this.progressMessage.setText("Querying GeneMANIA for related genes");
        final Object lock = new Object();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean setMsgOff = true;
                boolean buildGraph = true;
                if (!Thread.interrupted()) {
                    try {
                        List<String> geneNames = new ArrayList<String>();
                        for (Gene gene : GeneManiaSubInspector.this.genes) {
                            geneNames.add(gene.getName());
                        }
                        ArrayList notInGenemania = new ArrayList(geneNames);
                        notInGenemania.removeAll(GenemaniaInfoRetriever.getValidGenes(geneNames));
                        geneNames = GenemaniaInfoRetriever.getValidGenes(geneNames);
                        GeneManiaSubInspector.this.genemania.setGenes(geneNames);
                        if (notInGenemania.size() > 0) {
                            String message = "<html><center>Following gene(s) not found in GeneMANIA: ";
                            for (String invalidGene : notInGenemania) {
                                message = message + "<br>" + invalidGene;
                            }
                            message = message + "</center></html>";
                            GeneManiaSubInspector.this.progressMessage.setText(message);
                            setMsgOff = false;
                            buildGraph = false;
                        }
                        GeneSetFetcher geneSetFetcher = GeneSetFetcher.getInstance();
                        if (GeneManiaSubInspector.this.genemania.getGenes().size() > 0) {
                            int i = 1;
                            String zero = Integer.toString(0);
                            Font HEADER_FONT = new Font("Arial", 1, 10);
                            GeneManiaSubInspector.this.kvp.addKey(zero);
                            JLabel geneHeader = new JLabel("Gene".toUpperCase());
                            geneHeader.setFont(HEADER_FONT);
                            GeneManiaSubInspector.this.kvp.setValue(zero, geneHeader);
                            JLabel varFreqHeader = new JLabel("<html>VARIATION<br>FREQUENCY<br>(var/kb)</html>");
                            varFreqHeader.setFont(HEADER_FONT);
                            GeneManiaSubInspector.this.kvp.setAdditionalColumn(zero, 0, varFreqHeader);
                            JLabel genemaniaHeader = new JLabel("<html>GENEMANIA<br>SCORE</html>");
                            genemaniaHeader.setFont(HEADER_FONT);
                            if (Thread.interrupted()) {
                                throw new InterruptedException();
                            }
                            if (GeneManiaSubInspector.this.rankByVarFreq) {
                                Iterator<Gene> itr = geneSetFetcher.getGenesByNumVariants(GeneManiaSubInspector.this.genemania.getRelatedGeneNamesByScore()).iterator();
                                itr.next();
                                while (itr.hasNext()) {
                                    GeneManiaSubInspector.this.addGeneToKeyValuePanel(itr.next(), i++);
                                }
                                GeneManiaSubInspector.this.currSizeOfArray = i - 1;
                            } else {
                                Iterator<String> itr = GeneManiaSubInspector.this.genemania.getRelatedGeneNamesByScore().iterator();
                                itr.next();
                                LinkedList<String> tmp = new LinkedList<String>();
                                while (itr.hasNext()) {
                                    tmp.add(itr.next());
                                }
                                System.out.println("start populating table" + System.currentTimeMillis());
                                for (String foo : tmp) {
                                    GeneManiaSubInspector.this.addGeneToKeyValuePanel(GeneSetFetcher.getInstance().getGene(foo), i++);
                                }
                                System.out.println("done thread" + System.currentTimeMillis());
                                GeneManiaSubInspector.this.currSizeOfArray = i - 1;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)e);
                        buildGraph = false;
                    }
                    catch (GenemaniaInfoRetriever.NoRelatedGenesInfoException e) {
                        LOG.error((Object)e);
                        GeneManiaSubInspector.this.progressMessage.setText(e.getMessage());
                        setMsgOff = false;
                        buildGraph = false;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        buildGraph = false;
                        ClientMiscUtils.reportError("Error retrieving data from GeneMANIA: %s", ex);
                    }
                    catch (Error e) {
                        LOG.error((Object)e);
                    }
                    finally {
                        GeneManiaSubInspector.this.progressBar.setIndeterminate(false);
                        GeneManiaSubInspector.this.progressBar.setValue(0);
                        GeneManiaSubInspector.this.progressBar.setVisible(false);
                        if (setMsgOff) {
                            GeneManiaSubInspector.this.progressMessage.setVisible(false);
                        }
                    }
                }
                Object object = lock;
                synchronized (object) {
                    lock.notify();
                }
            }
        };
        if (this.genemaniaAlgorithmThread == null) {
            this.genemaniaAlgorithmThread = new Thread(r);
        } else {
            this.genemaniaAlgorithmThread.interrupt();
            this.genemaniaAlgorithmThread = new Thread(r);
        }
        final Runnable geneDescriptionFetcher = new Runnable(){

            @Override
            public void run() {
                for (int j = 1; j <= GeneManiaSubInspector.this.currSizeOfArray; ++j) {
                    try {
                        String geneName = GeneManiaSubInspector.this.kvp.getValue(Integer.toString(j));
                        Gene gene = GeneSetFetcher.getInstance().getGene(geneName);
                        String d = gene.getDescription();
                        GeneManiaSubInspector.this.kvp.setToolTipForValue(Integer.toString(j), d);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        this.genemaniaAlgorithmThread.start();
        Runnable r2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = lock;
                    synchronized (object) {
                        lock.wait();
                        Thread toolTipGenerator = new Thread(geneDescriptionFetcher);
                        Thread varFreqCalculator = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                for (int i = 1; i <= GeneManiaSubInspector.this.currSizeOfArray; ++i) {
                                    try {
                                        String geneName = GeneManiaSubInspector.this.kvp.getValue(Integer.toString(i));
                                        Gene gene = GeneSetFetcher.getInstance().getGene(geneName);
                                        GeneManiaSubInspector.this.kvp.setAdditionalColumn(Integer.toString(i), 0, new JLabel(Double.toString(GeneSetFetcher.getInstance().getNormalizedVariantCount(gene))));
                                        GeneManiaSubInspector.this.kvp.invalidate();
                                        GeneManiaSubInspector.this.kvp.updateUI();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                        });
                        toolTipGenerator.start();
                        varFreqCalculator.start();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t2 = new Thread(r2);
        t2.start();
    }
}

