/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.filter.FilterController;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.reference.ReferenceController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;

public class GeneSetFetcher {
    Map<String, Gene> geneDictionary = new HashMap<String, Gene>();
    private static GeneSetFetcher instance;

    private GeneSetFetcher() {
        try {
            this.initializeGeneDictionary();
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Unable to initialise gene dictionary: %s", ex);
        }
    }

    public static GeneSetFetcher getInstance() {
        if (instance == null) {
            instance = new GeneSetFetcher();
        }
        return instance;
    }

    public Map<String, Gene> getGeneDictionary() {
        return this.geneDictionary;
    }

    private void initializeGeneDictionary() throws SQLException, RemoteException {
        for (Gene currentGene : GeneSetController.getInstance().getCurrentGenes()) {
            this.geneDictionary.put(currentGene.getName(), currentGene);
        }
    }

    public List<Gene> getGenesByNumVariants(List<String> relatedGenes) {
        List<Gene> genes = this.getGenes(relatedGenes);
        Collections.sort(genes, new Comparator<Gene>(){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                try {
                    double normalizedVarFreq1 = GeneSetFetcher.this.getNormalizedVariantCount(gene1);
                    double normalizedVarFreq2 = GeneSetFetcher.this.getNormalizedVariantCount(gene2);
                    if (normalizedVarFreq1 == normalizedVarFreq2) {
                        return 0;
                    }
                    if (normalizedVarFreq1 < normalizedVarFreq2) {
                        return 1;
                    }
                    return -1;
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Unable to initialise gene dictionary: %s", ex);
                    return 0;
                }
            }
        });
        return genes;
    }

    public double getNormalizedVariantCount(Gene gene) throws SQLException, RemoteException, InterruptedException {
        double varCount = 0.0;
        try {
            varCount = MedSavantClient.VariantManager.getVariantCountInRange(LoginController.getSessionID(), ProjectController.getInstance().getCurrentProjectID(), ReferenceController.getInstance().getCurrentReferenceID(), FilterController.getInstance().getAllFilterConditions(), gene.getChrom(), gene.getStart(), gene.getEnd());
        }
        catch (SessionExpiredException ex) {
            MedSavantExceptionHandler.handleSessionExpiredException(ex);
            return 0.0;
        }
        double length = gene.getEnd() - gene.getStart();
        return ClientMiscUtils.round(varCount / length * 1000.0, 4);
    }

    public List<Gene> getGenes(List<String> geneNames) {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        Iterator<String> itr = geneNames.iterator();
        itr.next();
        while (itr.hasNext()) {
            String name = itr.next();
            Gene currGene = this.getGene(name);
            if (currGene == null) continue;
            genes.add(currGene);
        }
        return genes;
    }

    public Gene getGene(String geneName) {
        return this.geneDictionary.get(geneName);
    }
}

