/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import org.ut.biolab.medsavant.shared.model.GenomicRegion;

public class SimpleVariant {
    private final long start_pos;
    private final long end_pos;
    private final String chr;
    private final String ref;
    private final String alt;
    private final String type;

    public SimpleVariant(String chr, long start_pos, long end_pos, String ref, String alt, String type) {
        this.chr = chr;
        this.start_pos = start_pos;
        this.end_pos = end_pos;
        this.ref = ref;
        this.alt = alt;
        this.type = type;
    }

    public long getStartPosition() {
        return this.start_pos;
    }

    public long getEndPosition() {
        return this.end_pos;
    }

    public String getChromosome() {
        return this.chr;
    }

    public String getReference() {
        return this.ref;
    }

    public String getAlternate() {
        return this.alt;
    }

    public String getType() {
        return this.type;
    }

    public GenomicRegion getGenomicRegion(String name) {
        return new GenomicRegion(name, this.chr, (int)this.start_pos, (int)this.end_pos);
    }

    public GenomicRegion getGenomicRegion() {
        return this.getGenomicRegion("Chr: " + this.chr + "Pos: " + this.start_pos + "-" + this.end_pos);
    }

    public String toString() {
        return "SimpleVariant{startpos=" + this.start_pos + ", endpos=" + this.end_pos + ", chr=" + this.chr + ", ref=" + this.ref + ", alt=" + this.alt + ", type=" + this.type + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (int)(this.start_pos ^ this.start_pos >>> 32);
        hash = 37 * hash + (int)(this.end_pos ^ this.end_pos >>> 32);
        hash = 37 * hash + (this.chr != null ? this.chr.hashCode() : 0);
        hash = 37 * hash + (this.ref != null ? this.ref.hashCode() : 0);
        hash = 37 * hash + (this.alt != null ? this.alt.hashCode() : 0);
        hash = 37 * hash + (this.type != null ? this.type.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleVariant other = (SimpleVariant)obj;
        if (this.start_pos != other.start_pos) {
            return false;
        }
        if (this.end_pos != other.end_pos) {
            return false;
        }
        if (this.chr == null ? other.chr != null : !this.chr.equals(other.chr)) {
            return false;
        }
        if (this.ref == null ? other.ref != null : !this.ref.equals(other.ref)) {
            return false;
        }
        if (this.alt == null ? other.alt != null : !this.alt.equals(other.alt)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

