/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.geneset.GeneSetController;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;
import org.ut.biolab.medsavant.client.view.app.AppDirectory;
import org.ut.biolab.medsavant.client.view.component.KeyValuePairPanel;
import org.ut.biolab.medsavant.client.view.genetics.inspector.SubInspector;
import org.ut.biolab.medsavant.client.view.genetics.variantinfo.SimpleVariant;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.model.Gene;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import savant.controller.LocationController;
import savant.util.Range;

public class SimpleVariantSubInspector
extends SubInspector {
    private Listener<Object> geneListener;
    private static final String KEY_POSITION = "Position";
    private static final String KEY_GENES = "Genes";
    private static final String KEY_REF = "Reference";
    private static final String KEY_ALT = "Alternate";
    private static final String KEY_TYPE = "Type";
    private static final String URL_CHARSET = "UTF-8";
    private Collection<Gene> genes;
    private KeyValuePairPanel p;
    private JComboBox geneBox;
    private SimpleVariant selectedVariant;

    public SimpleVariant getSimpleVariant() {
        return this.selectedVariant;
    }

    public Gene getSelectedGene() {
        return (Gene)this.geneBox.getSelectedItem();
    }

    public void setGeneListener(Listener<Object> listener) {
        this.geneListener = listener;
    }

    @Override
    public String getName() {
        return "Basic Variant Information";
    }

    @Override
    public JPanel getInfoPanel() {
        if (this.p == null) {
            this.p = new KeyValuePairPanel(4);
            this.p.addKey(KEY_POSITION);
            this.p.addKey(KEY_REF);
            this.p.addKey(KEY_ALT);
            this.p.addKey(KEY_TYPE);
            this.p.addKey(KEY_GENES);
            this.geneBox = new JComboBox();
            Dimension d = new Dimension(150, 22);
            this.geneBox.setMinimumSize(d);
            this.geneBox.setPreferredSize(d);
            this.geneBox.setMaximumSize(d);
            ViewUtil.makeSmall(this.geneBox);
            this.p.setValue(KEY_GENES, this.geneBox);
            JButton genomeBrowserButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.BROWSER));
            genomeBrowserButton.setToolTipText("View region in genome browser");
            genomeBrowserButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LocationController.getInstance().setLocation(SimpleVariantSubInspector.this.selectedVariant.getChromosome(), new Range((int)(SimpleVariantSubInspector.this.selectedVariant.getStartPosition() - 20L), (int)(SimpleVariantSubInspector.this.selectedVariant.getEndPosition() + 21L)));
                    AppDirectory.launchApp(AppDirectory.BuiltInApp.GENOME_BROWSER);
                }
            });
            JButton geneInspectorButton = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.INSPECTOR));
            geneInspectorButton.setToolTipText("Inspect this gene");
            geneInspectorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (SimpleVariantSubInspector.this.geneListener != null) {
                        SimpleVariantSubInspector.this.geneListener.handleEvent((Gene)SimpleVariantSubInspector.this.geneBox.getSelectedItem());
                    }
                }
            });
            this.p.setAdditionalColumn(KEY_GENES, 0, geneInspectorButton);
            JLabel l = new JLabel("This will eventually show a chart");
            int col = 0;
            this.p.setAdditionalColumn(KEY_POSITION, col, KeyValuePairPanel.getCopyButton(KEY_POSITION, this.p));
            this.p.setAdditionalColumn(KEY_POSITION, ++col, genomeBrowserButton);
        }
        return this.p;
    }

    public boolean showHeader() {
        return false;
    }

    private String checkNull(Object o) {
        if (o == null) {
            return "<NONE>";
        }
        String s = o.toString();
        if (s.equals("")) {
            return "<NONE>";
        }
        return s;
    }

    private void generateGeneIntersections(SimpleVariant r) {
        try {
            if (this.genes == null) {
                this.genes = GeneSetController.getInstance().getCurrentGenes();
            }
            JComboBox b = this.geneBox;
            b.removeAllItems();
            b.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    if (value != null) {
                        Gene g = (Gene)value;
                        value = g.getName() + "  " + MiscUtils.numToStringWithOrder(g.getEnd() - g.getStart()) + "bp";
                    }
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
            });
            ArrayList<Gene> intersectingGenes = new ArrayList<Gene>();
            for (Gene g : this.genes) {
                if (!MiscUtils.homogenizeSequence(g.getChrom()).equals(MiscUtils.homogenizeSequence(r.getChromosome())) || !MiscUtils.doesIntersect((int)r.getStartPosition(), (int)r.getEndPosition(), g.getStart(), g.getEnd())) continue;
                intersectingGenes.add(g);
            }
            Collections.sort(intersectingGenes, new Comparator<Gene>(){

                @Override
                public int compare(Gene t, Gene t1) {
                    int l = Math.abs(t.getEnd() - t.getStart());
                    int l1 = Math.abs(t1.getEnd() - t1.getStart());
                    return new Integer(l).compareTo(new Integer(l1));
                }
            });
            for (Gene g : intersectingGenes) {
                b.addItem(g);
            }
        }
        catch (Exception ex) {
            ClientMiscUtils.reportError("Error fetching genes: %s", ex);
        }
    }

    private Component getFilterButton(String key) {
        JButton button = ViewUtil.getTexturedButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.FILTER));
        button.setToolTipText("Filter " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
            }
        });
        return button;
    }

    private Component getChartButton(final String key) {
        JToggleButton button = ViewUtil.getTexturedToggleButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CHART_SMALL));
        button.setToolTipText("Chart " + key);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SimpleVariantSubInspector.this.p.toggleDetailVisibility(key);
            }
        });
        return button;
    }

    private Component getNCBIButton(final String key) {
        JButton ncbiButton = ViewUtil.getTexturedButton("", IconFactory.getInstance().getIcon(IconFactory.StandardIcon.LINKOUT));
        ncbiButton.setToolTipText("Lookup " + key + " at NCBI");
        ncbiButton.addActionListener(new ActionListener(){
            String baseUrl = "http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?searchType=adhoc_search&rs=";

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    URL url = new URL(this.baseUrl + URLEncoder.encode(SimpleVariantSubInspector.this.p.getValue(key), SimpleVariantSubInspector.URL_CHARSET));
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (Exception ex) {
                    ClientMiscUtils.reportError("Problem launching NCBI website: %s", ex);
                }
            }
        });
        return ncbiButton;
    }

    private KeyValuePairPanel getInfoKVPPanel(String customInfo) {
        String[] pairs = customInfo.split(";");
        KeyValuePairPanel kvp = new KeyValuePairPanel();
        for (String pair : pairs) {
            String[] splitPair = pair.split("=");
            if (splitPair.length != 2) continue;
            kvp.addKey(splitPair[0]);
            kvp.setValue(splitPair[0], splitPair[1]);
        }
        return kvp;
    }

    public void setSimpleVariant(SimpleVariant r) {
        if (this.p == null) {
            return;
        }
        this.selectedVariant = r;
        String posVal = r.getChromosome() + ":" + ViewUtil.numToString(r.getStartPosition()) + " - " + r.getEndPosition();
        this.p.setValue(KEY_POSITION, posVal);
        this.p.setValue(KEY_REF, r.getReference());
        this.p.setValue(KEY_ALT, r.getAlternate());
        this.p.setValue(KEY_TYPE, this.checkNull(r.getType()));
        this.p.simpleEllipsify();
        this.generateGeneIntersections(r);
    }
}

