/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.genetics.variantinfo;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.TableHeaderPopupMenuCustomizer;
import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.pivot.AggregateTable;
import com.jidesoft.pivot.AggregateTableHeader;
import com.jidesoft.pivot.AggregateTablePopupMenuCustomizer;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotValueProvider;
import com.jidesoft.pivot.SummaryCalculator;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.MedSavantClient;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.project.ProjectController;
import org.ut.biolab.medsavant.client.util.CacheController;
import org.ut.biolab.medsavant.client.util.MedSavantExceptionHandler;
import org.ut.biolab.medsavant.client.view.component.SplitScreenPanel;
import org.ut.biolab.medsavant.client.view.component.WaitPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.shared.format.BasicPatientColumns;
import org.ut.biolab.medsavant.shared.format.BasicVariantColumns;
import org.ut.biolab.medsavant.shared.model.Cohort;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.util.ModificationType;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public abstract class VariantFrequencyAggregatePane
extends JPanel {
    private static final int MAXIMIUM_VARIANTS_TO_FETCH = 1000;
    private static final ImageIcon LINK_BUTTON_ICON = IconFactory.getInstance().getIcon(IconFactory.StandardIcon.INSPECTOR);
    private static final int BUTTON_COLUMN_PREFERRED_WIDTH = LINK_BUTTON_ICON.getIconWidth() + 20;
    private static final Cohort ALL_INDIVIDUALS_COHORT = new Cohort(-1, "All Individuals");
    private static final String ALL_INDIVIDUALS_FAMILY = "All Individuals";
    private static final Font TABLE_FONT_LARGE = ViewUtil.detailFontPlain;
    private static final Dimension PREFERRED_SIZE = new Dimension(300, 300);
    private static final String COHORT_COLUMN_NAME = "Cohort";
    private static final String FAMILY_COLUMN_NAME = BasicPatientColumns.FAMILY_ID.getAlias();
    private static final String DNAID_COLUMN_NAME = BasicVariantColumns.DNA_ID.getAlias();
    private Set<String> individualsWithVariantAtThisPosition;
    private String[] aggregateColumns;
    private AggregateTableHeader header;
    private AggregateTable aggregateTable;
    private SubInspectorTableModel tableModel = new SubInspectorTableModel();
    private JPanel innerPanel;
    private boolean isSplitScreen = false;
    private static final Log LOG = LogFactory.getLog(VariantFrequencyAggregatePane.class);
    private int dnaIDIndex;
    private int buttonIndex;
    private int fromColumnIndex = -1;
    private int toColumnIndex = -1;
    private MapRefresher mapRefresher;
    private final Map<String, Set<Cohort>> dnaIDCohortMap = new HashMap<String, Set<Cohort>>();
    private final Map<Cohort, Set<String>> cohortDNAIDMap = new HashMap<Cohort, Set<String>>();
    private final Map<String, Set<String>> dnaIDFamilyIDMap = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> familyIDdnaIDMap = new HashMap<String, Set<String>>();
    private Listener<Object> variantSelectionListener;
    private JLabel title;
    private SplitScreenPanel splitScreenPanel;
    private String[] columnNames;

    public abstract Object[] getRow(Cohort var1, String var2, VariantRecord var3);

    public abstract String getTitle(String var1);

    public abstract void selectVariant(VariantRecord var1);

    public VariantFrequencyAggregatePane(String[] columnNames) {
        columnNames = (String[])ArrayUtils.removeElement((Object[])columnNames, (Object)DNAID_COLUMN_NAME);
        columnNames = (String[])ArrayUtils.removeElement((Object[])columnNames, (Object)COHORT_COLUMN_NAME);
        columnNames = (String[])ArrayUtils.removeElement((Object[])columnNames, (Object)FAMILY_COLUMN_NAME);
        columnNames = (String[])ArrayUtils.add((Object[])ArrayUtils.add((Object[])columnNames, (Object)DNAID_COLUMN_NAME), (Object)"");
        columnNames = (String[])ArrayUtils.addAll((Object[])new String[]{COHORT_COLUMN_NAME, FAMILY_COLUMN_NAME}, (Object[])columnNames);
        this.dnaIDIndex = columnNames.length - 2;
        this.buttonIndex = columnNames.length - 1;
        this.columnNames = columnNames;
        this.refreshMaps();
        this.innerPanel = new JPanel();
        this.innerPanel.setLayout(new BoxLayout(this.innerPanel, 1));
        this.innerPanel.add(new WaitPanel("Loading DNA IDs..."));
        this.setLayout(new BoxLayout(this, 1));
        this.title = new JLabel();
        this.title.setFont(this.title.getFont().deriveFont(1));
        this.add(this.innerPanel);
        this.setupAggregateColumns(columnNames[0]);
        VariantFrequencyAggregatePane instance = this;
        String dbg = columnNames[0];
        CacheController.getInstance().addListener(new Listener<ModificationType>(){

            @Override
            public void handleEvent(ModificationType modificationType) {
                if (modificationType == ModificationType.COHORT || modificationType == ModificationType.PATIENT) {
                    VariantFrequencyAggregatePane.this.refreshMaps();
                }
            }
        });
    }

    private void setupAggregateColumns(String column) {
        String[] ag = new String[this.columnNames.length - 2];
        ag[0] = column;
        int j = 1;
        for (int i = 0; i < this.columnNames.length - 2; ++i) {
            if (this.columnNames[i].equals(ag[0])) continue;
            ag[j++] = this.columnNames[i];
        }
        this.aggregateColumns = ag;
    }

    public void reaggregate() {
        this.aggregateTable.aggregate(this.aggregateColumns);
        this.setupButtonColumn();
        this.expandAllButLast();
        this.title.setText(this.getTitle(this.aggregateColumns[0]));
        this.aggregateTable.revalidate();
        this.aggregateTable.repaint();
    }

    public String getFirstColumn() {
        if (this.aggregateColumns != null) {
            return this.aggregateColumns[0];
        }
        return COHORT_COLUMN_NAME;
    }

    public void groupBy(String column) {
        this.setupAggregateColumns(column);
        this.reaggregate();
    }

    public void setVariantSelectionListener(Listener<Object> l) {
        this.variantSelectionListener = l;
    }

    public VariantFrequencyAggregatePane setSplitScreenPanel(SplitScreenPanel s) {
        this.splitScreenPanel = s;
        return this;
    }

    public boolean isSplit() {
        return this.isSplitScreen;
    }

    public void splitScreen() {
        if (this.splitScreenPanel != null) {
            if (this.splitScreenPanel.isSplit()) {
                this.splitScreenPanel.unsplitScreen();
            }
            this.splitScreenPanel.splitScreen(this.innerPanel);
            this.isSplitScreen = true;
            this.aggregateTable.setFont(TABLE_FONT_LARGE);
            this.header.setFont(TABLE_FONT_LARGE);
            this.revalidate();
            this.repaint();
        }
    }

    public void unsplitScreen() {
        if (this.splitScreenPanel != null && this.splitScreenPanel.isSplit()) {
            this.splitScreenPanel.unsplitScreen();
            this.isSplitScreen = false;
        }
    }

    void showWaitPanel(String msg) {
        this.innerPanel.removeAll();
        this.innerPanel.add(new WaitPanel(msg));
        this.innerPanel.revalidate();
        this.innerPanel.repaint();
    }

    public void setVariantRecords(Set<VariantRecord> records) {
        this.innerPanel.removeAll();
        this.tableModel.setValues(records);
        this.aggregateTable = new AggregateTable(this.tableModel){

            public boolean isCellEditable(int rowIndex, int colIndex) {
                return colIndex == VariantFrequencyAggregatePane.this.buttonIndex;
            }

            public TableCellRenderer getCellRenderer(int rowIndex, int columnIndex) {
                final TableCellRenderer renderer = super.getCellRenderer(rowIndex, columnIndex);
                return new TableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable jtable, Object o, boolean bln, boolean bln1, int i, int i1) {
                        return renderer.getTableCellRendererComponent(jtable, o, false, false, i, i1);
                    }
                };
            }

            protected AggregateTable.DraggingHandler createDraggingColumnPropertyChangeListener() {
                return new AggregateTable.DraggingHandler(){

                    public void columnMoved(TableColumnModelEvent e) {
                        if (VariantFrequencyAggregatePane.this.fromColumnIndex == -1) {
                            VariantFrequencyAggregatePane.this.fromColumnIndex = e.getFromIndex();
                        }
                        VariantFrequencyAggregatePane.this.toColumnIndex = e.getToIndex();
                    }
                };
            }
        };
        this.header = new AggregateTableHeader((JTable)this.aggregateTable);
        this.header.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (VariantFrequencyAggregatePane.this.toColumnIndex != -1 && (VariantFrequencyAggregatePane.this.toColumnIndex == 0 || VariantFrequencyAggregatePane.this.fromColumnIndex == 0 || VariantFrequencyAggregatePane.this.toColumnIndex >= VariantFrequencyAggregatePane.this.dnaIDIndex || VariantFrequencyAggregatePane.this.fromColumnIndex >= VariantFrequencyAggregatePane.this.dnaIDIndex)) {
                    VariantFrequencyAggregatePane.this.aggregateTable.moveColumn(VariantFrequencyAggregatePane.this.toColumnIndex, VariantFrequencyAggregatePane.this.fromColumnIndex);
                    String msg = "This column cannot be moved.";
                    DialogUtils.displayMessage(msg);
                } else {
                    for (int columnHeaderIndex = 0; columnHeaderIndex < VariantFrequencyAggregatePane.this.header.getColumnModel().getColumnCount() - 2; ++columnHeaderIndex) {
                        String columnTitle;
                        ((VariantFrequencyAggregatePane)VariantFrequencyAggregatePane.this).aggregateColumns[columnHeaderIndex] = columnTitle = (String)VariantFrequencyAggregatePane.this.header.getColumnModel().getColumn(columnHeaderIndex).getHeaderValue();
                    }
                    VariantFrequencyAggregatePane.this.reaggregate();
                }
                VariantFrequencyAggregatePane.this.fromColumnIndex = -1;
                VariantFrequencyAggregatePane.this.toColumnIndex = -1;
            }
        });
        this.header.setAutoFilterEnabled(false);
        this.header.setReorderingAllowed(true);
        this.header.setFont(TABLE_FONT_LARGE);
        this.aggregateTable.setTableHeader((JTableHeader)this.header);
        this.aggregateTable.setAutoResizeMode(4);
        this.aggregateTable.setFont(TABLE_FONT_LARGE);
        PivotField f = this.aggregateTable.getAggregateTableModel().getField(BasicVariantColumns.DNA_ID.getAlias());
        f.setSummaryType(7);
        this.aggregateTable.getAggregateTableModel().setSummaryCalculator(new SummaryCalculator(){
            private Set<String> collapsedDNAIDs = new HashSet<String>();
            private Values lastRowValues;
            private int valueCount = 0;
            private final int SUMMARY_FREQ = 7;

            public void addValue(PivotValueProvider dataModel, PivotField field, Values rowValues, Values columnValues, Object object) {
                if (field.getName().equals(BasicVariantColumns.DNA_ID.getAlias())) {
                    this.collapsedDNAIDs.add((String)object);
                    this.lastRowValues = rowValues;
                } else {
                    this.lastRowValues = null;
                }
                ++this.valueCount;
            }

            public void addValue(Object o) {
                LOG.error((Object)"Unexpected method invocation in OtherIndividualsSubInspector (1)");
            }

            public void addValue(IPivotDataModel ipdm, PivotField pf, int i, int i1, Object o) {
                LOG.error((Object)"Unexpected method invocation in OtherIndividualsSubInspector (2)");
            }

            public void addValue(PivotValueProvider pvp, PivotField pf, Object o) {
                LOG.error((Object)"Unexpected method invocation in OtherIndividualsSubInspector (3)");
            }

            public void clear() {
                this.collapsedDNAIDs.clear();
                this.valueCount = 0;
                this.lastRowValues = null;
            }

            public Object getSummaryResult(int type) {
                if (this.lastRowValues == null) {
                    return null;
                }
                int numIndividuals = this.getNumberOfIndividualsInGroup(this.lastRowValues.getValueAt(0));
                return new Frequency(this.collapsedDNAIDs.size(), numIndividuals);
            }

            private int getNumberOfIndividualsInGroup(Value v) {
                if (VariantFrequencyAggregatePane.this.aggregateColumns[0].equals(VariantFrequencyAggregatePane.COHORT_COLUMN_NAME)) {
                    Set dnaIds = (Set)VariantFrequencyAggregatePane.this.cohortDNAIDMap.get((Cohort)v.getValue());
                    return ((Set)VariantFrequencyAggregatePane.this.cohortDNAIDMap.get((Cohort)v.getValue())).size();
                }
                if (VariantFrequencyAggregatePane.this.aggregateColumns[0].equals(BasicPatientColumns.FAMILY_ID.getAlias())) {
                    return ((Set)VariantFrequencyAggregatePane.this.familyIDdnaIDMap.get((String)v.getValue())).size();
                }
                LOG.error((Object)"Invalid first column");
                return -1;
            }

            public long getCount() {
                return this.valueCount;
            }

            public int getNumberOfSummaries() {
                return 1;
            }

            public String getSummaryName(Locale locale, int i) {
                return "Frequency";
            }

            public int[] getAllowedSummaries(Class<?> type) {
                return new int[]{7};
            }

            public int[] getAllowedSummaries(Class<?> type, ConverterContext cc) {
                return new int[]{7};
            }
        });
        TableHeaderPopupMenuInstaller installer = new TableHeaderPopupMenuInstaller((JTable)this.aggregateTable);
        installer.addTableHeaderPopupMenuCustomizer((TableHeaderPopupMenuCustomizer)new AggregateTablePopupMenuCustomizer(){

            public void customizePopupMenu(JTableHeader header, JPopupMenu popup, int clickingColumn) {
                super.customizePopupMenu(header, popup, clickingColumn);
                for (int i = 0; i < popup.getComponentCount(); ++i) {
                    String menuItemName = popup.getComponent(i).getName();
                    if ("HeaderTable.collapseColumn".equals(menuItemName) || "HeaderTable.collapseAll".equals(menuItemName) || "HeaderTable.expandColumn".equals(menuItemName) || "HeaderTable.expandAll".equals(menuItemName) || "HeaderTable.group".equals(menuItemName) || "HeaderTable.ungroup".equals(menuItemName)) continue;
                    popup.remove(popup.getComponent(i));
                }
            }
        });
        this.aggregateTable.getAggregateTableModel().setSummaryMode(true);
        this.aggregateTable.aggregate(this.aggregateColumns);
        this.aggregateTable.setShowContextMenu(false);
        this.expandAllButLast();
        this.setupButtonColumn();
        JScrollPane jsp = new JScrollPane((Component)this.aggregateTable);
        jsp.setPreferredSize(PREFERRED_SIZE);
        JPanel bp = new JPanel();
        bp.setLayout(new BoxLayout(bp, 0));
        JButton closeButton = new JButton(IconFactory.getInstance().getIcon(IconFactory.StandardIcon.CLOSE));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VariantFrequencyAggregatePane.this.unsplitScreen();
            }
        });
        bp.add(Box.createHorizontalGlue());
        bp.add(this.title);
        bp.add(Box.createHorizontalGlue());
        bp.add(closeButton);
        this.innerPanel.add(bp);
        this.innerPanel.add(jsp);
        this.reaggregate();
        this.innerPanel.revalidate();
        this.innerPanel.repaint();
    }

    private void setAggregateColumns(String[] ac) {
        this.aggregateColumns = ac;
    }

    private void expandAllButLast() {
        this.aggregateTable.expandAll();
        for (int rowIndex = 0; rowIndex <= this.aggregateTable.getAggregateTableModel().getRowCount(); ++rowIndex) {
            this.aggregateTable.collapse(rowIndex, this.dnaIDIndex - 1);
        }
    }

    private void addFamilyToDnaId(String family, String dnaID) {
        Set<String> familyIds = this.dnaIDFamilyIDMap.get(dnaID);
        if (familyIds == null) {
            familyIds = new HashSet<String>();
        }
        familyIds.add(family);
        this.dnaIDFamilyIDMap.put(dnaID, familyIds);
        Set<String> dnaIDs = this.familyIDdnaIDMap.get(family);
        if (dnaIDs == null) {
            dnaIDs = new HashSet<String>();
        }
        dnaIDs.add(dnaID);
        this.familyIDdnaIDMap.put(family, dnaIDs);
    }

    private void addCohortToDnaId(Cohort cohort, String dnaId) {
        Set<Cohort> cohorts = this.dnaIDCohortMap.get(dnaId);
        if (cohorts == null) {
            cohorts = new HashSet<Cohort>();
        }
        cohorts.add(cohort);
        this.dnaIDCohortMap.put(dnaId, cohorts);
        Set<String> dnaIDs = this.cohortDNAIDMap.get(cohort);
        if (dnaIDs == null) {
            dnaIDs = new HashSet<String>();
        }
        dnaIDs.add(dnaId);
        this.cohortDNAIDMap.put(cohort, dnaIDs);
    }

    private void refreshMaps() {
        if (this.mapRefresher != null && this.mapRefresher.isAlive()) {
            LOG.info((Object)"Interrupting map refresher");
            this.mapRefresher.interrupt();
        }
        this.mapRefresher = new MapRefresher();
        this.mapRefresher.start();
    }

    private void setupButtonColumn() {
        new ButtonColumn((JTable)this.aggregateTable, this.buttonIndex);
        this.aggregateTable.getColumnModel().getColumn(this.buttonIndex).setPreferredWidth(BUTTON_COLUMN_PREFERRED_WIDTH + 5);
        this.aggregateTable.getColumnModel().getColumn(this.buttonIndex).setMaxWidth(BUTTON_COLUMN_PREFERRED_WIDTH + 5);
        this.aggregateTable.getColumnModel().getColumn(this.buttonIndex).setMinWidth(BUTTON_COLUMN_PREFERRED_WIDTH + 5);
    }

    public class ButtonColumn
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    MouseListener {
        private JTable table;
        private JButton renderButton;
        private Object editorValue;
        private boolean isButtonColumnEditor;

        public ButtonColumn(JTable table, int column) {
            this.table = table;
            this.renderButton = new JButton();
            TableColumnModel columnModel = table.getColumnModel();
            columnModel.getColumn(column).setCellRenderer(this);
            columnModel.getColumn(column).setCellEditor(this);
            table.removeMouseListener(this);
            table.addMouseListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, final Object value, boolean isSelected, int row, int column) {
            if (value instanceof VariantRecord) {
                JButton b = new JButton(LINK_BUTTON_ICON);
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        ButtonColumn.this.fireEditingStopped();
                        VariantRecord vr = (VariantRecord)value;
                        System.out.println("Got VariantRecord " + vr);
                        VariantFrequencyAggregatePane.this.selectVariant(vr);
                    }
                });
                b.setToolTipText("View information for this variant and individual in Inspector");
                JPanel p = new JPanel();
                p.setLayout(new BoxLayout(p, 0));
                p.setBackground(VariantFrequencyAggregatePane.this.aggregateTable.getBackground());
                p.add(Box.createHorizontalGlue());
                p.add(b);
                p.add(Box.createHorizontalGlue());
                return p;
            }
            return new JLabel("");
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorValue;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderButton.setBackground(table.getBackground());
            if (value instanceof VariantRecord) {
                this.renderButton.setIcon(LINK_BUTTON_ICON);
                this.renderButton.setToolTipText("View information for this variant and individual in Inspector");
                JPanel p = new JPanel();
                p.setBackground(VariantFrequencyAggregatePane.this.aggregateTable.getBackground());
                p.setLayout(new BoxLayout(p, 0));
                p.add(Box.createHorizontalGlue());
                p.add(this.renderButton);
                p.add(Box.createHorizontalGlue());
                return p;
            }
            return new JLabel("");
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.table.isEditing() && this.table.getCellEditor() == this) {
                this.isButtonColumnEditor = true;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.isButtonColumnEditor && this.table.isEditing()) {
                this.table.getCellEditor().stopCellEditing();
            }
            this.isButtonColumnEditor = false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class Frequency {
        private int numerator;
        private int denominator;

        public Frequency(int numerator, int denominator) {
            this.numerator = numerator;
            this.denominator = denominator;
        }

        public String toString() {
            double frac = (double)this.numerator / (double)this.denominator;
            DecimalFormat df = new DecimalFormat("######.##");
            String ret = this.numerator + " / " + this.denominator + " (" + df.format(frac) + ")";
            return ret;
        }
    }

    private class MapRefresher
    extends Thread {
        private MapRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = VariantFrequencyAggregatePane.this.dnaIDCohortMap;
            synchronized (map) {
                VariantFrequencyAggregatePane.this.dnaIDCohortMap.clear();
                VariantFrequencyAggregatePane.this.dnaIDFamilyIDMap.clear();
                try {
                    Cohort[] cohorts;
                    String sessionID = LoginController.getSessionID();
                    for (Cohort cohort : cohorts = MedSavantClient.CohortManager.getCohorts(sessionID, ProjectController.getInstance().getCurrentProjectID())) {
                        List<String> dnaIds = MedSavantClient.CohortManager.getDNAIDsForCohort(sessionID, cohort.getId());
                        for (String dnaId : dnaIds) {
                            if (Thread.interrupted()) {
                                return;
                            }
                            VariantFrequencyAggregatePane.this.addCohortToDnaId(cohort, dnaId);
                        }
                    }
                    Map<Object, List<String>> m = MedSavantClient.PatientManager.getDNAIDsForValues(sessionID, ProjectController.getInstance().getCurrentProjectID(), BasicPatientColumns.FAMILY_ID.getColumnName());
                    for (Map.Entry<Object, List<String>> e : m.entrySet()) {
                        for (String dnaId : e.getValue()) {
                            if (((String)e.getKey()).trim().length() > 0) {
                                VariantFrequencyAggregatePane.this.addFamilyToDnaId((String)e.getKey(), dnaId);
                            }
                            if (!Thread.interrupted()) continue;
                            return;
                        }
                    }
                    LOG.debug((Object)("Counting unique " + BasicVariantColumns.DNA_ID.getColumnName() + " from table " + ProjectController.getInstance().getCurrentVariantTableName()));
                    List<String> allDNAIds = MedSavantClient.DBUtils.getDistinctValuesForColumn(sessionID, ProjectController.getInstance().getCurrentVariantTableName(), BasicVariantColumns.DNA_ID.getColumnName(), true);
                    LOG.debug((Object)("# Distinct DNAIds in Variant Table: " + allDNAIds.size()));
                    for (String dnaId : allDNAIds) {
                        VariantFrequencyAggregatePane.this.addFamilyToDnaId(VariantFrequencyAggregatePane.ALL_INDIVIDUALS_FAMILY, dnaId);
                        VariantFrequencyAggregatePane.this.addCohortToDnaId(ALL_INDIVIDUALS_COHORT, dnaId);
                    }
                }
                catch (SQLException se) {
                    LOG.error((Object)se);
                }
                catch (RemoteException re) {
                    LOG.error((Object)re);
                }
                catch (SessionExpiredException se) {
                    MedSavantExceptionHandler.handleSessionExpiredException(se);
                }
                catch (InterruptedException ie) {
                    LOG.error((Object)ie);
                }
            }
        }
    }

    private class SubInspectorTableModel
    extends AbstractTableModel {
        private List<Object[]> tableData = new ArrayList<Object[]>();

        private SubInspectorTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return VariantFrequencyAggregatePane.this.columnNames[col].toString();
        }

        @Override
        public int getRowCount() {
            return this.tableData.size();
        }

        @Override
        public int getColumnCount() {
            return VariantFrequencyAggregatePane.this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Object r = this.tableData.get(row)[col];
            if (r == null) {
                LOG.debug((Object)"Null table entry for variant");
                return "-";
            }
            return r;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.tableData.get((int)row)[col] = value;
            this.fireTableCellUpdated(row, col);
        }

        public void setValues(Set<VariantRecord> variantRecords) {
            VariantFrequencyAggregatePane.this.individualsWithVariantAtThisPosition = new HashSet();
            this.tableData = new ArrayList<Object[]>(variantRecords.size());
            for (VariantRecord r : variantRecords) {
                String dnaID = r.getDnaID();
                String ref = r.getRef();
                String alt = r.getAlt();
                String zygosity = r.getZygosity().toString();
                VariantFrequencyAggregatePane.this.individualsWithVariantAtThisPosition.add(dnaID);
                HashSet<Cohort> cohorts = (HashSet<Cohort>)VariantFrequencyAggregatePane.this.dnaIDCohortMap.get(dnaID);
                HashSet<String> familyIds = (HashSet<String>)VariantFrequencyAggregatePane.this.dnaIDFamilyIDMap.get(dnaID);
                if (cohorts == null) {
                    LOG.error((Object)("Cohorts is null for dnaID " + dnaID));
                    cohorts = new HashSet<Cohort>();
                    cohorts.add(ALL_INDIVIDUALS_COHORT);
                }
                if (familyIds == null) {
                    LOG.error((Object)("Family ID is null for dnaID " + dnaID));
                    familyIds = new HashSet<String>();
                    familyIds.add(VariantFrequencyAggregatePane.ALL_INDIVIDUALS_FAMILY);
                }
                for (Cohort cohort : cohorts) {
                    for (String familyId : familyIds) {
                        Object[] partialRow = VariantFrequencyAggregatePane.this.getRow(cohort, familyId, r);
                        partialRow = ArrayUtils.addAll((Object[])new Object[]{cohort, familyId}, (Object[])partialRow);
                        Object[] row = ArrayUtils.addAll((Object[])partialRow, (Object[])new Object[]{dnaID, r});
                        this.tableData.add(row);
                    }
                }
            }
            this.fireTableDataChanged();
        }
    }

    private class GroupByMenuItem
    extends JMenuItem
    implements ActionListener {
        private String[] aggregateColumns;

        public GroupByMenuItem(String[] aggregateColumns, String title) {
            this.setText(title);
            this.aggregateColumns = aggregateColumns;
            this.addActionListener(this);
        }

        public GroupByMenuItem(String[] aggregateColumns) {
            this(aggregateColumns, aggregateColumns[0]);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            VariantFrequencyAggregatePane.this.aggregateTable.aggregate(this.aggregateColumns);
            VariantFrequencyAggregatePane.this.setAggregateColumns(this.aggregateColumns);
            VariantFrequencyAggregatePane.this.setupButtonColumn();
            VariantFrequencyAggregatePane.this.expandAllButLast();
            VariantFrequencyAggregatePane.this.aggregateTable.revalidate();
            VariantFrequencyAggregatePane.this.aggregateTable.repaint();
        }
    }
}

