/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class ImagePanel
extends JPanel {
    private Image image;
    private boolean doColorOverlay = false;
    private Color colorOverlay = Color.red;
    private Image recoloredImage;

    public ImagePanel(String path) {
        this.setOpaque(false);
        try {
            URL u = this.getClass().getClassLoader().getResource(path);
            BufferedImage im = ImageIO.read(u);
            ImageIcon icon = new ImageIcon(im);
            int height = icon.getIconHeight();
            int width = icon.getIconWidth();
            this.image = im;
            this.initDimensions(width, height);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ImagePanel(Image im) {
        ImageIcon icon = new ImageIcon(im);
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        this.image = im;
        this.initDimensions(width, height);
    }

    public ImagePanel(Image im, int width, int height, boolean smoothing) {
        this.image = im;
        if (smoothing) {
            this.image = this.image.getScaledInstance(width, height, 16);
        }
        this.initDimensions(width, height);
    }

    public ImagePanel(Image im, int width, int height) {
        this(im, width, height, true);
    }

    @Override
    public void paintComponent(Graphics g) {
        Image i = this.image;
        if (this.doColorOverlay) {
            i = this.recoloredImage;
        }
        g.drawImage(i, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private static int[] singleToComponents(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new int[]{red, green, blue};
    }

    private static int componentsToSingle(int red, int green, int blue) {
        int rgb = red;
        rgb = (rgb << 8) + green;
        rgb = (rgb << 8) + blue;
        return rgb;
    }

    private void initDimensions(int width, int height) {
        Dimension dim = new Dimension(width, height);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setBorder(null);
        this.setOpaque(false);
    }

    public void setDoColorOverlay(boolean doColorOverlay) {
        this.doColorOverlay = doColorOverlay;
        this.prepareColoredImage();
    }

    public void setColorOverlay(Color colorOverlay) {
        this.colorOverlay = colorOverlay;
        this.prepareColoredImage();
    }

    private void prepareColoredImage() {
        this.recoloredImage = ViewUtil.colorImage(this.image, this.colorOverlay);
    }
}

