/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.login;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.client.api.Listener;
import org.ut.biolab.medsavant.client.controller.ServerController;
import org.ut.biolab.medsavant.client.controller.SettingsController;
import org.ut.biolab.medsavant.client.util.MedSavantWorker;
import org.ut.biolab.medsavant.client.view.MedSavantFrame;
import org.ut.biolab.medsavant.client.view.component.PlaceHolderPasswordField;
import org.ut.biolab.medsavant.client.view.component.PlaceHolderTextField;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.images.ImagePanel;
import org.ut.biolab.medsavant.client.view.login.LoginController;
import org.ut.biolab.medsavant.client.view.login.LoginEvent;
import org.ut.biolab.medsavant.client.view.login.MedSavantServerInfo;
import org.ut.biolab.medsavant.client.view.login.SplashFrame;
import org.ut.biolab.medsavant.client.view.login.SplashServerManagementComponent;
import org.ut.biolab.medsavant.client.view.util.DialogUtils;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class SplashLoginComponent
extends JPanel
implements Listener<ServerController> {
    private static Log LOG = LogFactory.getLog(SplashLoginComponent.class);
    private final JPanel loginSettingsPanel;
    private final JPanel loggingInPanel;
    private final JPanel noServerAtAllPanel;
    private PlaceHolderTextField usernameField;
    private PlaceHolderPasswordField passwordField;
    private JCheckBox rememberPasswordCheckbox;
    private JButton serverNameLabel;
    private final int LOGIN_PAGE = 0;
    private final int LOGGING_IN_PAGE = 1;
    private final int NO_SERVER_ATALL_PAGE = 2;
    private boolean isLoggingIn = false;
    private JCheckBox autoLoginCheckBox;
    private MedSavantServerInfo server;
    private MedSavantWorker<Void> loginThread;
    private SplashFrame splash;
    private SplashServerManagementComponent serverManager;
    boolean isFirstTime = true;

    public SplashLoginComponent(final SplashFrame splash, SplashServerManagementComponent serverManager) {
        this.setBackground(Color.white);
        this.setLayout((LayoutManager)new MigLayout("fillx, filly, insets 0, center"));
        this.serverManager = serverManager;
        this.splash = splash;
        LOG.info((Object)"Subscribing to login events");
        LoginController.getInstance().addListener(new Listener<LoginEvent>(){

            @Override
            public void handleEvent(LoginEvent event) {
                LOG.info((Object)("Received login event " + event.getType().toString()));
                switch (event.getType()) {
                    case LOGGED_IN: {
                        if (SplashLoginComponent.this.loginThread.isCancelled()) {
                            LOG.info((Object)("Login was cancelled " + SplashLoginComponent.this.loginThread.isCancelled() + " " + !SplashLoginComponent.this.isLoggingIn));
                            return;
                        }
                        MedSavantFrame frame = MedSavantFrame.getInstance();
                        frame.initializeSessionView();
                        frame.setLocationRelativeTo(null);
                        frame.setSize(Toolkit.getDefaultToolkit().getScreenSize());
                        frame.setPreferredSize(frame.getSize());
                        frame.setVisible(true);
                        splash.closeSplashFrame();
                        break;
                    }
                    case LOGGED_OUT: {
                        MedSavantFrame frame2 = MedSavantFrame.getInstance();
                        frame2.setVisible(false);
                        break;
                    }
                    case LOGIN_FAILED: {
                        LOG.info((Object)"Login failed");
                        Exception e = event == null ? null : event.getException();
                        String msg = event == null || event.getException() == null ? "" : event.getException().getLocalizedMessage();
                        DialogUtils.displayException("Login Failed", msg, e);
                        SplashLoginComponent.this.isLoggingIn = false;
                        break;
                    }
                    case LOGIN_CANCELLED: {
                        SplashLoginComponent.this.isLoggingIn = false;
                    }
                }
                SplashLoginComponent.this.isLoggingIn = false;
                SplashLoginComponent.this.setPageAppropriately();
            }
        });
        JPanel container = ViewUtil.getClearPanel();
        container.setLayout((LayoutManager)new MigLayout());
        JPanel leftSide = ViewUtil.getClearPanel();
        leftSide.setLayout((LayoutManager)new MigLayout("wrap 1, insets 0, center, hidemode 3"));
        ImagePanel logo = new ImagePanel(IconFactory.getInstance().getIcon("/org/ut/biolab/medsavant/client/view/images/icon/medsavantlogo-flat.png").getImage(), 170, 171);
        leftSide.add((Component)logo, "center");
        container.add((Component)leftSide, "width 180");
        JPanel rightSide = ViewUtil.getClearPanel();
        rightSide.setLayout((LayoutManager)new MigLayout("wrap 1, hidemode 3"));
        ServerController.getInstance().addListener(this);
        this.noServerAtAllPanel = this.initNoServerAtAllPanel();
        this.loginSettingsPanel = this.initLoginSettingsPanel();
        this.loggingInPanel = this.initLoggingInPanel();
        rightSide.add(this.noServerAtAllPanel);
        rightSide.add(this.loginSettingsPanel);
        rightSide.add(this.loggingInPanel);
        this.setPageAppropriately();
        container.add((Component)rightSide, "width 250");
        this.add((Component)container, "center, growx 1.0");
    }

    @Override
    public void handleEvent(ServerController event) {
        this.setPageAppropriately();
    }

    public void setPageAppropriately() {
        if (this.isFirstTime) {
            MedSavantServerInfo server;
            boolean isBootingFromLogout = SettingsController.getInstance().getBoolean("BootFromLogout", false);
            SettingsController.getInstance().setBoolean("BootFromLogout", false);
            if (!isBootingFromLogout && SettingsController.getInstance().getAutoLogin() && (server = ServerController.getInstance().getCurrentServer()) != null && server.isRememberPassword() && !server.getUsername().isEmpty() && !server.getPassword().isEmpty()) {
                this.loginUsingEnteredUsernameAndPassword(server);
            }
        }
        this.isFirstTime = false;
        if (this.isLoggingIn) {
            this.setPage(1);
        } else if (ServerController.getInstance().getServers().isEmpty()) {
            this.setPage(2);
        } else {
            this.setServer(ServerController.getInstance().getCurrentServer());
            this.setPage(0);
        }
    }

    private JPanel initNoServerAtAllPanel() {
        JPanel panel = ViewUtil.getClearPanel();
        panel.setLayout((LayoutManager)new MigLayout("gapx 0, gapy 5, wrap 1, insets 20 0 0 0"));
        JLabel welcomeLabel = new JLabel("Welcome to MedSavant");
        panel.add((Component)welcomeLabel, "wrap, center");
        panel.add((Component)new JLabel("To get started"), "split, center, gapy 20");
        JButton addServerButton = ViewUtil.getSoftButton("add a server");
        panel.add(addServerButton);
        panel.add(new JLabel("to connect to."));
        addServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashLoginComponent.this.serverManager.addServerAndEdit();
                SplashLoginComponent.this.splash.switchToServerManager();
            }
        });
        welcomeLabel.setFont(new Font(ViewUtil.getDefaultFontFamily(), 0, 20));
        return panel;
    }

    private JPanel initLoggingInPanel() {
        JPanel panel = ViewUtil.getClearPanel();
        panel.setLayout((LayoutManager)new MigLayout("gapy 5, insets 0, fillx"));
        panel.add(new JLabel("Signing In"));
        panel.add(ViewUtil.getIndeterminateProgressBar());
        JButton cancelButton = new JButton("Cancel");
        panel.add((Component)cancelButton, "growx 1.0, right");
        cancelButton.setFocusable(false);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info((Object)"Cancelling login");
                SplashLoginComponent.this.isLoggingIn = false;
                SplashLoginComponent.this.loginThread.cancel(true);
                LoginController.getInstance().cancelCurrentLoginAttempt();
                SplashLoginComponent.this.setPageAppropriately();
            }
        });
        return panel;
    }

    private void setPage(int page) {
        switch (page) {
            case 2: {
                this.loginSettingsPanel.setVisible(false);
                this.loggingInPanel.setVisible(false);
                this.noServerAtAllPanel.setVisible(true);
                break;
            }
            case 0: {
                this.loginSettingsPanel.setVisible(true);
                this.loggingInPanel.setVisible(false);
                this.noServerAtAllPanel.setVisible(false);
                break;
            }
            case 1: {
                this.loginSettingsPanel.setVisible(false);
                this.loggingInPanel.setVisible(true);
                this.noServerAtAllPanel.setVisible(false);
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateUI();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SplashLoginComponent.this.updateUI();
                    }
                });
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
    }

    private JPanel initLoginSettingsPanel() {
        JPanel panel = ViewUtil.getClearPanel();
        panel.setLayout((LayoutManager)new MigLayout("gapy 5, wrap 1, insets 0"));
        this.serverNameLabel = ViewUtil.getSoftButton("");
        panel.add((Component)new JLabel("Connect to"), "split");
        panel.add((Component)this.serverNameLabel, "wrap");
        this.serverNameLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashLoginComponent.this.serverManager.getServerList().selectItemWithKey(SplashLoginComponent.this.serverNameLabel.getText());
                SplashLoginComponent.this.splash.switchToServerManager();
            }
        });
        this.usernameField = new PlaceHolderTextField();
        this.usernameField.setPlaceholder("Username");
        this.usernameField.setFont(new Font(ViewUtil.getDefaultFontFamily(), 0, 20));
        this.usernameField.setForeground(ViewUtil.getSemiBlackColor());
        this.usernameField.setColumns(14);
        panel.add((Component)this.usernameField, "wrap");
        this.usernameField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SplashLoginComponent.this.doSignIntoServer(SplashLoginComponent.this.server);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.passwordField = new PlaceHolderPasswordField();
        this.passwordField.setPlaceholder("Password");
        this.passwordField.setFont(new Font(ViewUtil.getDefaultFontFamily(), 0, 20));
        this.passwordField.setForeground(ViewUtil.getSemiBlackColor());
        this.passwordField.setColumns(14);
        panel.add((Component)this.passwordField, "wrap");
        this.passwordField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SplashLoginComponent.this.doSignIntoServer(SplashLoginComponent.this.server);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.rememberPasswordCheckbox = new JCheckBox("Remember Password");
        this.rememberPasswordCheckbox.setFocusable(false);
        panel.add((Component)this.rememberPasswordCheckbox, "wrap");
        this.autoLoginCheckBox = new JCheckBox("Auto-login");
        this.autoLoginCheckBox.setFocusable(false);
        this.rememberPasswordCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean remember = SplashLoginComponent.this.rememberPasswordCheckbox.isSelected();
                SplashLoginComponent.this.autoLoginCheckBox.setEnabled(remember);
                if (!remember) {
                    SplashLoginComponent.this.autoLoginCheckBox.setSelected(false);
                }
                if (SplashLoginComponent.this.server != null) {
                    SplashLoginComponent.this.server.setRememberPassword(SplashLoginComponent.this.rememberPasswordCheckbox.isSelected());
                    ServerController.getInstance().saveServers();
                }
            }
        });
        this.autoLoginCheckBox.setEnabled(this.rememberPasswordCheckbox.isSelected());
        panel.add((Component)this.autoLoginCheckBox, "split");
        this.autoLoginCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsController.getInstance().setAutoLogin(SplashLoginComponent.this.autoLoginCheckBox.isSelected());
            }
        });
        JButton signInButton = new JButton("Sign In");
        signInButton.setFocusable(false);
        signInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplashLoginComponent.this.doSignIntoServer(SplashLoginComponent.this.server);
            }
        });
        panel.add((Component)signInButton, "right");
        return panel;
    }

    private void doSignIntoServer(MedSavantServerInfo server) {
        server.setUsername(this.usernameField.getText());
        server.setPassword(new String(this.passwordField.getPassword()));
        server.setRememberPassword(this.rememberPasswordCheckbox.isSelected());
        ServerController.getInstance().saveServers();
        this.loginUsingEnteredUsernameAndPassword(server);
        this.setPageAppropriately();
    }

    private void loginUsingEnteredUsernameAndPassword(final MedSavantServerInfo server) {
        if (this.isLoggingIn) {
            return;
        }
        this.isLoggingIn = true;
        this.loginThread = new MedSavantWorker<Void>("LoginView"){

            @Override
            protected void showProgress(double fract) {
            }

            @Override
            protected void showSuccess(Void result) {
            }

            @Override
            protected Void doInBackground() throws Exception {
                LoginController.getInstance().login(server);
                return null;
            }
        };
        this.loginThread.execute();
    }

    public void setServer(MedSavantServerInfo server) {
        if (server == null) {
            return;
        }
        if (server.getPassword() == null) {
            return;
        }
        this.server = server;
        this.usernameField.setText(server.getUsername());
        this.passwordField.setText(server.getPassword());
        this.rememberPasswordCheckbox.setSelected(server.isRememberPassword());
        this.serverNameLabel.setText(ViewUtil.ellipsize(server.getNickname(), 23));
        this.autoLoginCheckBox.setEnabled(server.isRememberPassword());
        if (server.isRememberPassword()) {
            this.autoLoginCheckBox.setSelected(SettingsController.getInstance().getAutoLogin());
        }
    }
}

