/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import com.explodingpixels.macwidgets.SourceListControlBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.ut.biolab.medsavant.client.view.images.IconFactory;
import org.ut.biolab.medsavant.client.view.util.PeekingPanel;

public class PeekingPanelContainer
extends JPanel {
    private final JPanel container = new JPanel();
    private PeekingPanel NORTH_SIDE_PANEL;
    private PeekingPanel SOUTH_SIDE_PANEL;
    private PeekingPanel WEST_SIDE_PANEL;
    private PeekingPanel EAST_SIDE_PANEL;
    private JComponent lastComponent;

    public PeekingPanelContainer(JPanel child) {
        this.container.setLayout(new BorderLayout());
        this.container.add((Component)child, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.container, "Center");
        this.updateControlBar();
    }

    public PeekingPanel addPeekingPanel(String label, String borderLayoutPosition, JComponent panel, boolean isExpanded) {
        return this.addPeekingPanel(label, borderLayoutPosition, panel, isExpanded, -1);
    }

    public PeekingPanel addPeekingPanel(String label, String borderLayoutPosition, JComponent panel, boolean isExpanded, int size) {
        PeekingPanel p = size == -1 ? new PeekingPanel(label, borderLayoutPosition, panel, isExpanded) : new PeekingPanel(label, borderLayoutPosition, panel, isExpanded, size);
        p.setToggleBarVisible(false);
        if (borderLayoutPosition.equals("North")) {
            this.NORTH_SIDE_PANEL = p;
        } else if (borderLayoutPosition.equals("East")) {
            this.EAST_SIDE_PANEL = p;
        } else if (borderLayoutPosition.equals("South")) {
            this.SOUTH_SIDE_PANEL = p;
        } else if (borderLayoutPosition.equals("West")) {
            this.WEST_SIDE_PANEL = p;
        }
        this.container.add((Component)((Object)p), borderLayoutPosition);
        this.updateControlBar();
        return p;
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame();
        PeekingPanelContainer pc = new PeekingPanelContainer(new JPanel());
        f.setLayout(new BorderLayout());
        pc.addPeekingPanel("Blah", "West", new JPanel(), true);
        pc.addPeekingPanel("Blah", "North", new JPanel(), true);
        pc.addPeekingPanel("Blah", "East", new JPanel(), true);
        pc.addPeekingPanel("Blah", "South", new JPanel(), true);
        f.add((Component)pc, "Center");
        f.pack();
        f.setVisible(true);
    }

    private void updateControlBar() {
        SourceListControlBar controlbar = new SourceListControlBar();
        int counter = 0;
        for (final PeekingPanel p : new PeekingPanel[]{this.WEST_SIDE_PANEL, this.NORTH_SIDE_PANEL, this.SOUTH_SIDE_PANEL, this.EAST_SIDE_PANEL}) {
            ++counter;
            if (p == null) continue;
            boolean isExpanded = p.isExpanded();
            String iconroot = "/org/ut/biolab/medsavant/client/view/images/icon/view-sidebar";
            String side = "";
            String selected = isExpanded ? "-selected" : "";
            switch (counter) {
                case 1: {
                    side = "west";
                    break;
                }
                case 2: {
                    side = "north";
                    break;
                }
                case 3: {
                    side = "south";
                    break;
                }
                case 4: {
                    side = "east";
                }
            }
            String path = String.format("%s-%s%s.png", iconroot, side, selected);
            ImageIcon icon = IconFactory.getInstance().getIcon(path);
            controlbar.createAndAddButton((Icon)icon, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    p.setExpanded(!p.isExpanded());
                    PeekingPanelContainer.this.updateControlBar();
                }
            });
        }
        if (this.lastComponent != null) {
            this.remove(this.lastComponent);
        }
        this.lastComponent = controlbar.getComponent();
        this.add((Component)this.lastComponent, "South");
        this.updateUI();
    }
}

