/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class StandardAppContainer
extends JPanel {
    int insets = 30;

    public StandardAppContainer(JPanel view) {
        this(view, false);
    }

    public StandardAppContainer(final JPanel view, boolean doesScroll) {
        final JPanel paddedContainer = ViewUtil.getClearPanel();
        paddedContainer.setLayout((LayoutManager)new MigLayout(String.format("fillx, filly, insets %d", this.insets)));
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        if (doesScroll) {
            final JScrollPane p = ViewUtil.getClearBorderlessScrollPane(paddedContainer);
            p.setHorizontalScrollBarPolicy(31);
            paddedContainer.add((Component)view, "growy 1.0");
            this.add((Component)p, "Center");
            p.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.repositionView();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    this.repositionView();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }

                private void repositionView() {
                    int size = (int)p.getSize().getWidth() - 2 * StandardAppContainer.this.insets;
                    paddedContainer.remove(view);
                    paddedContainer.add((Component)view, String.format("growy 1.0, width %d", size));
                }
            });
        } else {
            paddedContainer.add((Component)view, "growy 1.0, width 100%");
            this.add((Component)paddedContainer, "Center");
        }
    }
}

