/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.util.StandardAppContainer;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;

public class StandardFixableWidthAppPanel
extends JPanel {
    private final JPanel content = ViewUtil.getClearPanel();
    private final JLabel titleLabel;
    private final boolean initialized;
    private static boolean DEFAULT_DOESSCROLL = true;
    private static String DEFAULT_TITLE = null;
    private static boolean DEFAULT_FIXEDWIDTH = true;

    public StandardFixableWidthAppPanel() {
        this(DEFAULT_DOESSCROLL);
    }

    public StandardFixableWidthAppPanel(String title) {
        this(title, DEFAULT_DOESSCROLL);
    }

    public StandardFixableWidthAppPanel(boolean doesScroll) {
        this(DEFAULT_TITLE, doesScroll, DEFAULT_FIXEDWIDTH);
    }

    public StandardFixableWidthAppPanel(boolean doesScroll, boolean fixedWidth) {
        this(DEFAULT_TITLE, doesScroll, fixedWidth);
    }

    public StandardFixableWidthAppPanel(String title, boolean doesScroll) {
        this(title, doesScroll, DEFAULT_FIXEDWIDTH);
    }

    public StandardFixableWidthAppPanel(String title, boolean doesScroll, boolean fixedWidth) {
        this.content.setLayout((LayoutManager)new MigLayout("insets 0, fillx, hidemode 3"));
        JPanel fixedWidthContainer = fixedWidth ? ViewUtil.getDefaultFixedWidthPanel(this.content) : ViewUtil.getFixedWidthPanel(this.content, -1);
        StandardAppContainer sac = new StandardAppContainer(fixedWidthContainer, doesScroll);
        sac.setBackground(ViewUtil.getLightGrayBackgroundColor());
        this.titleLabel = ViewUtil.getLargeSerifLabel("");
        this.titleLabel.setVisible(false);
        if (title != null) {
            this.setTitle(title);
        }
        this.content.add((Component)this.titleLabel, "wrap");
        this.setLayout(new BorderLayout());
        this.add((Component)sac, "Center");
        this.initialized = true;
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (this.initialized) {
            throw new UnsupportedOperationException("Not allowed to change layout for this component");
        }
        super.setLayout(mgr);
    }

    public JPanel addBlock() {
        return this.addBlock(null);
    }

    public JPanel addBlock(String blockTitle) {
        JPanel p = ViewUtil.getWhiteLineBorderedPanel();
        JPanel canvas = ViewUtil.getClearPanel();
        canvas.setLayout((LayoutManager)new MigLayout("insets 0"));
        p.setLayout((LayoutManager)new MigLayout("fillx, wrap"));
        if (blockTitle != null) {
            JLabel l = new JLabel(blockTitle);
            l.setText(blockTitle);
            l.setFont(ViewUtil.getMediumTitleFont());
            p.add(l);
        }
        p.add((Component)canvas, "width 100%");
        this.content.add((Component)p, "width 100%, wrap");
        return canvas;
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
        ViewUtil.ellipsizeLabel(this.titleLabel, 800);
        this.titleLabel.setVisible(true);
    }
}

