/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util;

import com.jidesoft.grid.AbstractExpandableRow;
import com.jidesoft.grid.Expandable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.ut.biolab.medsavant.client.settings.DirectorySettings;
import org.ut.biolab.medsavant.client.util.ClientMiscUtils;

public class TreeBrowserEntry
extends AbstractExpandableRow
implements Comparable<TreeBrowserEntry> {
    static FileSystemView _fileSystemView;
    private boolean isLeaf;
    private List<TreeBrowserEntry> children;
    private String name;
    private String type;
    private String description;
    private URL url;
    private String size;

    public TreeBrowserEntry(String name, List<TreeBrowserEntry> r) {
        this.name = name;
        this.setChildren(r);
    }

    public TreeBrowserEntry(String name, String type, String description, URL url, String size) {
        this.isLeaf = true;
        this.type = type;
        this.name = name;
        this.description = description;
        this.url = url;
        this.size = size;
    }

    public String toString() {
        return this.getName();
    }

    public Object getValueAt(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this;
            }
            case 1: {
                return this.description;
            }
            case 2: {
                return this.type;
            }
            case 3: {
                return this.isLeaf ? this.url.getFile() : null;
            }
            case 4: {
                return this.isLeaf ? this.size : null;
            }
        }
        return null;
    }

    public Class<?> getCellClassAt(int columnIndex) {
        return null;
    }

    public final void setChildren(List<?> value) {
        this.children = value;
        if (this.children != null) {
            for (TreeBrowserEntry row : this.children) {
                row.setParent((Expandable)this);
            }
        }
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public List<?> getChildren() {
        return this.children;
    }

    static FileSystemView getFileSystemView() {
        if (_fileSystemView == null) {
            _fileSystemView = FileSystemView.getFileSystemView();
        }
        return _fileSystemView;
    }

    public Icon getIcon() {
        if (this.isLeaf) {
            String ext = ClientMiscUtils.getExtension(this.url);
            try {
                File f = File.createTempFile("savant_icon.", "." + ext);
                Icon i = TreeBrowserEntry.getFileSystemView().getSystemIcon(f);
                f.delete();
                return i;
            }
            catch (IOException ex) {
                return null;
            }
        }
        return TreeBrowserEntry.getFileSystemView().getSystemIcon(DirectorySettings.getMedSavantDirectory());
    }

    @Override
    public int compareTo(TreeBrowserEntry o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public URL getURL() {
        return this.url;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }
}

