/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.client.view.util.list;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.miginfocom.swing.MigLayout;
import org.ut.biolab.medsavant.client.view.util.ViewUtil;
import org.ut.biolab.medsavant.client.view.util.list.GrayscaleNiceListColorScheme;
import org.ut.biolab.medsavant.client.view.util.list.NiceListColorScheme;
import org.ut.biolab.medsavant.client.view.util.list.NiceListItem;

public class NiceList
extends JList {
    private NiceListColorScheme colorScheme = new GrayscaleNiceListColorScheme();
    private final Vector<NiceListItem> allItems = new Vector();
    private JTextField searchBar;
    private boolean inTransaction;

    public NiceList() {
        this.setCellRenderer(new NiceListCellRenderer());
        this.setModel(new NiceListModel());
        this.initSearchBar();
    }

    public void addItem(NiceListItem item) {
        this.allItems.add(item);
        this.updateListItems();
    }

    public void removeItem(NiceListItem item) {
        this.allItems.remove(item);
        this.updateListItems();
    }

    public NiceListItem getItem(int index) {
        return this.allItems.get(index);
    }

    public JTextField getSearchBar() {
        return this.searchBar;
    }

    private void initSearchBar() {
        this.searchBar = new JTextField();
        this.searchBar.putClientProperty("JTextField.variant", "search");
        this.searchBar.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                NiceList.this.updateListItems();
            }
        });
    }

    private void updateListItems() {
        if (this.inTransaction) {
            return;
        }
        this.setBackground(this.colorScheme.getBackgroundColor());
        Vector<NiceListItem> v = this.searchBar.getText().isEmpty() ? new Vector<NiceListItem>(this.allItems) : this.getSearchResults();
        this.setListData(v);
    }

    public void removeItems() {
        this.startTransaction();
        for (NiceListItem i : this.allItems) {
            this.removeItem(i);
        }
        this.endTransaction();
    }

    private Vector getSearchResults() {
        Vector<NiceListItem> v = new Vector<NiceListItem>();
        String searchTerm = this.searchBar.getText().toLowerCase();
        for (NiceListItem item : this.allItems) {
            if (item.toString().toLowerCase().contains(searchTerm)) {
                v.add(item);
                continue;
            }
            if (item.getDescription() == null || !item.getDescription().toLowerCase().contains(searchTerm)) continue;
            v.add(item);
        }
        return v;
    }

    public void startTransaction() {
        this.inTransaction = true;
    }

    public void endTransaction() {
        this.inTransaction = false;
        this.updateListItems();
    }

    public List<NiceListItem> getSelectedItems() {
        Object[] selected;
        ArrayList<NiceListItem> results = new ArrayList<NiceListItem>();
        for (Object item : selected = this.getSelectedValues()) {
            if (!(item instanceof NiceListItem)) continue;
            results.add((NiceListItem)item);
        }
        return results;
    }

    public void selectItemWithKey(String key) {
        this.clearSearch();
        for (NiceListItem item : this.allItems) {
            if (!item.toString().toLowerCase().equals(key.toLowerCase())) continue;
            this.setSelectedValue(item, true);
            return;
        }
    }

    private void clearSearch() {
        if (!this.searchBar.getText().isEmpty()) {
            this.searchBar.setText("");
        }
    }

    public void selectItemsAtIndicies(List<Integer> indicies) {
        int[] indiciesArray = new int[indicies.size()];
        for (int i = 0; i < indicies.size(); ++i) {
            indiciesArray[i] = indicies.get(i);
        }
        this.selectItemsAtIndicies(indiciesArray);
    }

    private void selectItemsAtIndicies(int[] indicies) {
        this.clearSearch();
        this.setSelectedIndices(indicies);
    }

    public void selectItemAtIndex(int i) {
        this.clearSearch();
        try {
            NiceListItem item = this.allItems.get(i);
            this.setSelectedValue(item, true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public NiceListColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(NiceListColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    class NiceListCellRenderer
    implements ListCellRenderer {
        private static final int cellHeight = 45;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof NiceListItem) {
                NiceListItem mitem = (NiceListItem)value;
                return this.getListCellRendererRegularComponent(list, mitem, index, isSelected, cellHasFocus);
            }
            throw new UnsupportedOperationException("NiceList can't render items of type " + value.getClass().getCanonicalName());
        }

        private Component getListCellRendererRegularComponent(JList list, NiceListItem mitem, int index, boolean isSelected, boolean cellHasFocus) {
            JPanel p = new JPanel();
            p.setBackground(isSelected ? NiceList.this.colorScheme.getSelectedColor() : NiceList.this.colorScheme.getUnselectedColor());
            p.setLayout((LayoutManager)new MigLayout(String.format("fillx, height %d, hidemode 3, gapy 2", 45)));
            JLabel l = new JLabel(mitem.toString());
            l.setFont(new Font(l.getFont().getFamily(), 0, 16));
            l.setForeground(isSelected ? NiceList.this.colorScheme.getSelectedFontColor() : NiceList.this.colorScheme.getUnselectedFontColor());
            p.add((Component)l, "wrap");
            String description = mitem.getDescription();
            if (description != null) {
                JLabel dl = ViewUtil.getSubtleHeaderLabel(description);
                p.add((Component)dl, "wrap");
            }
            p.setBorder(BorderFactory.createMatteBorder(index == 0 ? 1 : 0, 0, 1, 0, NiceList.this.colorScheme.getBorderColor()));
            return p;
        }
    }

    private class NiceListModel
    extends AbstractListModel {
        private NiceListModel() {
        }

        @Override
        public int getSize() {
            return NiceList.this.allItems.size();
        }

        @Override
        public Object getElementAt(int index) {
            return NiceList.this.allItems.get(index);
        }
    }
}

