/*
 * Decompiled with CFR 0.152.
 */
package jannovar.io;

import jannovar.common.Constants;
import jannovar.exception.FileDownloadException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class TranscriptDataDownloader
implements Constants {
    private String directory_path;

    public TranscriptDataDownloader(String dirPath) {
        if (!dirPath.endsWith(System.getProperty("file.separator"))) {
            dirPath = dirPath + System.getProperty("file.separator");
        }
        this.directory_path = dirPath;
    }

    public String getDownloadDirectory() {
        return this.directory_path;
    }

    public TranscriptDataDownloader(String dirpath, String proxyHost, String port) {
        this(dirpath);
        if (proxyHost == null) {
            return;
        }
        System.setProperty("proxySet", "true");
        if (proxyHost.startsWith("http://")) {
            proxyHost = proxyHost.substring(7);
        }
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", port);
    }

    public void downloadTranscriptFiles(int source, Constants.Release r) throws FileDownloadException {
        this.makeDirectoryIfNotExist();
        switch (source) {
            case 0: {
                this.downloadUCSCfiles(r);
                break;
            }
            case 1: {
                this.downloadEnsemblFiles(r);
                break;
            }
            case 2: {
                this.downloadRefseqFiles(r);
                break;
            }
            default: {
                throw new FileDownloadException("Unknown source of transcript annotation.");
            }
        }
    }

    public void downloadRefseqFiles(Constants.Release r) throws FileDownloadException {
        String gff_name;
        String rna_base;
        String gff_base;
        String rna_name = "rna.fa.gz";
        switch (r) {
            case MM9: {
                gff_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/Mus_musculus/", "ARCHIVE/BUILD.37.2/", "GFF/");
                rna_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/Mus_musculus/", "ARCHIVE/BUILD.37.2/", "RNA/");
                gff_name = "ref_MGSCv37_top_level.gff3.gz";
                break;
            }
            case MM10: {
                gff_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/Mus_musculus/", "", "GFF/");
                rna_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/Mus_musculus/", "", "RNA/");
                gff_name = "ref_GRCm38.p2_top_level.gff3.gz";
                break;
            }
            case HG18: {
                gff_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/H_sapiens/", "ARCHIVE/BUILD.36.3/", "GFF/");
                rna_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/H_sapiens/", "ARCHIVE/BUILD.36.3/", "RNA/");
                gff_name = "ref_NCBI36_top_level.gff3.gz";
                break;
            }
            case HG38: {
                gff_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/H_sapiens/", "", "GFF/");
                rna_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/H_sapiens/", "", "RNA/");
                gff_name = "ref_GRCh38_top_level.gff3.gz";
                break;
            }
            default: {
                gff_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/H_sapiens/", "ARCHIVE/ANNOTATION_RELEASE.105/", "GFF/");
                rna_base = String.format("%s%s%s", "ftp://ftp.ncbi.nlm.nih.gov/genomes/H_sapiens/", "ARCHIVE/ANNOTATION_RELEASE.105/", "RNA/");
                gff_name = "ref_GRCh37.p13_top_level.gff3.gz";
            }
        }
        this.download_file(gff_base, gff_name);
        this.download_file(rna_base, rna_name);
    }

    public void downloadEnsemblFiles(Constants.Release r) throws FileDownloadException {
        String ncrna_name;
        String cdna_name;
        String gtf_name;
        String ncrna_base;
        String cdna_base;
        String gtf_base;
        switch (r) {
            case MM9: {
                gtf_base = String.format("%s%s%s", "ftp://ftp.ensembl.org/pub/release-67/", "gtf/", "mus_musculus/");
                cdna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-67/", "fasta/", "mus_musculus/", "cdna/");
                ncrna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-67/", "fasta/", "mus_musculus/", "ncrna/");
                gtf_name = String.format("%s%s", "Mus_musculus.NCBIM37.67", ".gtf.gz");
                cdna_name = String.format("%s%s", "Mus_musculus.NCBIM37.67", ".cdna.all.fa.gz");
                ncrna_name = String.format("%s%s", "Mus_musculus.NCBIM37.67", ".ncrna.fa.gz");
                break;
            }
            case MM10: {
                gtf_base = String.format("%s%s%s", "ftp://ftp.ensembl.org/pub/release-74/", "gtf/", "mus_musculus/");
                cdna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-74/", "fasta/", "mus_musculus/", "cdna/");
                ncrna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-74/", "fasta/", "mus_musculus/", "ncrna/");
                gtf_name = String.format("%s%s", "Mus_musculus.GRCm38.74", ".gtf.gz");
                cdna_name = String.format("%s%s", "Mus_musculus.GRCm38.74", ".cdna.all.fa.gz");
                ncrna_name = String.format("%s%s", "Mus_musculus.GRCm38.74", ".ncrna.fa.gz");
                break;
            }
            case HG18: {
                gtf_base = String.format("%s%s%s", "ftp://ftp.ensembl.org/pub/release-54/", "gtf/", "homo_sapiens/");
                cdna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-54/", "fasta/", "homo_sapiens/", "cdna/");
                ncrna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-54/", "fasta/", "homo_sapiens/", "ncrna/");
                gtf_name = String.format("%s%s", "Homo_sapiens.NCBI36.54", ".gtf.gz");
                cdna_name = String.format("%s%s", "Homo_sapiens.NCBI36.54", ".cdna.all.fa.gz");
                ncrna_name = String.format("%s%s", "Homo_sapiens.NCBI36.54", ".ncrna.fa.gz");
                break;
            }
            default: {
                gtf_base = String.format("%s%s%s", "ftp://ftp.ensembl.org/pub/release-74/", "gtf/", "homo_sapiens/");
                cdna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-74/", "fasta/", "homo_sapiens/", "cdna/");
                ncrna_base = String.format("%s%s%s%s", "ftp://ftp.ensembl.org/pub/release-74/", "fasta/", "homo_sapiens/", "ncrna/");
                gtf_name = String.format("%s%s", "Homo_sapiens.GRCh37.74", ".gtf.gz");
                cdna_name = String.format("%s%s", "Homo_sapiens.GRCh37.74", ".cdna.all.fa.gz");
                ncrna_name = String.format("%s%s", "Homo_sapiens.GRCh37.74", ".ncrna.fa.gz");
            }
        }
        this.download_file(ncrna_base, ncrna_name);
        this.download_file(cdna_base, cdna_name);
        this.download_file(gtf_base, gtf_name);
    }

    public void downloadUCSCfiles(Constants.Release r) throws FileDownloadException {
        String ucsc_ftp_base;
        String knownGene = String.format("%s.gz", "knownGene.txt");
        String knownGeneMrna = String.format("%s.gz", "knownGeneMrna.txt");
        String kgXref = String.format("%s.gz", "kgXref.txt");
        String known2locus = String.format("%s.gz", "knownToLocusLink.txt");
        switch (r) {
            case MM9: {
                ucsc_ftp_base = "http://hgdownload.soe.ucsc.edu/goldenPath/mm9/database/";
                break;
            }
            case MM10: {
                ucsc_ftp_base = "http://hgdownload.soe.ucsc.edu/goldenPath/mm10/database/";
                break;
            }
            case HG18: {
                ucsc_ftp_base = "http://hgdownload.soe.ucsc.edu/goldenPath/hg18/database/";
                break;
            }
            default: {
                ucsc_ftp_base = "http://hgdownload.soe.ucsc.edu/goldenPath/hg19/database/";
            }
        }
        this.download_file(ucsc_ftp_base, knownGene);
        this.download_file(ucsc_ftp_base, knownGeneMrna);
        this.download_file(ucsc_ftp_base, kgXref);
        this.download_file(ucsc_ftp_base, known2locus);
    }

    private void makeDirectoryIfNotExist() {
        File directory = new File(this.directory_path);
        if (directory.exists()) {
            System.out.println(String.format("[INFO] Cowardly refusing to create directory \"%s\" since it already exists", this.directory_path));
        } else {
            directory.mkdirs();
        }
    }

    public boolean download_file(String baseURL, String fname) throws FileDownloadException {
        String urlstring = baseURL + fname;
        String local_file_path = this.directory_path + fname;
        File f = new File(local_file_path);
        if (f.exists()) {
            System.out.println(String.format("[INFO] Timorously refusing to download file \"%s\" since it already exists locally", fname));
            return false;
        }
        System.out.println("[INFO] Downloading: \"" + fname + "\"");
        int threshold = 0;
        int block = 250000;
        try {
            URL url = new URL(urlstring);
            URLConnection urlc = url.openConnection();
            InputStream reader = urlc.getInputStream();
            FileOutputStream writer = new FileOutputStream(local_file_path);
            byte[] buffer = new byte[153600];
            int totalBytesRead = 0;
            int bytesRead = 0;
            int size = urlc.getContentLength();
            if (size >= 0) {
                block = size / 20;
            }
            System.out.println("0%       50%      100%");
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
                buffer = new byte[153600];
                if ((totalBytesRead += bytesRead) <= threshold) continue;
                System.err.print("=");
                threshold += block;
            }
            System.out.println();
            System.out.println("[INFO] Done. " + new Integer(totalBytesRead).toString() + "(" + size + ") bytes read.");
            writer.close();
            reader.close();
        }
        catch (MalformedURLException e) {
            String err = String.format("Could not interpret url: \"%s\"\n%s", urlstring, e.toString());
            throw new FileDownloadException(err);
        }
        catch (IOException e) {
            String err = String.format("IO Exception reading from URL: \"%s\"\n%s", urlstring, e.toString());
            throw new FileDownloadException(err);
        }
        return true;
    }
}

