/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.ConstraintClause;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlContext;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.ForeignKeyConstraint;
import java.io.IOException;
import java.util.List;

public class ForeignKeyConstraintClause
extends ConstraintClause {
    protected SqlObject _refTable;
    protected SqlObjectList<SqlObject> _refColumns = SqlObjectList.create();

    public ForeignKeyConstraintClause(ForeignKeyConstraint fkConstraint) {
        this(fkConstraint, fkConstraint.getColumns(), fkConstraint.getReferencedTable(), fkConstraint.getReferencedColumns());
    }

    public ForeignKeyConstraintClause(Object name, Object refTableStr) {
        this(name, null, refTableStr, null);
    }

    protected ForeignKeyConstraintClause(Object name, List<?> columns, Object refTableStr, List<?> refColumnStrs) {
        super(ConstraintClause.Type.FOREIGN_KEY, name, columns);
        this._refTable = Converter.toCustomTableSqlObject(refTableStr);
        this._refColumns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, refColumnStrs);
    }

    @Override
    public ForeignKeyConstraintClause addColumns(Column ... columns) {
        return this.addCustomColumns(columns);
    }

    @Override
    public ForeignKeyConstraintClause addCustomColumns(Object ... columnStrs) {
        super.addCustomColumns(columnStrs);
        return this;
    }

    public ForeignKeyConstraintClause addRefColumns(Column ... columns) {
        return this.addCustomRefColumns(columns);
    }

    public ForeignKeyConstraintClause addCustomRefColumns(Object ... columnStrs) {
        this._refColumns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        if (!vContext.isLocalOnly()) {
            ValidationContext refVContext = new ValidationContext(vContext);
            this._refTable.collectSchemaObjects(refVContext);
            this._refColumns.collectSchemaObjects(refVContext);
        }
    }

    @Override
    public void appendTo(AppendableExt app) throws IOException {
        super.appendTo(app);
        if (SqlContext.getContext(app).getUseTableConstraints()) {
            app.append((CharSequence)" ").append((CharSequence)this._type.toString(false));
        }
        app.append((CharSequence)" ").append((Appendee)this._refTable);
        if (!this._refColumns.isEmpty()) {
            app.append((CharSequence)" (").append(this._refColumns).append((CharSequence)")");
        }
    }
}

