/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.util.ChromosomeComparator;

public class GenomicRegion
implements Serializable,
Comparable<GenomicRegion> {
    private final String name;
    private final String chrom;
    private final int start;
    private final int end;

    public GenomicRegion(String name, String chrom, int start, int end) {
        this.name = name;
        this.chrom = chrom;
        this.start = start;
        this.end = end;
    }

    public String toString() {
        return String.format("%s%s:%d-%d", this.name != null ? this.name + " " : "", this.chrom, this.start, this.end);
    }

    public static GenomicRegion fromString(String str) {
        String name = null;
        String chrom = null;
        int start = 0;
        int end = 0;
        String[] strs = str.split(":");
        if (strs.length == 2) {
            int pos = strs[0].lastIndexOf(32);
            if (pos > 0) {
                name = strs[0].substring(0, pos);
                chrom = strs[0].substring(pos + 1);
            } else {
                chrom = strs[0];
            }
            strs = strs[1].split("-");
            if (strs.length == 2) {
                start = Integer.valueOf(strs[0]);
                end = Integer.valueOf(strs[1]);
            }
        }
        return new GenomicRegion(name, chrom, start, end);
    }

    public String getName() {
        return this.name;
    }

    public String getChrom() {
        return this.chrom;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public static Map<String, List<Range>> mergeGenomicRegions(Collection<GenomicRegion> regions) {
        HashMap chrMap = new HashMap();
        for (GenomicRegion r : regions) {
            if (r == null) continue;
            if (chrMap.get(r.getChrom()) == null) {
                chrMap.put(r.getChrom(), new ArrayList());
            }
            ((List)chrMap.get(r.getChrom())).add(new Range(r.getStart(), r.getEnd()));
        }
        HashMap<String, List<Range>> result = new HashMap<String, List<Range>>();
        for (String chrom : chrMap.keySet()) {
            List list = (List)chrMap.get(chrom);
            result.put(chrom, Range.merge(list));
        }
        return result;
    }

    public int getLength() {
        return this.getEnd() - this.getStart() + 1;
    }

    @Override
    public int compareTo(GenomicRegion t) {
        if (!this.chrom.equals(t.chrom)) {
            return new ChromosomeComparator().compare(this.chrom, t.chrom);
        }
        if (this.start != t.start) {
            return this.start - t.start;
        }
        if (this.end != t.end) {
            return this.end - t.end;
        }
        return this.name.compareTo(t.name);
    }
}

