/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.vcf;

import java.io.Serializable;
import org.apache.commons.lang.NumberUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ut.biolab.medsavant.shared.util.MiscUtils;

public class VariantRecord
implements Serializable {
    private static final int FILE_INDEX_OF_CHROM = 0;
    private static final int FILE_INDEX_OF_POS = 1;
    private static final int FILE_INDEX_OF_DBSNPID = 2;
    private static final int FILE_INDEX_OF_REF = 3;
    private static final int FILE_INDEX_OF_ALT = 4;
    private static final int FILE_INDEX_OF_QUAL = 5;
    private static final int FILE_INDEX_OF_FILTER = 6;
    private static final int FILE_INDEX_OF_INFO = 7;
    public static final Class CLASS_OF_VARIANTID = Integer.class;
    public static final Class CLASS_OF_GENOMEID = Integer.class;
    public static final Class CLASS_OF_PIPELINEID = String.class;
    public static final Class CLASS_OF_DNAID = String.class;
    public static final Class CLASS_OF_CHROM = String.class;
    public static final Class CLASS_OF_POSITION = Long.class;
    public static final Class CLASS_OF_DBSNPID = String.class;
    public static final Class CLASS_OF_REF = String.class;
    public static final Class CLASS_OF_ALT = String.class;
    public static final Class CLASS_OF_QUAL = Float.class;
    public static final Class CLASS_OF_FILTER = String.class;
    public static final Class CLASS_OF_CUSTOMINFO = String.class;
    private int uploadID;
    private int fileID;
    private int variantID;
    private int genomeID;
    private int pipelineID;
    private String dnaID;
    private String chrom;
    private Long start_position;
    private Long end_position;
    private String dbSNPID;
    private String ref;
    private String alt;
    private int altNumber;
    private Float qual;
    private String filter;
    private VariantType type;
    private Zygosity zygosity;
    private String genotype;
    private String customInfo;
    private Object[] customFields;
    private String ancestralAllele;
    private Integer alleleCount;
    private Float alleleFrequency;
    private Integer numberOfAlleles;
    private Integer baseQuality;
    private String cigar;
    private Boolean dbSNPMembership;
    private Integer depthOfCoverage;
    private Boolean hapmap2Membership;
    private Boolean hapmap3Membership;
    private Integer mappingQuality;
    private Integer numberOfZeroMQ;
    private Integer numberOfSamplesWithData;
    private Float strandBias;
    private Boolean isSomatic;
    private Boolean isValidated;
    private Boolean isInThousandGenomes;
    public static final String nullString = ".";
    private static String delim = "\t";

    public VariantRecord() {
    }

    public VariantRecord(String[] line, long start, long end, String ref, String alt, int altNumber, VariantType vt) throws Exception {
        this.dnaID = null;
        this.chrom = (String)VariantRecord.parse(CLASS_OF_CHROM, line[0]);
        if (!this.chrom.toLowerCase().startsWith("chr")) {
            String s = MiscUtils.homogenizeSequence(this.chrom);
            this.chrom = "chr" + s;
        }
        this.dbSNPID = (String)VariantRecord.parse(CLASS_OF_DBSNPID, line[2]);
        this.qual = (Float)VariantRecord.parse(CLASS_OF_QUAL, line[5]);
        this.filter = (String)VariantRecord.parse(CLASS_OF_FILTER, line[6]);
        this.customInfo = (String)VariantRecord.parse(CLASS_OF_CUSTOMINFO, line[7]);
        this.start_position = start;
        this.end_position = end;
        this.alt = alt;
        this.altNumber = altNumber;
        this.ref = ref;
        this.type = vt;
        this.extractInfo(this.customInfo);
    }

    public VariantRecord(int uploadID, int fileID, int variantID, int genomeID, int pipelineID, String dnaID, String chrom, long start_position, long end_position, String dbSNPID, String ref, String alt, int altNumber, float qual, String filter, String customInfo, Object[] customFields) {
        this.uploadID = uploadID;
        this.fileID = fileID;
        this.variantID = variantID;
        this.genomeID = genomeID;
        this.pipelineID = pipelineID;
        this.dnaID = dnaID;
        this.chrom = chrom;
        this.start_position = start_position;
        this.end_position = end_position;
        this.dbSNPID = dbSNPID;
        this.ref = ref;
        this.alt = alt;
        this.altNumber = altNumber;
        this.qual = Float.valueOf(qual);
        this.filter = filter;
        this.setCustomInfo(customInfo);
        this.customFields = customFields;
    }

    public VariantRecord(VariantRecord r) {
        this.setVariantID(r.getVariantID());
        this.setDnaID(r.getDnaID());
        this.setGenomeID(r.getGenomeID());
        this.setPipelineID(r.getPipelineID());
        this.setChrom(r.getChrom());
        this.setStartPosition(r.getStartPosition());
        this.setEndPosition(r.getEndPosition());
        this.setDbSNPID(r.getDbSNPID());
        this.setRef(r.getRef());
        this.setAlt(r.getAlt());
        this.setAltNumber(r.getAltNumber());
        this.setQual(r.getQual());
        this.setFilter(r.getFilter());
        this.setCustomInfo(r.getCustomInfo());
        this.setCustomFields(r.getCustomFields());
        this.setType(r.getType());
    }

    public void setAltNumber(int a) {
        this.altNumber = a;
    }

    public int getAltNumber() {
        return this.altNumber;
    }

    private static Object parse(Class c, String value) {
        if (c == String.class) {
            if (value.equals(nullString)) {
                return "";
            }
            return value;
        }
        if (value.equals(nullString)) {
            return null;
        }
        if (c == Long.class) {
            try {
                return NumberUtils.isDigits((String)value) ? Long.valueOf(Long.parseLong(value)) : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (c == Float.class) {
            try {
                return NumberUtils.isNumber((String)value) ? Float.valueOf(Float.parseFloat(value)) : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (c == Boolean.class) {
            return true;
        }
        if (c == Integer.class) {
            try {
                return NumberUtils.isDigits((String)value) ? Integer.valueOf(Integer.parseInt(value)) : null;
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new UnsupportedOperationException("Parser doesn't deal with objects of type " + c);
    }

    private VariantType variantTypeHelper(VariantType currentType, VariantType newType) {
        if (currentType == null || currentType == newType) {
            return newType;
        }
        return VariantType.Various;
    }

    public static Object[] parseInfo(String infoString, String[] infoKeys, Class[] infoClasses) {
        String[] list;
        Object[] values = new Object[infoKeys.length];
        infoString = infoString.trim();
        String[] arr$ = list = infoString.split(";");
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String element;
            String name = element = arr$[i$];
            String value = "";
            int equals = element.indexOf("=");
            if (equals != -1) {
                name = element.substring(0, equals);
                value = element.substring(equals + 1);
            }
            for (int i = 0; i < infoKeys.length; ++i) {
                if (!name.toLowerCase().equals(infoKeys[i].toLowerCase())) continue;
                values[i] = VariantRecord.parse(infoClasses[i], value);
            }
        }
        return values;
    }

    public int getUploadID() {
        return this.uploadID;
    }

    public void setUploadIDID(int uploadID) {
        this.uploadID = uploadID;
    }

    public int getFileID() {
        return this.fileID;
    }

    public void setFileID(int fileID) {
        this.fileID = fileID;
    }

    public int getVariantID() {
        return this.variantID;
    }

    public void setVariantID(int variantID) {
        this.variantID = variantID;
    }

    public int getGenomeID() {
        return this.genomeID;
    }

    public void setGenomeID(int genomeID) {
        this.genomeID = genomeID;
    }

    public int getPipelineID() {
        return this.pipelineID;
    }

    public void setPipelineID(int pipelineID) {
        this.pipelineID = pipelineID;
    }

    public String getAlt() {
        return this.alt;
    }

    public void setAlt(String alt) {
        this.alt = alt;
    }

    public String getChrom() {
        return this.chrom;
    }

    public void setChrom(String chrom) {
        this.chrom = chrom;
    }

    public String getDbSNPID() {
        return this.dbSNPID;
    }

    public void setDbSNPID(String id) {
        this.dbSNPID = id;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Long getStartPosition() {
        return this.start_position;
    }

    public void setStartPosition(Long pos) {
        this.start_position = pos;
    }

    public Long getEndPosition() {
        return this.end_position;
    }

    public void setEndPosition(Long pos) {
        this.end_position = pos;
    }

    public Float getQual() {
        return this.qual;
    }

    public void setQual(Float qual) {
        this.qual = qual;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getDnaID() {
        return this.dnaID;
    }

    public void setDnaID(String dnaID) {
        this.dnaID = dnaID;
    }

    public String getCustomInfo() {
        return this.customInfo;
    }

    public void setCustomInfo(String customInfo) {
        this.customInfo = customInfo;
        this.extractInfo(customInfo);
    }

    public Object[] getCustomFields() {
        return this.customFields;
    }

    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    public Zygosity getZygosity() {
        return this.zygosity;
    }

    public void setZygosity(Zygosity zygosity) {
        this.zygosity = zygosity;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public void setGenotype(String genotype) {
        this.genotype = genotype;
    }

    public void setCustomFields(Object[] customFields) {
        this.customFields = customFields;
    }

    public int compareTo(VariantRecord other) {
        return this.compareTo(other.getChrom(), other.getStartPosition(), other.getEndPosition());
    }

    public int compareTo(String chrom, long startpos, long endpos) {
        int chromCompare = VariantRecord.compareChrom(this.getChrom(), chrom);
        if (chromCompare != 0) {
            return chromCompare;
        }
        int i1 = this.getStartPosition().compareTo(startpos);
        int i2 = this.getEndPosition().compareTo(endpos);
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 == 0) {
            return i2;
        }
        return i1;
    }

    public static int compareChrom(String chrom1, String chrom2) {
        chrom1 = chrom1.substring(3);
        chrom2 = chrom2.substring(3);
        try {
            if (NumberUtils.isNumber((String)chrom1) && NumberUtils.isNumber((String)chrom2)) {
                Integer a = Integer.parseInt(chrom1);
                Integer b = Integer.parseInt(chrom2);
                return a.compareTo(b);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return chrom1.compareTo(chrom2);
    }

    public Integer getAlleleCount() {
        return this.alleleCount;
    }

    public Float getAlleleFrequency() {
        return this.alleleFrequency;
    }

    public String getAncestralAllele() {
        return this.ancestralAllele;
    }

    public Integer getBaseQuality() {
        return this.baseQuality;
    }

    public String getCigar() {
        return this.cigar;
    }

    public Boolean getDbSNPMembership() {
        return this.dbSNPMembership;
    }

    public Integer getDepthOfCoverage() {
        return this.depthOfCoverage;
    }

    public Boolean getHapmap2Membership() {
        return this.hapmap2Membership;
    }

    public Boolean getHapmap3Membership() {
        return this.hapmap3Membership;
    }

    public Boolean getIsInThousandGenomes() {
        return this.isInThousandGenomes;
    }

    public Boolean getIsSomatic() {
        return this.isSomatic;
    }

    public Boolean getIsValidated() {
        return this.isValidated;
    }

    public Integer getMappingQuality() {
        return this.mappingQuality;
    }

    public Integer getNumberOfAlleles() {
        return this.numberOfAlleles;
    }

    public Integer getNumberOfSamplesWithData() {
        return this.numberOfSamplesWithData;
    }

    public Integer getNumberOfZeroMQ() {
        return this.numberOfZeroMQ;
    }

    public Float getStrandBias() {
        return this.strandBias;
    }

    private Float extractFloatFromInfo(String key, String customInfo) {
        String val = this.extractValueFromInfo(key, customInfo);
        return (Float)VariantRecord.parse(Float.class, val);
    }

    private String extractStringFromInfo(String key, String customInfo) {
        String val = this.extractValueFromInfo(key, customInfo);
        return val;
    }

    private Integer extractIntegerFromInfo(String key, String customInfo) {
        String val = this.extractValueFromInfo(key, customInfo);
        return (Integer)VariantRecord.parse(Integer.class, val);
    }

    private Boolean extractBooleanFromInfo(String key, String customInfo) {
        Integer val = this.extractIntegerFromInfo(key, customInfo);
        if (val == null) {
            return null;
        }
        if (val == 1) {
            return true;
        }
        return false;
    }

    private String extractValueFromInfo(String key, String customInfo) {
        String eKey = key + "=";
        int startIndex = customInfo.indexOf(eKey);
        if (startIndex == -1) {
            return "";
        }
        String sub = customInfo.substring(startIndex += eKey.length());
        int endIndex = sub.indexOf(";");
        String result = endIndex == -1 ? sub : sub.substring(0, endIndex);
        if (result.equals("")) {
            return null;
        }
        return result;
    }

    private void extractInfo(String info) {
        this.ancestralAllele = this.extractStringFromInfo("AA", info);
        this.alleleCount = this.extractIntegerFromInfo("AC", info);
        this.alleleFrequency = this.extractFloatFromInfo("AF", info);
        this.numberOfAlleles = this.extractIntegerFromInfo("AN", info);
        this.baseQuality = this.extractIntegerFromInfo("BQ", info);
        this.cigar = this.extractStringFromInfo("CIGAR", info);
        this.dbSNPMembership = this.extractBooleanFromInfo("DB", info);
        this.depthOfCoverage = this.extractIntegerFromInfo("DP", info);
        this.hapmap2Membership = this.extractBooleanFromInfo("H2", info);
        this.hapmap3Membership = this.extractBooleanFromInfo("H3", info);
        this.mappingQuality = this.extractIntegerFromInfo("MQ", info);
        this.numberOfZeroMQ = this.extractIntegerFromInfo("MQ0", info);
        this.numberOfSamplesWithData = this.extractIntegerFromInfo("NS", info);
        this.strandBias = this.extractFloatFromInfo("SB", info);
        this.isSomatic = this.extractBooleanFromInfo("SOMATIC", info);
        this.isValidated = this.extractBooleanFromInfo("VALIDATED", info);
        this.isInThousandGenomes = this.extractBooleanFromInfo("1000G", info);
    }

    public String toString() {
        return "VariantRecord{dnaID=" + this.dnaID + "chrom=" + this.chrom + "startpos=" + this.start_position + "endpos=" + this.end_position + "id=" + this.dbSNPID + "ref=" + this.ref + "alt=" + this.alt + "qual=" + this.qual + "filter=" + this.filter + '}';
    }

    public String toTabString(int uploadId, int fileId, int variantId) {
        String s = "\"" + VariantRecord.getString(uploadId) + "\"" + delim + "\"" + VariantRecord.getString(fileId) + "\"" + delim + "\"" + VariantRecord.getString(variantId) + "\"" + delim + "\"" + VariantRecord.getString(this.dnaID) + "\"" + delim + "\"" + VariantRecord.getString(this.chrom) + "\"" + delim + "\"" + VariantRecord.getString(this.start_position) + "\"" + delim + "\"" + VariantRecord.getString(this.end_position) + "\"" + delim + "\"" + VariantRecord.getString(this.dbSNPID) + "\"" + delim + "\"" + VariantRecord.getString(this.ref) + "\"" + delim + "\"" + VariantRecord.getString(this.alt) + "\"" + delim + "\"" + VariantRecord.getString(this.altNumber) + "\"" + delim + "\"" + VariantRecord.getString(this.qual) + "\"" + delim + "\"" + VariantRecord.getString(this.filter) + "\"" + delim + "\"" + VariantRecord.getString((Object)this.type) + "\"" + delim + "\"" + VariantRecord.getString((Object)this.zygosity) + "\"" + delim + "\"" + VariantRecord.getString(this.genotype) + "\"" + delim + "\"" + VariantRecord.getString(this.customInfo) + "\"";
        return s;
    }

    public static String createTabString(Object[] values) {
        String s = "";
        if (values.length == 0) {
            return s;
        }
        for (Object o : values) {
            s = s + "\"" + StringEscapeUtils.escapeJava((String)VariantRecord.getString(o)) + "\"" + delim;
        }
        return s.substring(0, s.length() - 1);
    }

    private static String getString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return "1";
            }
            return "0";
        }
        return value.toString();
    }

    public void setSampleInformation(String format, String info) {
        String formatted = "FORMAT=" + format + ";SAMPLE_INFO=" + info;
        String newCustomInfo = this.customInfo == null ? formatted : this.customInfo + ";" + formatted;
        this.setCustomInfo(newCustomInfo);
    }

    public static enum Zygosity {
        HomoRef,
        HomoAlt,
        Hetero,
        HeteroTriallelic,
        Missing;


        public static Zygosity getZygosity(int zygosity) {
            switch (zygosity) {
                case 0: {
                    return HomoRef;
                }
                case 1: {
                    return HomoAlt;
                }
                case 2: {
                    return Hetero;
                }
                case 3: {
                    return HeteroTriallelic;
                }
                case 4: {
                    return Missing;
                }
            }
            return HomoRef;
        }
    }

    public static enum VariantType {
        SNP,
        Insertion,
        Deletion,
        Various,
        Unknown,
        InDel,
        Complex,
        HomoRef;


        public static VariantType getVariantType(int type) {
            switch (type) {
                case 0: {
                    return SNP;
                }
                case 1: {
                    return Insertion;
                }
                case 2: {
                    return Deletion;
                }
                case 3: {
                    return Various;
                }
                case 4: {
                    return Unknown;
                }
                case 5: {
                    return InDel;
                }
                case 6: {
                    return Complex;
                }
                case 7: {
                    return HomoRef;
                }
            }
            return Unknown;
        }
    }
}

