/*
 * Decompiled with CFR 0.152.
 */
package CSVLoader;

import CSVLoader.DateUtil;
import au.com.bytecode.opencsv.CSVReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class CSVLoader {
    private static final String SQL_INSERT = "INSERT INTO ${table}(${keys}) VALUES(${values})";
    private static final String TABLE_REGEX = "\\$\\{table\\}";
    private static final String KEYS_REGEX = "\\$\\{keys\\}";
    private static final String VALUES_REGEX = "\\$\\{values\\}";
    private Connection connection;
    private char seprator;

    public CSVLoader(Connection connection) {
        this.connection = connection;
        this.seprator = (char)44;
    }

    public void loadCSV(InputStream csvFile, String tableName, boolean truncateBeforeLoad) throws Exception {
        CSVReader csvReader = null;
        if (null == this.connection) {
            throw new Exception("Not a valid connection.");
        }
        try {
            csvReader = new CSVReader((Reader)new InputStreamReader(csvFile), this.seprator, '\"', '\u0000');
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error occured while executing file. " + e.getMessage());
        }
        Object[] headerRow = csvReader.readNext();
        if (null == headerRow) {
            throw new FileNotFoundException("No columns defined in given CSV file.Please check the CSV file format.");
        }
        String questionmarks = StringUtils.repeat((String)"?,", (int)headerRow.length);
        questionmarks = (String)questionmarks.subSequence(0, questionmarks.length() - 1);
        String query = SQL_INSERT.replaceFirst(TABLE_REGEX, tableName);
        query = query.replaceFirst(KEYS_REGEX, StringUtils.join((Object[])headerRow, (String)","));
        query = query.replaceFirst(VALUES_REGEX, questionmarks);
        Connection con = null;
        Statement ps = null;
        try {
            String[] nextLine;
            con = this.connection;
            con.setAutoCommit(false);
            ps = con.prepareStatement(query);
            if (truncateBeforeLoad) {
                con.createStatement().execute("DELETE FROM " + tableName);
            }
            int batchSize = 1000;
            int count = 0;
            Date date = null;
            while ((nextLine = csvReader.readNext()) != null) {
                if (null != nextLine) {
                    int index = 1;
                    for (String string : nextLine) {
                        date = DateUtil.convertToDate(string);
                        if (null != date) {
                            ps.setDate(index++, new java.sql.Date(date.getTime()));
                            continue;
                        }
                        if (string.length() > 0 && !string.equals("\\N")) {
                            ps.setString(index++, string);
                            continue;
                        }
                        ps.setNull(index++, 12);
                    }
                    ps.addBatch();
                }
                if (++count % 1000 != 0) continue;
                ps.executeBatch();
            }
            ps.executeBatch();
            System.out.println("[" + this.getClass().getSimpleName() + "]: " + count + " records loaded into " + tableName + " DB table");
            con.commit();
        }
        catch (Exception e) {
            con.rollback();
            e.printStackTrace();
            throw new Exception("Error occured while loading data from file to database." + e.getMessage());
        }
        finally {
            if (null != ps) {
                ps.close();
            }
            if (null != con) {
                con.close();
            }
            csvReader.close();
        }
    }

    public char getSeprator() {
        return this.seprator;
    }

    public void setSeprator(char seprator) {
        this.seprator = seprator;
    }
}

