/*
 * Decompiled with CFR 0.152.
 */
package pgx;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class PGXPDFExporter {
    private static final float pageHeight = 1400.0f;
    private static final float pageWidth = 1400.0f / (float)Math.sqrt(2.0);
    private JTabbedPane tabs;
    private OutputStream os;

    public PGXPDFExporter(JTabbedPane tabs, String filename) {
        this.tabs = tabs;
        try {
            this.os = new FileOutputStream(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getNumPages(JPanel jp) {
        return (int)Math.ceil((float)jp.getPreferredSize().height / 1400.0f);
    }

    public void createMultipagePDF() throws DocumentException {
        Document doc = new Document(new Rectangle(pageWidth, 1400.0f));
        PdfWriter writer = PdfWriter.getInstance(doc, this.os);
        doc.open();
        PdfContentByte cb = writer.getDirectContent();
        for (int i = 0; i != this.tabs.getTabCount(); ++i) {
            JPanel jp = (JPanel)this.tabs.getComponent(i);
            for (int currentPage = 0; currentPage < this.getNumPages(jp); ++currentPage) {
                doc.newPage();
                PdfTemplate template = cb.createTemplate(pageWidth, 1400.0f);
                PdfGraphics2D g2d = new PdfGraphics2D(template, pageWidth, 1400.0f * (float)(currentPage + 1));
                jp.printAll(g2d);
                ((Graphics)g2d).dispose();
                cb.addTemplate(template, 0.0f, 0.0f);
            }
        }
        doc.close();
    }
}

