/*
 * Decompiled with CFR 0.152.
 */
package pgx.localDB;

import CSVLoader.CSVLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;

public class PGXDB {
    private static final String db_path_prefix = "mem:pharmacogenomicsdb";
    private static final String DB_URL = "jdbc:hsqldb:mem:pharmacogenomicsdb";
    private static final String GENE_MARKER_LIST_FILE_PATH = "/pgx/localDBFiles/gene_marker_list.txt";
    private static final String HAPLOTYPE_MARKERS_FILE_PATH = "/pgx/localDBFiles/haplotype_markers.txt";
    private static final String MARKER_COORDINATES_FILE_PATH = "/pgx/localDBFiles/marker_coordinates.txt";
    private static final String HAPLOTYPE_ACTIVITY_FILE_PATH = "/pgx/localDBFiles/haplotype_activity.txt";
    private static final String ACTIVITY_TO_METABOLIZER_FILE_PATH = "/pgx/localDBFiles/activity_to_metabolizer.txt";
    private static final String PHENOTYPE_TO_METABOLIZER_FILE_PATH = "/pgx/localDBFiles/phenotype_to_metabolizer.txt";
    private static final String GENE_MARKER_LIST_TABLE_NAME = "gene_marker_list";
    private static final String HAPLOTYPE_MARKERS_TABLE_NAME = "haplotype_markers";
    private static final String MARKER_COORDINATES_TABLE_NAME = "marker_coordinates";
    private static final String HAPLOTYPE_ACTIVITY_TABLE_NAME = "haplotype_activity";
    private static final String ACTIVITY_TO_METABOLIZER_TABLE_NAME = "activity_to_metabolizer";
    private static final String PHENOTYPE_TO_METABOLIZER_TABLE_NAME = "phenotype_to_metabolizer";
    private static Connection conn;

    public static void initialize() throws SQLException {
        conn = PGXDB.connectionToServer();
        PGXDB.createSchema(conn);
        PGXDB.loadTables(conn);
    }

    public static void closeConnectionToDB() throws SQLException {
        conn.close();
    }

    private static Connection connectionToServer() throws SQLException {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Exception e) {
            System.err.println("[" + PGXDB.class.getSimpleName() + "]: failed to load HSQLDB JDBC driver.");
            e.printStackTrace();
        }
        return DriverManager.getConnection(DB_URL);
    }

    private static void createSchema(Connection c) {
        try {
            Statement s = c.createStatement();
            String sql = "SET IGNORECASE TRUE";
            s.addBatch(sql);
            sql = "CREATE TABLE gene_marker_list (   Gene varchar(20) NOT NULL,   Marker_list varchar(50000) NOT NULL,   PRIMARY KEY (Gene)  )";
            s.addBatch(sql);
            sql = "CREATE TABLE haplotype_markers ( \tGene varchar(20) NOT NULL, \tHaplotype_ID varchar(1000) DEFAULT NULL, \tHaplotype_Symbol varchar(100) NOT NULL, \tMarker_info varchar(50000) DEFAULT NULL, \tPRIMARY KEY (Gene,Haplotype_Symbol)  )";
            s.addBatch(sql);
            sql = "CREATE TABLE marker_coordinates ( \tMarker varchar(40) NOT NULL, \tChromosome varchar(20) NOT NULL, \tPosition int NOT NULL, \tRef varchar(10000) NOT NULL, \tAlt varchar(10000) NOT NULL, \tPRIMARY KEY (Marker,Position, Alt)  )";
            s.addBatch(sql);
            sql = "CREATE TABLE haplotype_activity ( \tGene varchar(20) NOT NULL, \tHaplotype varchar(10) NOT NULL, \tActivity_Score double DEFAULT NULL, \tActivity_Phenotype varchar(100) NOT NULL, \tPubmed_ID varchar(1000) NOT NULL, \tPRIMARY KEY (Gene, Haplotype) )";
            s.addBatch(sql);
            sql = "CREATE TABLE activity_to_metabolizer ( \tTotal_Activity_Score_Minimum double NOT NULL, \tMetabolizer_class varchar(100) NOT NULL, )";
            s.addBatch(sql);
            sql = "CREATE TABLE phenotype_to_metabolizer ( \tHaplotype_1_activity varchar(100) NOT NULL, \tHaplotype_2_activity varchar(100) NOT NULL, \tMetabolizer_class varchar(100) NOT NULL, )";
            s.addBatch(sql);
            s.executeBatch();
            s.close();
        }
        catch (SQLException e) {
            System.err.println("[" + PGXDB.class.getSimpleName() + "]: Error creating tables " + e.toString());
            e.printStackTrace();
        }
    }

    private static void loadTables(Connection c) throws SQLException {
        try {
            CSVLoader loader = new CSVLoader(PGXDB.connectionToServer());
            loader.setSeprator('\t');
            loader.loadCSV(PGXDB.class.getResourceAsStream(GENE_MARKER_LIST_FILE_PATH), GENE_MARKER_LIST_TABLE_NAME, false);
            loader = new CSVLoader(PGXDB.connectionToServer());
            loader.setSeprator('\t');
            loader.loadCSV(PGXDB.class.getResourceAsStream(HAPLOTYPE_MARKERS_FILE_PATH), HAPLOTYPE_MARKERS_TABLE_NAME, false);
            loader = new CSVLoader(PGXDB.connectionToServer());
            loader.setSeprator('\t');
            loader.loadCSV(PGXDB.class.getResourceAsStream(MARKER_COORDINATES_FILE_PATH), MARKER_COORDINATES_TABLE_NAME, false);
            loader = new CSVLoader(PGXDB.connectionToServer());
            loader.setSeprator('\t');
            loader.loadCSV(PGXDB.class.getResourceAsStream(HAPLOTYPE_ACTIVITY_FILE_PATH), HAPLOTYPE_ACTIVITY_TABLE_NAME, false);
            loader = new CSVLoader(PGXDB.connectionToServer());
            loader.setSeprator('\t');
            loader.loadCSV(PGXDB.class.getResourceAsStream(ACTIVITY_TO_METABOLIZER_FILE_PATH), ACTIVITY_TO_METABOLIZER_TABLE_NAME, false);
            loader = new CSVLoader(PGXDB.connectionToServer());
            loader.setSeprator('\t');
            loader.loadCSV(PGXDB.class.getResourceAsStream(PHENOTYPE_TO_METABOLIZER_FILE_PATH), PHENOTYPE_TO_METABOLIZER_TABLE_NAME, false);
        }
        catch (Exception e) {
            System.err.println("[" + PGXDB.class.getSimpleName() + "]: Error loading tables " + e.toString());
            e.printStackTrace();
        }
    }

    public static Connection getConnection() {
        return conn;
    }

    public static ResultSet executeQuery(String sql) throws SQLException {
        Statement s = conn.createStatement();
        s.execute(sql);
        ResultSet rs = s.getResultSet();
        s.close();
        return rs;
    }

    public static void printQueryResults(String sql) throws SQLException {
        Statement s = conn.createStatement();
        s.execute(sql);
        ResultSet rs = s.getResultSet();
        while (rs.next()) {
            System.out.println("[" + PGXDB.class.getSimpleName() + "]: " + PGXDB.getRowAsString(rs));
        }
        s.close();
    }

    public static String getRowAsString(ResultSet rs) throws SQLException {
        String result = "";
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        for (int i = 1; i <= columnsNumber; ++i) {
            result = result + rs.getString(i) + "\t";
        }
        return result;
    }

    public static List<Object> getRowAsList(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnsNumber = rsmd.getColumnCount();
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 1; i <= columnsNumber; ++i) {
            result.add(rs.getString(i));
        }
        return result;
    }
}

