/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.util;

import net.sf.samtools.util.LineReader;

public class StringLineReader
implements LineReader {
    private final String theString;
    private int curPos = 0;
    private int lineNumber = 0;

    public StringLineReader(String s) {
        this.theString = s.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    public String readLine() {
        return this.readLine(false);
    }

    private String readLine(boolean includeTerminators) {
        if (this.curPos == this.theString.length()) {
            return null;
        }
        int nextLfIndex = this.theString.indexOf(10, this.curPos);
        if (nextLfIndex == -1) {
            int startPos = this.curPos;
            this.curPos = this.theString.length();
            ++this.lineNumber;
            return this.theString.substring(startPos);
        }
        int startPos = this.curPos;
        int endPos = nextLfIndex + (includeTerminators ? 1 : 0);
        this.curPos = nextLfIndex + 1;
        ++this.lineNumber;
        return this.theString.substring(startPos, endPos);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int peek() {
        if (this.curPos == this.theString.length()) {
            return -1;
        }
        return this.theString.charAt(this.curPos);
    }

    public void close() {
        this.curPos = this.theString.length();
    }
}

