/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.ut.biolab.medsavant.shared.model.MedSavantServerJobProgress;

public abstract class MedSavantServerJob
implements Callable<Void> {
    private static Map<String, List<MedSavantServerJobProgress>> rootJobs;
    private static final Object rootJobLock;
    private final MedSavantServerJobProgress jobProgress;
    private long expiryTime = 0L;
    private MedSavantServerJob parentJob;
    private static final Object jobExpiryLock;
    private static final List<MedSavantServerJob> jobsToExpire;
    private static final long EXPIRATION_CHECK_INTERVAL = 120000L;
    private static final long JOB_EXPIRATION_TIME = 300000L;

    private void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    void setScheduleStatus(MedSavantServerJobProgress.ScheduleStatus status) {
        this.jobProgress.setStatus(status);
    }

    public static List<MedSavantServerJobProgress> getJobProgressesForUser(String userId) {
        if (rootJobs == null) {
            return null;
        }
        return rootJobs.get(userId);
    }

    public MedSavantServerJobProgress.ScheduleStatus getScheduleStatus() {
        return this.jobProgress.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MedSavantServerJob(String userId, String jobName, MedSavantServerJob parentJob) {
        this.jobProgress = new MedSavantServerJobProgress(userId, jobName);
        this.parentJob = parentJob;
        if (parentJob != null) {
            parentJob.jobProgress.addChildJobProgress(this.jobProgress);
        } else {
            if (rootJobs == null) {
                rootJobs = new HashMap<String, List<MedSavantServerJobProgress>>();
            }
            Object object = rootJobLock;
            synchronized (object) {
                List<MedSavantServerJobProgress> myRootJobs = rootJobs.get(userId);
                if (myRootJobs == null) {
                    myRootJobs = new LinkedList<MedSavantServerJobProgress>();
                }
                myRootJobs.add(this.jobProgress);
                rootJobs.put(userId, myRootJobs);
            }
        }
    }

    public MedSavantServerJobProgress getJobProgress() {
        return this.jobProgress;
    }

    private static void initTimer() {
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = jobExpiryLock;
                synchronized (object) {
                    ListIterator jobIterator = jobsToExpire.listIterator();
                    while (jobIterator.hasNext()) {
                        MedSavantServerJob job = (MedSavantServerJob)jobIterator.next();
                        if (job.expiryTime > System.currentTimeMillis() || job.hasChildren()) continue;
                        job.expireImmediately();
                        jobIterator.remove();
                    }
                }
            }
        }, 120000L, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireImmediately() {
        if (this.parentJob != null) {
            this.parentJob.jobProgress.childJobProgresses.remove(this.jobProgress);
        } else {
            Object object = rootJobLock;
            synchronized (object) {
                int i;
                List<MedSavantServerJobProgress> myJobs = rootJobs.get(this.jobProgress.getUserId());
                if (myJobs != null && !myJobs.isEmpty() && (i = myJobs.indexOf(this.jobProgress)) >= 0) {
                    myJobs.remove(i);
                }
            }
        }
        this.jobProgress.childJobProgresses = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expire() {
        Object object = jobExpiryLock;
        synchronized (object) {
            this.setExpiryTime(System.currentTimeMillis() + 300000L);
            this.jobProgress.setMessage(this.jobProgress.getMessage() + " (Message will expire in ~" + 300L + " sec)");
            jobsToExpire.add(this);
        }
    }

    @Override
    public final Void call() throws Exception {
        try {
            if (this.getScheduleStatus() == MedSavantServerJobProgress.ScheduleStatus.SCHEDULED_AS_LONGJOB) {
                this.setScheduleStatus(MedSavantServerJobProgress.ScheduleStatus.RUNNING_AS_LONGJOB);
            } else if (this.getScheduleStatus() == MedSavantServerJobProgress.ScheduleStatus.SCHEDULED_AS_SHORTJOB) {
                this.setScheduleStatus(MedSavantServerJobProgress.ScheduleStatus.RUNNING_AS_SHORTJOB);
            } else {
                throw new IllegalArgumentException("MedSavantJob cannot run in this state: " + (Object)((Object)this.getScheduleStatus()));
            }
            if (this.run()) {
                this.setScheduleStatus(MedSavantServerJobProgress.ScheduleStatus.FINISHED);
            } else {
                this.setScheduleStatus(MedSavantServerJobProgress.ScheduleStatus.CANCELLED);
            }
            Void void_ = null;
            return void_;
        }
        catch (Exception ex) {
            this.jobProgress.setMessage("Aborted due to error: " + ex.getMessage());
            ex.printStackTrace();
            this.setScheduleStatus(MedSavantServerJobProgress.ScheduleStatus.CANCELLED);
            throw ex;
        }
        finally {
            this.expire();
        }
    }

    public boolean hasChildren() {
        return this.jobProgress.childJobProgresses != null && !this.jobProgress.childJobProgresses.isEmpty();
    }

    public abstract boolean run() throws Exception;

    static {
        rootJobLock = new Object();
        jobExpiryLock = new Object();
        jobsToExpire = new LinkedList<MedSavantServerJob>();
        MedSavantServerJob.initTimer();
    }
}

