/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.PooledConnection;

public class ConnectionPool {
    private static final Log LOG = LogFactory.getLog(ConnectionPool.class);
    private static final long TIMEOUT = 60000L;
    private final List<PooledConnection> connections;
    private final String user;
    private final String password;
    private String dbName;
    private ConnectionReaper reaper;

    public ConnectionPool(String db, String user, String password) {
        this.dbName = db;
        this.user = user;
        this.password = password;
        this.connections = new ArrayList<PooledConnection>();
        this.reaper = new ConnectionReaper();
        this.reaper.start();
    }

    public synchronized void reapConnections() {
        long stale = System.currentTimeMillis() - 60000L;
        for (PooledConnection conn : this.connections) {
            if (!conn.inUse() || stale <= conn.getLastUse() || conn.validate()) continue;
            this.removeConnection(conn);
        }
    }

    public synchronized void close() {
        while (this.connections.size() > 0) {
            this.removeConnection(this.connections.get(0));
        }
        this.reaper = null;
    }

    private synchronized void removeConnection(PooledConnection conn) {
        this.connections.remove(conn);
    }

    public synchronized PooledConnection getConnection() throws SQLException {
        for (PooledConnection conn : this.connections) {
            if (!conn.lease()) continue;
            return conn;
        }
        LOG.info((Object)(this.connections.size() + " connections opened, all in use. Creating new connection to " + this.dbName + " for " + this.user));
        Connection conn = DriverManager.getConnection(ConnectionController.getConnectionString(this.dbName), this.user, this.password);
        PooledConnection pooledConn = new PooledConnection(conn, this);
        pooledConn.lease();
        this.connections.add(pooledConn);
        return pooledConn;
    }

    public synchronized void returnConnection(PooledConnection conn) {
        conn.expireLease();
    }

    public String getDBName() {
        return this.dbName;
    }

    public synchronized void setDBName(String db) {
        if (!db.equals(this.dbName)) {
            for (PooledConnection c : this.connections) {
                this.returnConnection(c);
            }
            LOG.info((Object)("Returned connections for " + this.dbName + ", new database will be " + db));
            this.dbName = db;
        }
    }

    public String getUser() {
        return this.user;
    }

    private class ConnectionReaper
    extends Thread {
        private static final long DELAY = 30000L;

        private ConnectionReaper() {
        }

        @Override
        public void run() {
            while (ConnectionPool.this.reaper != null) {
                try {
                    ConnectionReaper.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ConnectionPool.this.reapConnections();
            }
        }
    }
}

