/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.model.exception.LockException;

public class LockController {
    private static Log LOG = LogFactory.getLog(LockController.class);
    private static LockController instance;
    private final HashMap<Key, ReentrantLock> locks = new HashMap();

    private LockController() {
    }

    public static LockController getInstance() {
        if (instance == null) {
            instance = new LockController();
        }
        return instance;
    }

    public synchronized void requestLock(String database, int projectID) throws LockException {
        LOG.info((Object)"Server lock requested");
        Key key = new Key(database, projectID);
        ReentrantLock lock = this.locks.get(key);
        if (lock == null) {
            lock = new ReentrantLock();
            this.locks.put(key, lock);
        }
        if (lock.isLocked() && !lock.isHeldByCurrentThread()) {
            throw new LockException("Database is locked for changes");
        }
        lock.lock();
        LOG.info((Object)String.format("Server locked - hold count %d", lock.getHoldCount()));
    }

    public synchronized void releaseLock(String database, int projectID) throws LockException {
        this.releaseLock(database, projectID, false);
    }

    public synchronized void releaseLock(String database, int projectID, boolean force) throws LockException {
        LOG.info((Object)"Server unlock requested");
        Key k = new Key(database, projectID);
        ReentrantLock lock = this.locks.get(k);
        if (lock == null) {
            throw new LockException("No lock exists");
        }
        if (force) {
            while (lock.isLocked()) {
                lock.unlock();
            }
            LOG.info((Object)String.format("Server forcibly unlocked - hold count %d", lock.getHoldCount()));
        } else if (lock.isHeldByCurrentThread()) {
            lock.unlock();
            LOG.info((Object)String.format("Server unlocked - hold count %d", lock.getHoldCount()));
        } else {
            throw new LockException("Database could not be unlocked");
        }
    }

    public boolean isLocked(String database, int projectID) {
        ReentrantLock l = this.locks.get(new Key(database, projectID));
        if (l == null) {
            return false;
        }
        return l.isLocked();
    }

    private class Key {
        String database;
        int projectId;

        Key(String database, int projectId) {
            this.database = database;
            this.projectId = projectId;
        }

        public String getDatabase() {
            return this.database;
        }

        public int getProjectId() {
            return this.projectId;
        }

        public String toString() {
            return this.database + "_" + this.projectId;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key k = (Key)o;
                return this.database.equals(k.database) && this.projectId == k.projectId;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

