/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants;

import jannovar.exception.JannovarException;
import jannovar.io.SerializationManager;
import jannovar.reference.Chromosome;
import jannovar.reference.TranscriptModel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class Jannovar {
    private String reference;
    private static Map<String, URL> referenceToRefSeqSerURL;
    private static final Log LOG;
    private static SerializationManager sManager;
    private static HashMap<Byte, Chromosome> chromosomeMap;
    private static String dirPath;
    private static ArrayList<TranscriptModel> transcriptModelList;

    public Jannovar(String reference) {
        referenceToRefSeqSerURL = new HashMap<String, URL>();
        referenceToRefSeqSerURL.put("hg19", WebResources.JANNOVAR_HG19_SERFILE_URL);
        this.reference = reference;
    }

    public File[] annotateVCFFiles(File[] vcfFiles, String database, int projectID, File destDir) throws JannovarException, IOException {
        this.initialize();
        File[] jvFiles = new File[vcfFiles.length];
        int counter = 0;
        for (File file : vcfFiles) {
            LOG.info((Object)("Annotating " + file.getAbsolutePath() + " with Jannovar"));
            jvFiles[counter++] = this.annotateVCFWithJannovar(file, destDir);
            LOG.info((Object)("Done annotating " + file.getAbsolutePath() + " with Jannovar"));
        }
        return jvFiles;
    }

    private File getJannovarDataDirectory() {
        File parent = new File(DirectorySettings.getCacheDirectory().getPath(), "jannovar");
        File f = new File(parent, "data");
        f.mkdirs();
        return f;
    }

    private File getRefSeqSerializedFile() {
        return new File(this.getJannovarDataDirectory(), "refseq_" + this.reference + ".ser");
    }

    private boolean initialize() throws IOException {
        if (!this.hasSerializedFile()) {
            LOG.info((Object)"Creating serialized RefSeq file...");
            LOG.info((Object)"Compiling serialized file with Jannovar");
            jannovar.Jannovar.main((String[])new String[]{"--create-refseq", "-d", this.getJannovarDataDirectory().getAbsolutePath()});
        }
        return true;
    }

    private boolean hasSerializedFile() {
        return this.getRefSeqSerializedFile().exists();
    }

    private File annotateVCFWithJannovar(File sourceVCF, File destDir) throws JannovarException, IOException {
        String outname = sourceVCF.getName();
        int i = outname.lastIndexOf("vcf");
        if (i < 0) {
            i = outname.lastIndexOf("VCF");
        }
        outname = i < 0 ? outname + ".jv.vcf" : outname.substring(0, i) + "jv.vcf";
        File outFile = new File(destDir, outname);
        jannovar.Jannovar.main((String[])new String[]{"-D", this.getRefSeqSerializedFile().getAbsolutePath(), "-V", sourceVCF.getAbsolutePath(), "-O", destDir.getAbsolutePath()});
        LOG.info((Object)("[Jannovar] Wrote annotated VCF file to \"" + sourceVCF.getParent() + "/" + outFile.getAbsolutePath() + "\""));
        return outFile;
    }

    static {
        LOG = LogFactory.getLog(Jannovar.class);
        sManager = new SerializationManager();
        transcriptModelList = null;
    }
}

