/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.variants;

import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerJob;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.util.CustomTables;
import org.ut.biolab.medsavant.server.db.variants.TSVFile;
import org.ut.biolab.medsavant.server.db.variants.VariantAnnotator;
import org.ut.biolab.medsavant.server.serverapi.LogManager;
import org.ut.biolab.medsavant.server.serverapi.VariantManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.format.CustomField;
import org.ut.biolab.medsavant.shared.model.Annotation;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.serverapi.LogManagerAdapter;
import org.ut.biolab.medsavant.shared.util.MiscUtils;
import org.ut.biolab.medsavant.shared.vcf.VariantRecord;

public class VariantManagerUtils {
    private static final Log LOG = LogFactory.getLog(VariantManagerUtils.class);
    private static final int OUTPUT_LINES_LIMIT = 1000000;
    private static final int MIN_SUBSET_SIZE = 1000000;
    public static final String FIELD_DELIMITER = "\t";
    public static final String ENCLOSED_BY = "\"";
    public static final String ESCAPE_CHAR = "\\";
    private static final String varchar = DbColumn.getTypeName(12);
    static int MAX_FILES = 20;

    public static void appendToFile(String baseFilename, String appendingFilename) throws IOException {
        String line;
        BufferedWriter writer = new BufferedWriter(new FileWriter(baseFilename, true));
        BufferedReader reader = new BufferedReader(new FileReader(appendingFilename));
        while ((line = reader.readLine()) != null) {
            writer.write(line);
            writer.write("\r\n");
        }
        writer.close();
        reader.close();
    }

    private static boolean isVarchar(String typeNameSQL) {
        return typeNameSQL.equals(varchar);
    }

    private static File cleanVariantFile(File inputFile, String tableName, String sessionId) throws SQLException, RemoteException, IOException, SessionExpiredException {
        String line;
        LOG.info((Object)("Cleaning file " + inputFile.getAbsolutePath() + " for table " + tableName));
        TableSchema table = CustomTables.getInstance().getCustomTableSchema(sessionId, tableName);
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        File outputFile = new File(inputFile.getCanonicalPath() + "_clean");
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
        int expectedColumnCount = table.getColumns().size();
        long row = 0L;
        int[] expectedColumnLengths = new int[table.getColumns().size()];
        LOG.info((Object)("Cleaning " + expectedColumnCount + " fields..."));
        for (int i = 0; i < expectedColumnCount; ++i) {
            expectedColumnLengths[i] = VariantManagerUtils.isVarchar(table.getColumns().get(i).getTypeNameSQL()) ? table.getColumns().get(i).getTypeLength() : Integer.MAX_VALUE;
        }
        int announceEvery = 100000;
        LOG.info((Object)("Cleaning " + inputFile.getAbsolutePath()));
        int maxWarningsToLog = 30;
        int warnings = 0;
        while ((line = br.readLine()) != null) {
            Object[] values;
            if (++row % (long)announceEvery == 0L) {
                LOG.info((Object)("Cleaned " + row + " lines of " + inputFile.getAbsolutePath()));
            }
            if ((values = line.split(FIELD_DELIMITER, -1)).length != expectedColumnCount) {
                if (warnings < maxWarningsToLog) {
                    LOG.warn((Object)("Unexpected number of columns: expected [" + expectedColumnCount + "] found [" + values.length + "] at line [" + row + "] in file [" + inputFile.getAbsolutePath() + "]"));
                } else if (warnings == maxWarningsToLog) {
                    LOG.warn((Object)(maxWarningsToLog + "+ warnings"));
                }
                ++warnings;
                continue;
            }
            for (int i = 0; i < expectedColumnCount; ++i) {
                int lengthOfField = values[i].length() - 2;
                if (lengthOfField < expectedColumnLengths[i]) continue;
                LOG.warn((Object)("Value too long: [" + (String)values[i] + "]; trimmed to [" + expectedColumnLengths[i] + "] characters"));
                String unenclosed = ((String)values[i]).replace(ENCLOSED_BY, "");
                values[i] = ENCLOSED_BY + unenclosed.substring(0, expectedColumnLengths[i]) + ENCLOSED_BY;
            }
            bw.append(StringUtils.join((Object[])values, (String)FIELD_DELIMITER));
            bw.append("\n");
        }
        LOG.info((Object)("Done cleaning " + inputFile.getAbsolutePath() + " output to " + outputFile.getAbsolutePath()));
        LOG.warn((Object)(warnings + " warnings while cleaning"));
        bw.close();
        br.close();
        if (inputFile.exists()) {
            inputFile.delete();
        }
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int uploadTSVFileToVariantTable(String sid, File file, String tableName) throws SQLException, IOException, SessionExpiredException {
        file = VariantManagerUtils.cleanVariantFile(file, tableName, sid);
        BufferedReader br = new BufferedReader(new FileReader(file));
        PooledConnection c = null;
        int lineNumber = 0;
        try {
            Statement s;
            String query;
            String line;
            c = ConnectionController.connectPooled(sid);
            c.setAutoCommit(false);
            int chunkSize = 100000;
            String parentDirectory = file.getParentFile().getAbsolutePath();
            BufferedWriter bw = null;
            String subsetFileName = parentDirectory + "/" + MiscUtils.extractFileName(file.getAbsolutePath()) + "_subset";
            String currentOutputPath = null;
            boolean stateOpen = false;
            while ((line = br.readLine()) != null) {
                if (++lineNumber % chunkSize == 1) {
                    currentOutputPath = parentDirectory + "/" + MiscUtils.extractFileName(file.getAbsolutePath()) + "_" + lineNumber / chunkSize;
                    LOG.info((Object)("Opening new partial file " + currentOutputPath));
                    bw = new BufferedWriter(new FileWriter(currentOutputPath));
                    stateOpen = true;
                }
                bw.write(line + "\r\n");
                if (lineNumber % chunkSize != 0) continue;
                bw.close();
                LOG.info((Object)("Closing and uploading final partial file " + currentOutputPath));
                query = "LOAD DATA LOCAL INFILE '" + currentOutputPath.replaceAll("\\\\", "/") + "' " + "INTO TABLE " + tableName + " " + "FIELDS TERMINATED BY '" + FIELD_DELIMITER + "' ENCLOSED BY '" + ENCLOSED_BY + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)ESCAPE_CHAR) + "' " + " LINES TERMINATED BY '\\r\\n'" + ";";
                s = null;
                try {
                    s = c.createStatement();
                    s.setQueryTimeout(1800);
                    s.execute(query);
                }
                finally {
                    s.close();
                }
                stateOpen = false;
                new File(currentOutputPath).delete();
            }
            if (bw != null && stateOpen) {
                bw.close();
                query = "LOAD DATA LOCAL INFILE '" + currentOutputPath.replaceAll("\\\\", "/") + "' " + "INTO TABLE " + tableName + " " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)FIELD_DELIMITER) + "' ENCLOSED BY '" + ENCLOSED_BY + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)ESCAPE_CHAR) + "'" + " LINES TERMINATED BY '\\r\\n'" + ";";
                LOG.info((Object)("Closing and uploading last partial file " + currentOutputPath));
                LOG.info((Object)query);
                s = null;
                try {
                    s = c.createStatement();
                    s.setQueryTimeout(3600);
                    s.execute(query);
                }
                finally {
                    s.close();
                }
                new File(currentOutputPath).delete();
            }
            LOG.info((Object)("Imported " + lineNumber + " lines of variants in total"));
            c.commit();
            c.setAutoCommit(true);
        }
        finally {
            c.close();
        }
        return lineNumber;
    }

    @Deprecated
    public static int uploadTSVFileToVariantTableOld(String sid, File file, String tableName) throws SQLException, IOException, SessionExpiredException {
        Statement s;
        String query;
        String line;
        file = VariantManagerUtils.cleanVariantFile(file, tableName, sid);
        BufferedReader br = new BufferedReader(new FileReader(file));
        PooledConnection c = ConnectionController.connectPooled(sid);
        c.setAutoCommit(false);
        int chunkSize = 100000;
        int lineNumber = 0;
        BufferedWriter bw = null;
        String currentOutputPath = null;
        boolean stateOpen = false;
        String parentDirectory = file.getParentFile().getAbsolutePath();
        while ((line = br.readLine()) != null) {
            if (++lineNumber % chunkSize == 1) {
                currentOutputPath = parentDirectory + "/" + MiscUtils.extractFileName(file.getAbsolutePath()) + "_" + lineNumber / chunkSize;
                LOG.info((Object)("Opening new partial file " + currentOutputPath));
                bw = new BufferedWriter(new FileWriter(currentOutputPath));
                stateOpen = true;
            }
            bw.write(line + "\r\n");
            if (lineNumber % chunkSize != 0) continue;
            bw.close();
            LOG.info((Object)("Closing and uploading partial file " + currentOutputPath));
            query = "LOAD DATA LOCAL INFILE '" + currentOutputPath.replaceAll("\\\\", "/") + "' " + "INTO TABLE " + tableName + " " + "FIELDS TERMINATED BY '" + FIELD_DELIMITER + "' ENCLOSED BY '" + ENCLOSED_BY + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)ESCAPE_CHAR) + "' " + " LINES TERMINATED BY '\\r\\n'" + ";";
            s = c.createStatement();
            s.setQueryTimeout(1800);
            s.execute(query);
            stateOpen = false;
        }
        if (bw != null && stateOpen) {
            bw.close();
            query = "LOAD DATA LOCAL INFILE '" + currentOutputPath.replaceAll("\\\\", "/") + "' " + "INTO TABLE " + tableName + " " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)FIELD_DELIMITER) + "' ENCLOSED BY '" + ENCLOSED_BY + "' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)ESCAPE_CHAR) + "'" + " LINES TERMINATED BY '\\r\\n'" + ";";
            LOG.info((Object)("Closing and uploading last partial file " + currentOutputPath));
            LOG.info((Object)query);
            s = c.createStatement();
            s.setQueryTimeout(3600);
            s.execute(query);
        }
        LOG.info((Object)("Imported " + lineNumber + " lines of variants in total"));
        c.commit();
        c.setAutoCommit(true);
        c.close();
        return lineNumber;
    }

    public static void variantTableToTSVFile(String sid, String tableName, File file) throws SQLException, SessionExpiredException {
        VariantManagerUtils.variantTableToTSVFile(sid, tableName, file, null);
    }

    public static void variantTableToTSVFile(String sid, String tableName, File file, String conditions) throws SQLException, SessionExpiredException {
        String query = "SELECT `upload_id`, `file_id`, `variant_id`, `dna_id`, `chrom`, `position`, `end`, `dbsnp_id`, `ref`, `alt`, `alt_number`, `qual`, `filter`, `variant_type`, `zygosity`, `gt`, `custom_info`";
        query = query + " INTO OUTFILE \"" + file.getAbsolutePath().replaceAll("\\\\", "/") + "\" " + "FIELDS TERMINATED BY '" + StringEscapeUtils.escapeJava((String)FIELD_DELIMITER) + "' ENCLOSED BY '\"' " + "ESCAPED BY '" + StringEscapeUtils.escapeJava((String)ESCAPE_CHAR) + "' " + "FROM " + tableName;
        if (conditions != null && conditions.length() > 1) {
            query = query + " WHERE " + conditions;
        }
        LOG.info((Object)query);
        ConnectionController.executeQuery(sid, query);
    }

    public static void removeTemp(String filename) {
        VariantManagerUtils.removeTemp(new File(filename));
    }

    public static void removeTemp(File temp) {
        if (!temp.delete()) {
            temp.deleteOnExit();
        }
    }

    public static void dropViewIfExists(String sessID, String tableName) throws SQLException, SessionExpiredException {
        ConnectionController.executeUpdate(sessID, "DROP VIEW IF EXISTS " + tableName);
    }

    public static void dropTableIfExists(String sessID, String tableName) throws SQLException, SessionExpiredException {
        ConnectionController.executeUpdate(sessID, "DROP TABLE IF EXISTS " + tableName);
    }

    static File[] splitFileOnColumns(File splitDir, String inputFile, int[] cols) throws FileNotFoundException, IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        HashMap<String, BufferedWriter> outputFileMap = new HashMap<String, BufferedWriter>();
        boolean conservingFilePointers = false;
        int filesOpened = 0;
        HashSet<String> filePaths = new HashSet<String>();
        int lines = 0;
        while ((line = br.readLine()) != null) {
            ++lines;
            String[] parsedLine = line.split(FIELD_DELIMITER);
            String id = "";
            for (int i : cols) {
                id = id + parsedLine[i] + "-";
            }
            if (!outputFileMap.containsKey(id)) {
                File f = new File(splitDir, (id + "part").replace(ENCLOSED_BY, ""));
                outputFileMap.put(id, new BufferedWriter(new FileWriter(f, true)));
                String path = f.getAbsolutePath();
                ++filesOpened;
                if (!filePaths.contains(path)) {
                    filePaths.add(path);
                }
            }
            BufferedWriter out = (BufferedWriter)outputFileMap.get(id);
            out.write(line + "\n");
            if (outputFileMap.keySet().size() < MAX_FILES) continue;
            if (!conservingFilePointers) {
                LOG.info((Object)("Conserving file pointers, " + outputFileMap.keySet().size() + " opened"));
            }
            conservingFilePointers = true;
            out.close();
            outputFileMap.remove(id);
        }
        LOG.info((Object)"Closing split files...");
        for (BufferedWriter bw : outputFileMap.values()) {
            bw.close();
        }
        LOG.info((Object)("Split " + lines + " lines into " + filePaths.size() + " files, in " + splitDir.getAbsolutePath()));
        File[] fileArray = new File[filePaths.size()];
        int counter = 0;
        for (String path : filePaths) {
            File f = new File(path);
            fileArray[counter++] = f;
        }
        return fileArray;
    }

    public static void splitFileOnColumn(File splitDir, String outputFilename, int i) throws FileNotFoundException, IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(outputFilename));
        HashMap<String, BufferedWriter> outputFileMap = new HashMap<String, BufferedWriter>();
        while ((line = br.readLine()) != null) {
            String[] parsedLine = line.split(FIELD_DELIMITER);
            String fileId = parsedLine[i];
            if (!outputFileMap.containsKey(fileId)) {
                outputFileMap.put(fileId, new BufferedWriter(new FileWriter(new File(splitDir, fileId))));
            }
            BufferedWriter out = (BufferedWriter)outputFileMap.get(fileId);
            out.write(line + "\n");
        }
        for (BufferedWriter bw : outputFileMap.values()) {
            bw.flush();
            bw.close();
        }
    }

    public static void concatenateFilesInDir(File fromDir, String outputPath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputPath));
        for (File inFile : fromDir.listFiles()) {
            String line;
            if (inFile.getName().startsWith(".")) continue;
            LOG.info((Object)("Merging " + inFile.getAbsolutePath() + " with to the result file " + new File(outputPath).getAbsolutePath()));
            BufferedReader br = new BufferedReader(new FileReader(inFile));
            while ((line = br.readLine()) != null) {
                bw.write(line + "\n");
            }
        }
        bw.flush();
        bw.close();
    }

    public static void sortFileByPosition(String inFile, String outfile) throws IOException, InterruptedException {
        String s;
        String sortCommand = "sort -k 5,5 -k 6,6n -k 7 " + new File(inFile).getAbsolutePath();
        LOG.info((Object)("Sorting file: " + new File(inFile).getAbsolutePath() + " to " + outfile));
        if (!new File(inFile).exists()) {
            throw new IOException("File not found " + new File(inFile).getAbsolutePath());
        }
        Process p = Runtime.getRuntime().exec(sortCommand);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedWriter bw = new BufferedWriter(new FileWriter(outfile));
        while ((s = stdInput.readLine()) != null) {
            bw.write(s + "\n");
        }
        stdInput.close();
        bw.close();
        if (!new File(outfile).exists()) {
            throw new IOException("Problem sorting file; no output");
        }
        LOG.info((Object)"Done sorting");
    }

    public static void logFileSize(String fn) {
    }

    public static void addCustomVCFFields(String infile, String outfile, CustomField[] customFields, int customInfoIndex) throws FileNotFoundException, IOException {
        String line;
        String[] infoFields = new String[customFields.length];
        Class[] infoClasses = new Class[customFields.length];
        for (int i = 0; i < customFields.length; ++i) {
            infoFields[i] = customFields[i].getColumnName();
            infoClasses[i] = customFields[i].getColumnClass();
        }
        BufferedReader reader = new BufferedReader(new FileReader(infile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outfile));
        while ((line = reader.readLine()) != null) {
            String[] split = line.split(FIELD_DELIMITER);
            String info = split[customInfoIndex].substring(1, split[customInfoIndex].length() - 1);
            writer.write(line + FIELD_DELIMITER + VariantRecord.createTabString(VariantRecord.parseInfo(info, infoFields, infoClasses)) + "\n");
        }
        reader.close();
        writer.close();
    }

    public static void addTagsToUpload(String sid, int uploadID, String[][] variantTags) throws SQLException, RemoteException, SessionExpiredException {
        try {
            VariantManager.getInstance().addTagsToUpload(sid, uploadID, variantTags);
        }
        catch (SQLException e) {
            throw new SQLException("Error adding tags", e);
        }
    }

    public static void generateSubset(File inFile, File outFile) throws IOException, InterruptedException {
        String line;
        int step;
        System.out.println("generate subset");
        long length = inFile.length();
        if (length <= 1000000L) {
            step = 1;
        } else {
            long targetSize = Math.max(1000000L, length / 1000L);
            step = (int)Math.ceil((double)length / (double)targetSize);
        }
        System.out.println("length: " + length + "  step: " + step);
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        int i = 1;
        while ((line = in.readLine()) != null) {
            if (i >= step) {
                out.write(line + "\n");
                i = 1;
                continue;
            }
            ++i;
        }
        in.close();
        out.close();
    }

    public static TSVFile[] annotateTSVFiles(String sessID, File[] tsvFiles, Annotation[] annotations, CustomField[] customFields, MedSavantServerJob parentJob) throws Exception {
        LOG.info((Object)("Annotating " + tsvFiles.length + " TSV files"));
        try {
            LogManager.getInstance().addServerLog(sessID, LogManagerAdapter.LogType.INFO, "Annotating " + tsvFiles.length + " TSV files");
        }
        catch (RemoteException ex) {
        }
        catch (SessionExpiredException ex) {
            // empty catch block
        }
        ArrayList<MedSavantServerJob> annotationThreads = new ArrayList<MedSavantServerJob>(tsvFiles.length);
        for (int i = 0; i < tsvFiles.length; ++i) {
            File toAnnotate = tsvFiles[i];
            String outFile = toAnnotate + "_annotated";
            annotationThreads.add(new VariantAnnotator(sessID, parentJob, toAnnotate, new File(outFile), annotations, customFields));
        }
        MedSavantServerEngine.submitLongJobsAndWait(annotationThreads);
        TSVFile[] annotatedTsvFiles = new TSVFile[annotationThreads.size()];
        int i = 0;
        for (MedSavantServerJob msj : annotationThreads) {
            VariantAnnotator t = (VariantAnnotator)msj;
            File f = new File(t.getOutputFilePath());
            annotatedTsvFiles[i++] = new TSVFile(f, t.getNumVariantsWritten());
            if (!t.didSucceed()) {
                LOG.info((Object)"At least one annotation thread errored out");
                LOG.info((Object)("Failed annotating file " + f.getAbsolutePath()));
                throw t.getException();
            }
            LOG.info((Object)("Annotated file " + f.getAbsolutePath()));
        }
        return annotatedTsvFiles;
    }

    static File[] splitTSVFileByFileAndDNAID(File basedir, File tsvFile) throws FileNotFoundException, IOException {
        File splitDir = new File(basedir, "split-by-id");
        splitDir.mkdir();
        LOG.info((Object)("Splitting " + tsvFile + " by DNA and FileIDs"));
        return VariantManagerUtils.splitFileOnColumns(splitDir, tsvFile.getAbsolutePath(), new int[]{0, 1, 3});
    }
}

