/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.phasing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import main.Main;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.IOUtils;

public class BEAGLEWrapper {
    private static final Log LOG = LogFactory.getLog(BEAGLEWrapper.class);
    private static final int FORMAT_COLUMN_INDEX = 8;
    private static final int SAMPLE_COLUMN_INDEX = 9;
    private static final String GT = "GT";
    private static Random r = new Random();
    private File inputVCF;
    private File tempDirectory;
    private String tempFileNamePrefix;
    private List<String> beagleArgs = new LinkedList<String>();
    private Map<String, List<String>> phasedVariants;
    private File mergedVCF;
    private static File refPanel = null;
    private static final String BEAGLE_COMPRESSED_REFERENCE = "CPIC_30k_pgx_phasing_windows_CHR_PREFIX.vcf.bz2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void initBeagleReference(File destDir) throws IOException {
        block8: {
            System.out.println("Initializing Phasing reference...");
            LOG.info((Object)"Initializing Phasing reference...");
            File tmpDir = null;
            File compressedReference = null;
            try {
                int i = 0;
                while ((tmpDir = new File(DirectorySettings.getTmpDirectory(), "beagle" + i++)).exists()) {
                }
                tmpDir.mkdirs();
                compressedReference = new File(tmpDir, BEAGLE_COMPRESSED_REFERENCE);
                InputStream compressedRefStream = BEAGLEWrapper.class.getResourceAsStream("/BEAGLEWrapper/CPIC_30k_pgx_phasing_windows_CHR_PREFIX.vcf.bz2");
                IOUtils.copyStream(compressedRefStream, new FileOutputStream(compressedReference));
                List<File> fileList = IOUtils.decompressAndDelete(compressedReference, destDir);
                if (fileList.size() > 1) {
                    LOG.info((Object)"WARNING: Unexpected number of files in beagle reference -- expected a single VCF");
                } else if (fileList.size() < 1) {
                    throw new IOException("Couldn't locate phasing reference within compressed phasing file.");
                }
                String extractedFileName = fileList.get(0).getCanonicalPath();
                if (!refPanel.getCanonicalPath().equals(extractedFileName)) {
                    refPanel.delete();
                    throw new IOException("Unexpected filename for phasing reference: " + extractedFileName);
                }
                if (tmpDir == null) break block8;
            }
            catch (Throwable throwable) {
                if (tmpDir != null) {
                    IOUtils.deleteDirectory(tmpDir);
                }
                throw throwable;
            }
            IOUtils.deleteDirectory(tmpDir);
        }
        System.out.println("Phasing reference initialized.");
        LOG.info((Object)"Phasing reference initialized.");
    }

    public static synchronized void install(File directory) throws IOException {
        File destDir = new File(DirectorySettings.getMedSavantDirectory(), "beagle");
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Couldn't create destination directory for phasing reference");
        }
        refPanel = new File(destDir, StringUtils.substringBeforeLast((String)BEAGLE_COMPRESSED_REFERENCE, (String)".bz2"));
        if (!refPanel.exists()) {
            LOG.info((Object)("Phasing reference doesn't exist, extracting to " + destDir.getAbsolutePath()));
            BEAGLEWrapper.initBeagleReference(destDir);
        }
    }

    public BEAGLEWrapper(File tempDirectory, File inputVCF, int numThreads) {
        this.inputVCF = inputVCF;
        this.tempDirectory = tempDirectory;
        this.tempFileNamePrefix = this.getPathToTempFile(tempDirectory);
        this.beagleArgs.add("gt=" + inputVCF.getAbsolutePath());
        this.beagleArgs.add("ref=" + refPanel.getAbsolutePath());
        this.beagleArgs.add("out=" + this.tempFileNamePrefix);
        this.beagleArgs.add("impute=false");
        this.beagleArgs.add("nthreads=" + numThreads);
    }

    public File run() throws FileNotFoundException, IOException {
        Main.main((String[])this.beagleArgs.toArray(new String[0]));
        this.mergedVCF = this.mergePhased();
        return this.mergedVCF;
    }

    public BEAGLEWrapper(File tempDirectory, File inputVCF) {
        this(tempDirectory, inputVCF, 1);
    }

    private String getPathToTempFile(File tempDirectoryPath) {
        File tempFile = null;
        while ((tempFile = new File(tempDirectoryPath, "beagle_phasing_temp_" + r.nextInt())).exists()) {
        }
        return tempFile.getAbsolutePath();
    }

    private File mergePhased() throws FileNotFoundException, IOException {
        File outputVCF = new File(this.tempDirectory, this.inputVCF.getName().substring(this.inputVCF.getName().lastIndexOf(File.separator) + 1, this.inputVCF.getName().lastIndexOf(".")) + "_partially_phased.vcf");
        this.storePhasedVariants();
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputVCF));
        BufferedReader br = new BufferedReader(new FileReader(this.inputVCF));
        String line = br.readLine();
        while (line != null) {
            if ((line = StringUtils.chomp((String)line)).substring(0, 1).equals("#")) {
                bw.write(line);
            } else {
                List<String> currentVariants = Arrays.asList(line.split("\\t"));
                LinkedList<String> keyList = new LinkedList<String>();
                keyList.addAll(currentVariants.subList(0, 2));
                keyList.addAll(currentVariants.subList(3, 5));
                String key = StringUtils.join(keyList, (String)" ");
                if (this.phasedVariants.containsKey(key)) {
                    List<String> phasedVariantsLine = this.phasedVariants.get(key);
                    List<String> phasedFormatColumn = Arrays.asList(phasedVariantsLine.get(8).split(":"));
                    List<List<String>> phasedSampleColumns = this.getSampleColumns(phasedVariantsLine);
                    int phasedGTIndex = phasedFormatColumn.indexOf(GT);
                    List<String> unphasedFormatColumn = Arrays.asList(currentVariants.get(8).split(":"));
                    List<List<String>> unphasedSampleColumns = this.getSampleColumns(currentVariants);
                    int unphasedGTIndex = unphasedFormatColumn.indexOf(GT);
                    for (int i = 0; i != phasedSampleColumns.size(); ++i) {
                        List<String> phasedSampleColumn = phasedSampleColumns.get(i);
                        List<String> unphasedSampleColumn = unphasedSampleColumns.get(i);
                        String phasedGTValue = phasedSampleColumn.get(phasedGTIndex);
                        if (unphasedGTIndex > -1) {
                            unphasedSampleColumn.set(unphasedGTIndex, phasedGTValue);
                        } else {
                            if (unphasedGTIndex == -1) {
                                unphasedGTIndex = -2;
                                unphasedFormatColumn.add(GT);
                            }
                            unphasedSampleColumn.add(phasedGTValue);
                        }
                        currentVariants.set(9 + i, StringUtils.join(unphasedSampleColumn, (String)":"));
                    }
                    currentVariants.set(8, StringUtils.join(unphasedFormatColumn, (String)":"));
                    String outputLine = StringUtils.join(currentVariants, (String)"\t");
                    bw.write(outputLine);
                } else {
                    List<String> unphasedFormatColumn = Arrays.asList(currentVariants.get(8).split(":"));
                    List<List<String>> unphasedSampleColumns = this.getSampleColumns(currentVariants);
                    int unphasedGTIndex = unphasedFormatColumn.indexOf(GT);
                    for (int i = 0; i != unphasedSampleColumns.size(); ++i) {
                        List<String> unphasedSampleColumn = unphasedSampleColumns.get(i);
                        if (unphasedGTIndex != -1) {
                            String inputGTValue = unphasedSampleColumn.get(unphasedGTIndex);
                            inputGTValue = inputGTValue.replace("|", "/");
                            unphasedSampleColumn.set(unphasedGTIndex, inputGTValue);
                        }
                        currentVariants.set(9 + i, StringUtils.join(unphasedSampleColumn, (String)":"));
                    }
                    String outputLine = StringUtils.join(currentVariants, (String)"\t");
                    bw.write(outputLine);
                }
            }
            bw.write("\n");
            line = br.readLine();
        }
        br.close();
        bw.close();
        return outputVCF;
    }

    private void storePhasedVariants() throws FileNotFoundException, IOException {
        this.phasedVariants = new HashMap<String, List<String>>();
        GZIPInputStream gzippedInputStream = new GZIPInputStream(new FileInputStream(this.tempFileNamePrefix + ".vcf.gz"));
        BufferedReader br = new BufferedReader(new InputStreamReader(gzippedInputStream));
        String line = br.readLine();
        while (line != null) {
            if (!line.substring(0, 1).equals("#")) {
                line = StringUtils.chomp((String)line);
                List<String> currentVariants = Arrays.asList(line.split("\\t"));
                LinkedList<String> keyList = new LinkedList<String>();
                keyList.addAll(currentVariants.subList(0, 2));
                keyList.addAll(currentVariants.subList(3, 5));
                String key = StringUtils.join(keyList, (String)" ");
                this.phasedVariants.put(key, currentVariants);
            }
            line = br.readLine();
        }
        br.close();
    }

    private List<List<String>> getSampleColumns(List<String> currentVariants) {
        LinkedList<List<String>> output = new LinkedList<List<String>>();
        List<String> sampleInfoColumns = currentVariants.subList(9, currentVariants.size());
        for (String column : sampleInfoColumns) {
            output.add(Arrays.asList(column.split(":")));
        }
        return output;
    }

    public File getMergedVCF() {
        return this.mergedVCF;
    }
}

