/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.serverapi;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.DeleteQuery;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.LockController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.server.serverapi.UserManager;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.exception.LockException;
import org.ut.biolab.medsavant.shared.model.exception.UnauthorizedException;
import org.ut.biolab.medsavant.shared.serverapi.SettingsManagerAdapter;
import org.ut.biolab.medsavant.shared.util.BinaryConditionMS;
import org.ut.biolab.medsavant.shared.util.VersionSettings;

public class SettingsManager
extends MedSavantServerUnicastRemoteObject
implements SettingsManagerAdapter {
    private static final Log LOG = LogFactory.getLog(SettingsManager.class);
    private static SettingsManager instance;
    private boolean lockReleased = false;

    private SettingsManager() throws RemoteException, SessionExpiredException {
    }

    public static synchronized SettingsManager getInstance() throws RemoteException, SessionExpiredException {
        if (instance == null) {
            instance = new SettingsManager();
        }
        return instance;
    }

    @Override
    public void removeSetting(String sid, String key) throws SQLException, SessionExpiredException {
        MedSavantDatabase.SettingsTableSchema table = MedSavantDatabase.SettingsTableSchema;
        DeleteQuery query = new DeleteQuery(table.getTable());
        query.addCondition(BinaryCondition.equalTo(table.getDBColumn("setting_key"), key));
        ConnectionController.executeUpdate(sid, query.toString());
    }

    @Override
    public void addSetting(String sid, String key, String value) throws SQLException, SessionExpiredException {
        MedSavantDatabase.SettingsTableSchema table = MedSavantDatabase.SettingsTableSchema;
        InsertQuery query = new InsertQuery(table.getTable());
        query.addColumn(table.getDBColumn("setting_key"), key);
        query.addColumn(table.getDBColumn("setting_value"), value);
        ConnectionController.executeUpdate(sid, query.toString());
    }

    Map<String, String> getSettingsForKeyPrefix(String sid, String keyPrefix) throws SQLException, SessionExpiredException {
        MedSavantDatabase.SettingsTableSchema table = MedSavantDatabase.SettingsTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("setting_key"));
        query.addColumns(table.getDBColumn("setting_value"));
        query.addCondition(BinaryConditionMS.like(table.getDBColumn("setting_key"), keyPrefix + "%"));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        HashMap<String, String> results = new HashMap<String, String>();
        while (rs.next()) {
            String user = rs.getString(1);
            user = user.replace(keyPrefix, "");
            String val = rs.getString(2);
            results.put(user, val);
        }
        return results;
    }

    @Override
    public String getSetting(String sid, String key) throws SQLException, SessionExpiredException {
        MedSavantDatabase.SettingsTableSchema table = MedSavantDatabase.SettingsTableSchema;
        SelectQuery query = new SelectQuery();
        query.addFromTable(table.getTable());
        query.addColumns(table.getDBColumn("setting_value"));
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("setting_key"), key));
        ResultSet rs = ConnectionController.executeQuery(sid, query.toString());
        if (rs.next()) {
            String result = rs.getString(1);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSetting(String sessID, String key, String value) throws SQLException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            this.updateSetting(conn, key, value);
        }
        finally {
            conn.close();
        }
    }

    private void updateSetting(Connection conn, String key, String value) throws SQLException, SessionExpiredException {
        MedSavantDatabase.SettingsTableSchema table = MedSavantDatabase.SettingsTableSchema;
        UpdateQuery query = new UpdateQuery(table.getTable());
        query.addSetClause(table.getDBColumn("setting_value"), value);
        query.addCondition(BinaryConditionMS.equalTo(table.getDBColumn("setting_key"), key));
        conn.createStatement().executeUpdate(query.toString());
    }

    @Override
    public String getServerVersion() throws RemoteException, SessionExpiredException {
        return VersionSettings.getVersionString();
    }

    public String getServerVersionWhenDatabaseCreated(String sessID) throws SQLException, SessionExpiredException {
        return this.getSetting(sessID, "server version");
    }

    @Override
    public boolean isProjectLockedForChanges(String sessionID, int projectID) throws RemoteException, SessionExpiredException {
        return LockController.getInstance().isLocked(SessionManager.getInstance().getDatabaseForSession(sessionID), projectID);
    }

    @Override
    public void forceReleaseLockForProject(String sessionID, int projectID) throws LockException, RemoteException, SessionExpiredException, UnauthorizedException, SQLException {
        if (UserManager.getInstance().isAdmin(sessionID, true)) {
            LockController.getInstance().releaseLock(SessionManager.getInstance().getDatabaseForSession(sessionID), projectID, true);
        }
    }
}

