/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.vcf;

import java.util.ArrayList;
import java.util.List;

public class VCFHeader {
    private static final int NUM_MANDATORY_FIELDS = 8;
    private List<String> genotypeLabels = new ArrayList<String>();

    public static int getNumMandatoryFields() {
        return 8;
    }

    void addGenotypeLabel(String label) {
        this.genotypeLabels.add(label);
    }

    public String getGenotypeLabelForIndex(int index) {
        if (!this.containsGenotypeInformation()) {
            return null;
        }
        int adjustedIndex = index - VCFHeader.getNumMandatoryFields() + 1;
        if (adjustedIndex < 0 || adjustedIndex >= this.genotypeLabels.size()) {
            return null;
        }
        return this.genotypeLabels.get(adjustedIndex);
    }

    public List<String> getGenotypeLabels() {
        return this.genotypeLabels;
    }

    public String toString() {
        String s = "";
        for (String l : this.genotypeLabels) {
            s = s + "label:" + l + "|";
        }
        return "VCFHeader{genotypeLabels=" + s + '}';
    }

    public boolean containsGenotypeInformation() {
        return !this.genotypeLabels.isEmpty();
    }
}

