/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.common.util.Appendee;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.Expression;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class InCondition
extends Condition {
    private boolean _negate;
    private SqlObject _leftValue;
    private SqlObjectList<SqlObject> _rightValues = SqlObjectList.create();

    public InCondition(Object leftObj, Object ... rightObjs) {
        this(leftObj, rightObjs != null ? Arrays.asList(rightObjs) : Collections.emptyList());
    }

    public InCondition(Object leftObj, Collection<?> rightObjs) {
        this._leftValue = Converter.toColumnSqlObject(leftObj);
        this._rightValues.addObjects(Converter.COLUMN_VALUE_TO_OBJ, rightObjs);
    }

    public InCondition addObject(Object obj) {
        return this.addObjects(obj);
    }

    public InCondition addObjects(Object ... objs) {
        this._rightValues.addObjects(Converter.COLUMN_VALUE_TO_OBJ, objs);
        return this;
    }

    public InCondition setNegate(boolean negate) {
        this._negate = negate;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this._negate && this._rightValues.isEmpty();
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        this._leftValue.collectSchemaObjects(vContext);
        this._rightValues.collectSchemaObjects(vContext);
    }

    private boolean isSingleExpression() {
        SqlObject singleValue = this._rightValues.size() == 1 ? this._rightValues.get(0) : null;
        return singleValue instanceof Expression && ((Expression)singleValue).hasParens();
    }

    @Override
    protected void closeParen(AppendableExt app) throws IOException {
        if (!this.isDisableParens()) {
            app.append((CharSequence)" )");
        }
    }

    public void appendTo(AppendableExt app) throws IOException {
        if (!this.isEmpty()) {
            this.openParen(app);
            app.append((Appendee)this._leftValue).append((CharSequence)(this._negate ? " NOT IN " : " IN "));
            if (this.isSingleExpression()) {
                app.append(this._rightValues);
            } else {
                app.append((CharSequence)"(").append(this._rightValues).append((CharSequence)")");
            }
            this.closeParen(app);
        }
    }
}

