/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class SqlObjectList<ObjType extends SqlObject>
extends SqlObject
implements Iterable<ObjType> {
    public static final String DEFAULT_DELIMITER = ",";
    private final String _delimiter;
    private final List<ObjType> _objects;

    public SqlObjectList() {
        this(DEFAULT_DELIMITER, new LinkedList());
    }

    public SqlObjectList(String delimiter) {
        this(delimiter, new LinkedList());
    }

    public SqlObjectList(String delimiter, List<ObjType> objects) {
        this._delimiter = delimiter;
        this._objects = objects;
    }

    public static <ObjType extends SqlObject> SqlObjectList<ObjType> create() {
        return new SqlObjectList<ObjType>();
    }

    public static <ObjType extends SqlObject> SqlObjectList<ObjType> create(String delimiter) {
        return new SqlObjectList<ObjType>(delimiter);
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public int size() {
        return this._objects.size();
    }

    public boolean isEmpty() {
        return this._objects.isEmpty();
    }

    public void clear() {
        this._objects.clear();
    }

    public ObjType get(int index) {
        return (ObjType)((SqlObject)this._objects.get(index));
    }

    @Override
    public Iterator<ObjType> iterator() {
        return this._objects.iterator();
    }

    public ListIterator<ObjType> listIterator() {
        return this._objects.listIterator();
    }

    public SqlObjectList<ObjType> addObject(ObjType obj) {
        this._objects.add(obj);
        return this;
    }

    public SqlObjectList<ObjType> addObjects(ObjType ... objs) {
        if (objs == null) {
            return this;
        }
        for (ObjType obj : objs) {
            this._objects.add(obj);
        }
        return this;
    }

    public SqlObjectList<ObjType> addObjects(Iterable<? extends ObjType> objs) {
        if (objs == null) {
            return this;
        }
        for (SqlObject obj : objs) {
            this._objects.add(obj);
        }
        return this;
    }

    public <SrcType, DstType extends ObjType> SqlObjectList<ObjType> addObjects(Converter<SrcType, DstType> converter, SrcType ... objs) {
        if (objs == null) {
            return this;
        }
        for (SrcType obj : objs) {
            this._objects.add(converter.convert(obj));
        }
        return this;
    }

    public <SrcType, DstType extends ObjType> SqlObjectList<ObjType> addObjects(Converter<SrcType, DstType> converter, Iterable<? extends SrcType> objs) {
        if (objs == null) {
            return this;
        }
        for (SrcType obj : objs) {
            this._objects.add(converter.convert(obj));
        }
        return this;
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        for (SqlObject obj : this._objects) {
            obj.collectSchemaObjects(vContext);
        }
    }

    public void appendTo(AppendableExt app) throws IOException {
        app.append((Iterable)this, (Object)this._delimiter);
    }
}

