/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.File;
import java.io.FileFilter;

public class ExtensionFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final String extension;

    public static ExtensionFileFilter[] createFilters(String[] extensions) {
        ExtensionFileFilter[] filters = new ExtensionFileFilter[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            filters[i] = new ExtensionFileFilter(extensions[i]);
        }
        return filters;
    }

    public ExtensionFileFilter(String ext) {
        this.extension = ext;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        return f.getAbsolutePath().toLowerCase().endsWith("." + this.extension);
    }

    @Override
    public String getDescription() {
        if (this.extension.equals("vcf")) {
            return "VCF files | " + this.getExtensionString();
        }
        if (this.extension.equals("svp")) {
            return "Savant Project Files | " + this.getExtensionString();
        }
        return "*." + this.extension;
    }

    private String getExtensionString() {
        return "." + this.extension;
    }

    public String forceExtension(String dir, String name) {
        if (this.accept(new File(dir, name))) {
            return name;
        }
        return name + "." + this.extension;
    }

    public String forceExtension(File f) {
        if (this.accept(f)) {
            return f.getAbsolutePath();
        }
        return f.getAbsolutePath() + "." + this.extension;
    }
}

