/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOUtils {
    private static final Log LOG = LogFactory.getLog(IOUtils.class);

    public static boolean isInDirectory(File inputFile, File directory) throws IOException {
        if (inputFile.isDirectory() && inputFile.getAbsolutePath().equals(directory.getAbsolutePath())) {
            return true;
        }
        for (File parent = inputFile.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.getCanonicalPath().equals(directory.getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    public static void deleteEmptyParents(File p, File stopAtDir) throws IOException {
        if (!IOUtils.isInDirectory(p, stopAtDir)) {
            return;
        }
        if (p != null && p.isDirectory() && !p.getAbsolutePath().equals(stopAtDir.getAbsolutePath()) && p.listFiles().length == 0) {
            File parent = p.getParentFile();
            p.delete();
            IOUtils.deleteEmptyParents(parent, stopAtDir);
        }
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (srcFile.equals(destFile)) {
            return;
        }
        IOUtils.copyStream(new FileInputStream(srcFile), new FileOutputStream(destFile));
    }

    public static void copyDir(File srcDir, File destDir) throws IOException {
        File[] files = srcDir.listFiles();
        if (files != null) {
            for (File f : files) {
                IOUtils.copyFile(f, new File(destDir, f.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[8192];
        long tot = 0L;
        try {
            int len;
            while ((len = input.read(buf)) > 0) {
                tot += (long)len;
                output.write(buf, 0, len);
            }
            LOG.info((Object)("Copied/extracted " + tot + " bytes"));
        }
        catch (IOException x) {
            if (!x.getMessage().equals("Unexpected compressed block length: 1")) {
                x.printStackTrace();
                throw x;
            }
        }
        finally {
            input.close();
            output.close();
        }
    }

    public static String readLine(InputStream input) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = input.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        return c >= 0 ? buf.toString() : null;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    IOUtils.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static void checkForWorldExecute(File f) throws IOException {
        if (IOUtils.hasWorldExecute(f)) {
            return;
        }
        throw new IOException(f + " did not have execute permissions.");
    }

    private static String getPermissionString(File f) throws IOException {
        Process proc = Runtime.getRuntime().exec("ls -ld " + f);
        BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String line = null;
        String result = null;
        while ((line = reader.readLine()) != null) {
            int spacePos = line.indexOf(32);
            if (spacePos <= 0) continue;
            result = line.substring(1, spacePos);
        }
        return result;
    }

    private static boolean hasWorldExecute(File f) throws IOException {
        String perm = IOUtils.getPermissionString(f);
        if (perm != null && perm.length() >= 9) {
            return perm.charAt(8) == 'x';
        }
        return false;
    }

    private static List<File> unArchive(File dest, ArchiveInputStream ais) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        ArchiveEntry archiveEntry = ais.getNextEntry();
        while (archiveEntry != null) {
            File destPath = new File(dest, archiveEntry.getName());
            if (archiveEntry.isDirectory()) {
                destPath.mkdirs();
            } else {
                destPath.createNewFile();
                byte[] btoRead = new byte[1024];
                BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destPath));
                int len = 0;
                while ((len = ais.read(btoRead)) != -1) {
                    bout.write(btoRead, 0, len);
                }
                bout.close();
                btoRead = null;
                files.add(destPath);
            }
            archiveEntry = ais.getNextEntry();
        }
        ais.close();
        return files;
    }

    public static String stripExtension(File f) {
        String filename = f.getName();
        for (int i = filename.length() - 1; i > 0; --i) {
            if (filename.charAt(i) != '.') continue;
            return filename.substring(0, i);
        }
        return null;
    }

    public static boolean moveFile(File src, File dst) {
        try {
            FileUtils.moveFile((File)src, (File)dst);
        }
        catch (FileExistsException fee) {
            LOG.error((Object)"Error while moving file", (Throwable)fee);
            return false;
        }
        catch (IOException ie) {
            LOG.error((Object)"Error while moving File", (Throwable)ie);
            return false;
        }
        return true;
    }

    public static boolean isArchive(File f) {
        String n = f.getName().toLowerCase();
        return n.endsWith(".zip") || n.endsWith(".bz2") || n.endsWith(".tgz") || n.endsWith(".gz") || n.endsWith(".tar");
    }

    public static List<File> decompressAndDelete(File f, File dest) throws IOException {
        List<File> files;
        String lcfn = f.getName().toLowerCase();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
        if (lcfn.endsWith(".gz") || lcfn.endsWith(".tgz")) {
            is = new GzipCompressorInputStream((InputStream)is, true);
        } else if (lcfn.endsWith(".bz2")) {
            is = new BZip2CompressorInputStream((InputStream)is, true);
        }
        if (lcfn.endsWith(".tgz") || lcfn.endsWith(".tar.gz") || lcfn.endsWith(".tar") || lcfn.endsWith(".tar.bz2")) {
            is = new TarArchiveInputStream((InputStream)is);
            files = IOUtils.unArchive(dest, (ArchiveInputStream)is);
        } else if (lcfn.endsWith(".zip")) {
            is = new ZipArchiveInputStream((InputStream)is);
            files = IOUtils.unArchive(dest, (ArchiveInputStream)is);
        } else {
            String filename = f.getName();
            if (!(is instanceof BufferedInputStream) && (filename = IOUtils.stripExtension(f)) == null) {
                filename = f.getName() + ".decompressed";
            }
            File outputFile = new File(dest, filename);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(outputFile));
            if (!(is instanceof BufferedInputStream)) {
                IOUtils.copyStream(is, bos);
            } else if (!IOUtils.moveFile(f, outputFile)) {
                throw new IOException("Couldn't move file " + f.getAbsolutePath() + " to " + outputFile.getAbsolutePath());
            }
            bos.close();
            files = new ArrayList<File>(1);
            files.add(outputFile);
        }
        ((InputStream)is).close();
        if (f.exists()) {
            f.delete();
        }
        return files;
    }

    public static boolean isGZipped(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        in.mark(2);
        int magic = 0;
        try {
            magic = in.read() & 0xFF | in.read() << 8 & 0xFF00;
            in.reset();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            return false;
        }
        return magic == 35615;
    }

    public static boolean isGZipped(File f) {
        int magic = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            magic = raf.read() & 0xFF | raf.read() << 8 & 0xFF00;
            raf.close();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        return magic == 35615;
    }

    public static boolean isZipped(File f) {
        try {
            RandomAccessFile raf = new RandomAccessFile(f, "r");
            long n = raf.readInt();
            raf.close();
            return n == 1347093252L;
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            return false;
        }
    }

    public static List<File> unzipFile(File file, String toPath) throws ZipException, IOException {
        int BUFFER = 2048;
        ZipFile zip = new ZipFile(file);
        Enumeration<? extends ZipEntry> zipFileEntries = zip.entries();
        ArrayList<File> files = new ArrayList<File>();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(toPath, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (!entry.isDirectory()) {
                int currentByte;
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(entry));
                byte[] data = new byte[BUFFER];
                FileOutputStream fos = new FileOutputStream(destFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
                while ((currentByte = is.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, currentByte);
                }
                dest.flush();
                dest.close();
                is.close();
            }
            if (currentEntry.toLowerCase().endsWith(".zip") && IOUtils.isZipped(destFile)) {
                files.addAll(IOUtils.unzipFile(destFile, new File(destFile.getAbsolutePath()).getParent()));
                continue;
            }
            files.add(destFile);
        }
        return files;
    }

    public static File zipDirectory(File dir, File outFile) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFile));
        IOUtils.zipRecursively(".", dir, out);
        out.close();
        return outFile;
    }

    private static void zipRecursively(String path, File dir, ZipOutputStream out) throws IOException {
        for (File f : dir.listFiles()) {
            IOUtils.writeFileToZipStream(path, f, out);
            if (!f.isDirectory()) continue;
            IOUtils.zipRecursively(path + "/" + f.getName() + "/", f, out);
        }
    }

    private static void writeFileToZipStream(String path, File f, ZipOutputStream out) throws IOException {
        if (f.isFile()) {
            int count;
            out.putNextEntry(new ZipEntry(path + "/" + f.getName()));
            FileInputStream in = new FileInputStream(f);
            byte[] b = new byte[1024];
            while ((count = in.read(b)) > 0) {
                out.write(b, 0, count);
            }
            in.close();
        } else if (f.isDirectory()) {
            out.putNextEntry(new ZipEntry(f.getName() + "/"));
        }
    }

    public static File zipFile(File file, File outputFile) throws FileNotFoundException, IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));
        IOUtils.writeFileToZipStream(".", file, out);
        out.close();
        return outputFile;
    }
}

