/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import net.sf.samtools.util.SeekableStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class SeekableFTPStream
extends SeekableStream {
    private static Log LOG = LogFactory.getLog(SeekableFTPStream.class);
    private static final int SOCKET_TIMEOUT = 10000;
    private final String source;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final String fileName;
    private long length;
    private FTPClient ftpClient = null;
    private long position = 0L;

    public SeekableFTPStream(URL url) {
        this(url, "anonymous", "");
    }

    public SeekableFTPStream(URL url, String user, String pwd) {
        if (url == null) {
            throw new IllegalArgumentException("URL may not be null");
        }
        if (!url.getProtocol().toLowerCase().equals("ftp")) {
            throw new IllegalArgumentException("Only ftp:// protocol URLs are valid.");
        }
        this.source = url.toString();
        this.username = user;
        this.password = pwd;
        this.host = url.getHost();
        int p = url.getPort();
        this.port = p != -1 ? p : url.getDefaultPort();
        this.fileName = url.getFile();
        this.length = 0L;
    }

    public long length() {
        if (this.length == 0L) {
            FTPFile[] files;
            try {
                files = this.listFiles(this.fileName);
            }
            catch (IOException e) {
                try {
                    this.disconnect();
                    files = this.listFiles(this.fileName);
                }
                catch (IOException e1) {
                    LOG.warn((Object)"Unable to reconnect getting length");
                    return 0L;
                }
            }
            for (int i = 0; i < files.length; ++i) {
                FTPFile file = files[i];
                if (file == null || !file.getName().equals(this.fileName)) continue;
                this.length = file.getSize();
                break;
            }
        }
        return this.length;
    }

    public void seek(long pos) throws IOException {
        this.position = pos;
        LOG.info((Object)("FTP: seek to " + pos));
    }

    public int read(byte[] bytes, int offset, int len) throws IOException {
        try {
            return this.readFromStream(bytes, offset, len);
        }
        catch (IOException x) {
            LOG.info((Object)("Connection closed during read.  Disconnecting and trying again at " + this.position));
            this.disconnect();
            return this.readFromStream(bytes, offset, len);
        }
    }

    private int readFromStream(byte[] bytes, int offset, int len) throws IOException {
        FTPClient client = this.getFTPClient();
        if (this.position != 0L) {
            client.setRestartOffset(this.position);
        }
        InputStream is = client.retrieveFileStream(this.fileName);
        long oldPos = this.position;
        if (is != null) {
            int n;
            int bytesRead;
            for (n = 0; n < len; n += bytesRead) {
                bytesRead = is.read(bytes, offset + n, len - n);
                if (bytesRead >= 0) continue;
                if (n != 0) break;
                return -1;
            }
            is.close();
            LOG.info((Object)String.format("FTP read %d bytes at %d: %02x %02x %02x %02x %02x %02x %02x %02x...", len, oldPos, bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4], bytes[offset + 5], bytes[offset + 6], bytes[offset + 7]));
            try {
                client.completePendingCommand();
            }
            catch (FTPConnectionClosedException suppressed) {
            }
            catch (SocketTimeoutException stx) {
                LOG.info((Object)"Timed out during read.  Disconnecting.");
                this.disconnect();
            }
            this.position += (long)n;
            return n;
        }
        String msg = String.format("Unable to retrieve input stream for file (reply code %d).", client.getReplyCode());
        LOG.error((Object)msg);
        throw new IOException(msg);
    }

    public void close() throws IOException {
        if (this.ftpClient != null) {
            try {
                this.ftpClient.completePendingCommand();
            }
            catch (IOException e) {
                LOG.trace((Object)"Suppressing IOException from completePendingCommand().");
            }
            try {
                this.ftpClient.logout();
            }
            catch (IOException e) {
                LOG.info((Object)"Suppressing IOException from logout().");
            }
            this.disconnect();
        }
    }

    public boolean eof() throws IOException {
        return this.position >= this.length();
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() not supported for SeekableFTPStreams");
    }

    public String getSource() {
        return this.source;
    }

    public FTPFile[] listFiles(String relPath) throws IOException {
        try {
            return this.getFTPClient().listFiles(relPath);
        }
        catch (FTPConnectionClosedException e) {
            this.disconnect();
            return this.getFTPClient().listFiles(relPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        if (this.ftpClient != null) {
            try {
                this.ftpClient.disconnect();
            }
            finally {
                this.ftpClient = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPClient getFTPClient() throws IOException {
        if (this.ftpClient == null) {
            FTPClient client = new FTPClient();
            try {
                client.connect(this.host, this.port);
                int reply = client.getReplyCode();
                if (!FTPReply.isPositiveCompletion((int)reply)) {
                    throw new IOException("Unable to connect to " + this.host);
                }
                if (!client.login(this.username, this.password)) {
                    throw new IOException("Unable to login to " + this.host + " as " + this.username);
                }
                client.setFileType(2);
                client.enterLocalPassiveMode();
                client.setSoTimeout(10000);
                this.ftpClient = client;
                client = null;
            }
            finally {
                if (client != null) {
                    client.disconnect();
                }
            }
        }
        return this.ftpClient;
    }
}

