/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.admin;

import java.io.IOException;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.MedSavantServerEngine;
import org.ut.biolab.medsavant.server.MedSavantServerUnicastRemoteObject;
import org.ut.biolab.medsavant.server.db.ConnectionController;
import org.ut.biolab.medsavant.server.db.MedSavantDatabase;
import org.ut.biolab.medsavant.server.db.PooledConnection;
import org.ut.biolab.medsavant.server.db.admin.TabixTableLoader;
import org.ut.biolab.medsavant.server.db.util.DBUtils;
import org.ut.biolab.medsavant.server.ontology.OntologyManager;
import org.ut.biolab.medsavant.server.serverapi.ReferenceManager;
import org.ut.biolab.medsavant.server.serverapi.SessionManager;
import org.ut.biolab.medsavant.server.serverapi.SettingsManager;
import org.ut.biolab.medsavant.server.serverapi.UserManager;
import org.ut.biolab.medsavant.shared.db.TableSchema;
import org.ut.biolab.medsavant.shared.model.Chromosome;
import org.ut.biolab.medsavant.shared.model.SessionExpiredException;
import org.ut.biolab.medsavant.shared.model.UserLevel;
import org.ut.biolab.medsavant.shared.serverapi.SetupAdapter;
import org.ut.biolab.medsavant.shared.util.VersionSettings;
import org.ut.biolab.medsavant.shared.util.WebResources;

public class SetupMedSavantDatabase
extends MedSavantServerUnicastRemoteObject
implements SetupAdapter {
    private static final Log LOG = LogFactory.getLog(SetupMedSavantDatabase.class);
    private static SetupMedSavantDatabase instance;
    private static final String BRIGHTHOUSE_ENGINE = "BRIGHTHOUSE";
    private static final String MYISAM_ENGINE = "MyISAM";

    public static synchronized SetupMedSavantDatabase getInstance() throws RemoteException {
        if (instance == null) {
            instance = new SetupMedSavantDatabase();
        }
        return instance;
    }

    private SetupMedSavantDatabase() throws RemoteException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDatabase(String dbHost, int port, String dbName, String adminName, char[] rootPassword) throws IOException, SQLException, RemoteException, SessionExpiredException, Exception {
        SessionManager sessController = SessionManager.getInstance();
        String sessID = sessController.registerNewSession(adminName, new String(rootPassword), "");
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.createStatement().execute("CREATE DATABASE " + dbName);
        }
        finally {
            conn.close();
        }
        ConnectionController.switchDatabases(sessID, dbName);
        conn = ConnectionController.connectPooled(sessID);
        UserManager userMgr = UserManager.getInstance();
        this.createTables(sessID);
        try {
            this.addRootUser(sessID, conn, rootPassword);
            SetupMedSavantDatabase.addDefaultReferenceGenomes(sessID);
            SetupMedSavantDatabase.addDBSettings(sessID, VersionSettings.getVersionString());
            userMgr.grantPrivileges(sessID, adminName, UserLevel.ADMIN);
            SetupMedSavantDatabase.populateGenes(sessID);
            for (String user : userMgr.getUserNames(sessID)) {
                if (user.equals(adminName)) continue;
                userMgr.grantPrivileges(sessID, user, userMgr.getUserLevel(sessID, user));
            }
        }
        finally {
            conn.close();
        }
        sessController.unregisterSession(sessID);
        sessID = sessController.registerNewSession(adminName, new String(rootPassword), dbName);
        OntologyManager.getInstance().populate(sessID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDatabase(String dbHost, int port, String dbName, String adminName, char[] rootPassword) throws SQLException, RemoteException, SessionExpiredException, Exception {
        String sessID = SessionManager.getInstance().registerNewSession(adminName, new String(rootPassword), "");
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.createStatement().execute("DROP DATABASE IF EXISTS " + dbName);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables(String sessID) throws IOException, SQLException, RemoteException, SessionExpiredException {
        PooledConnection conn = ConnectionController.connectPooled(sessID);
        try {
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.ServerlogTableSchema.getTableName() + "` (" + "`id` int(11) unsigned NOT NULL AUTO_INCREMENT," + "`user` varchar(50) COLLATE latin1_bin DEFAULT NULL," + "`event` varchar(50) COLLATE latin1_bin DEFAULT NULL," + "`description` blob," + "`timestamp` datetime NOT NULL," + "PRIMARY KEY (`id`)" + ") ENGINE=MyISAM;");
            Set<String> users = UserManager.getInstance().getAllUserNames(sessID);
            for (String u : users) {
                conn.executePreparedUpdate(String.format("GRANT INSERT ON %s TO ?@'localhost'", MedSavantDatabase.ServerlogTableSchema.getTableName()), u);
            }
            conn.executeUpdate(MedSavantDatabase.RegionSetTableSchema.getCreateQuery() + " ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate(MedSavantDatabase.RegionSetMembershipTableSchema.getCreateQuery() + " ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.CohortTableSchema.getTableName() + "` (" + "`cohort_id` int(11) unsigned NOT NULL AUTO_INCREMENT," + "`project_id` int(11) unsigned NOT NULL," + "`name` varchar(255) CHARACTER SET latin1 NOT NULL," + "PRIMARY KEY (`cohort_id`,`project_id`) USING BTREE" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.CohortmembershipTableSchema.getTableName() + "` (" + "`cohort_id` int(11) unsigned NOT NULL," + "`patient_id` int(11) unsigned NOT NULL," + "PRIMARY KEY (`patient_id`,`cohort_id`)" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.ReferenceTableSchema.getTableName() + "` (" + "`reference_id` int(11) unsigned NOT NULL AUTO_INCREMENT," + "`name` varchar(50) COLLATE latin1_bin NOT NULL," + "`url` varchar(200) COLLATE latin1_bin DEFAULT NULL," + "PRIMARY KEY (`reference_id`), " + "UNIQUE KEY `name` (`name`)" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.AnnotationTableSchema.getTableName() + "` (" + "`annotation_id` int(11) unsigned NOT NULL AUTO_INCREMENT," + "`program` varchar(100) COLLATE latin1_bin NOT NULL DEFAULT ''," + "`version` varchar(100) COLLATE latin1_bin DEFAULT NULL," + "`reference_id` int(11) unsigned NOT NULL," + "`path` varchar(500) COLLATE latin1_bin NOT NULL DEFAULT ''," + "`has_ref` tinyint(1) NOT NULL," + "`has_alt` tinyint(1) NOT NULL," + "`type` int(11) unsigned NOT NULL," + "`is_end_inclusive` tinyint(1) NOT NULL," + "PRIMARY KEY (`annotation_id`)" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.ProjectTableSchema.getTableName() + "` " + "(`project_id` int(11) unsigned NOT NULL AUTO_INCREMENT, " + "`name` varchar(50) NOT NULL, " + "PRIMARY KEY (`project_id`), " + "UNIQUE KEY `name` (`name`)" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.PatienttablemapTableSchema.getTableName() + "` (" + "`project_id` int(11) unsigned NOT NULL," + "`patient_tablename` varchar(100) COLLATE latin1_bin NOT NULL," + "PRIMARY KEY (`project_id`)" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.VarianttablemapTableSchema.getTableName() + "` (" + "`project_id` int(11) unsigned NOT NULL," + "`reference_id` int(11) unsigned NOT NULL," + "`update_id` int(11) unsigned NOT NULL," + "`published` boolean NOT NULL," + "`variant_tablename` varchar(100) COLLATE latin1_bin NOT NULL," + "`annotation_ids` varchar(500) COLLATE latin1_bin DEFAULT NULL," + "`variant_subset_tablename` varchar(100) COLLATE latin1_bin DEFAULT NULL," + "`subset_multiplier` float(10,6) DEFAULT 1," + "UNIQUE KEY `unique` (`project_id`,`reference_id`,`update_id`)" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.VariantpendingupdateTableSchema.getTableName() + "` (" + "`upload_id` int(11) unsigned NOT NULL AUTO_INCREMENT," + "`project_id` int(11) unsigned NOT NULL," + "`reference_id` int(11) unsigned NOT NULL," + "`action` int(11) unsigned NOT NULL," + "`status` int(5) unsigned NOT NULL DEFAULT '0'," + "`timestamp` datetime DEFAULT NULL," + "`user` varchar(200) DEFAULT NULL," + "PRIMARY KEY (`upload_id`) USING BTREE" + ") ENGINE=MyISAM;");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.ChromosomeTableSchema.getTableName() + "` (" + "`reference_id` int(11) unsigned NOT NULL," + "`contig_id` int(11) unsigned NOT NULL," + "`contig_name` varchar(100) COLLATE latin1_bin NOT NULL," + "`contig_length` int(11) unsigned NOT NULL," + "`centromere_pos` int(11) unsigned NOT NULL," + "PRIMARY KEY (`reference_id`,`contig_id`) USING BTREE" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.AnnotationFormatTableSchema.getTableName() + "` (" + "`annotation_id` int(11) unsigned NOT NULL," + "`position` int(11) unsigned NOT NULL," + "`column_name` varchar(200) COLLATE latin1_bin NOT NULL," + "`column_type` varchar(45) COLLATE latin1_bin NOT NULL," + "`filterable` tinyint(1) NOT NULL," + "`alias` varchar(200) COLLATE latin1_bin NOT NULL," + "`description` varchar(500) COLLATE latin1_bin NOT NULL," + "`tags` varchar(500) COLLATE latin1_bin NOT NULL," + "PRIMARY KEY (`annotation_id`,`position`)" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.PatientformatTableSchema.getTableName() + "` (" + "`project_id` int(11) unsigned NOT NULL," + "`position` int(11) unsigned NOT NULL," + "`column_name` varchar(200) COLLATE latin1_bin NOT NULL," + "`column_type` varchar(45) COLLATE latin1_bin NOT NULL," + "`filterable` tinyint(1) NOT NULL," + "`alias` varchar(200) COLLATE latin1_bin NOT NULL," + "`description` varchar(500) COLLATE latin1_bin NOT NULL," + "PRIMARY KEY (`project_id`,`position`)" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.VariantformatTableSchema.getTableName() + "` (" + "`project_id` int(11) unsigned NOT NULL," + "`reference_id` int(11) unsigned NOT NULL," + "`update_id` int(11) unsigned NOT NULL," + "`position` int(11) unsigned NOT NULL," + "`column_name` varchar(200) COLLATE latin1_bin NOT NULL," + "`column_type` varchar(45) COLLATE latin1_bin NOT NULL," + "`filterable` tinyint(1) NOT NULL," + "`alias` varchar(200) COLLATE latin1_bin NOT NULL," + "`description` varchar(500) COLLATE latin1_bin NOT NULL," + "PRIMARY KEY (`project_id`,`reference_id`,`update_id`,`position`)" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;");
            conn.executeUpdate("CREATE TABLE  `default_patient` (`patient_id` int(11) unsigned NOT NULL AUTO_INCREMENT,`family_id` varchar(100) COLLATE latin1_bin DEFAULT NULL,`hospital_id` varchar(100) COLLATE latin1_bin DEFAULT NULL,`idbiomom` varchar(100) COLLATE latin1_bin DEFAULT NULL,`idbiodad` varchar(100) COLLATE latin1_bin DEFAULT NULL,`gender` int(11) unsigned DEFAULT NULL,`affected` int(1) unsigned DEFAULT NULL,`dna_ids` varchar(1000) COLLATE latin1_bin DEFAULT NULL,`bam_url` varchar(5000) COLLATE latin1_bin DEFAULT NULL,`phenotypes` varchar(10000) COLLATE latin1_bin DEFAULT NULL,PRIMARY KEY (`patient_id`), UNIQUE KEY `hospital_id` (`hospital_id`)) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;");
            String q = "CREATE TABLE " + MedSavantDatabase.UserRoleTableSchema.getTableName() + "(" + " user_role_id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY, " + " role_name varchar(64) not null, " + " role_description text " + ")ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin COMMENT='User role definitions'";
            LOG.info((Object)q);
            conn.executeUpdate(q);
            q = "CREATE TABLE " + MedSavantDatabase.UserRoleAssignmentTableSchema.getTableName() + "(" + " user VARCHAR(300) NOT NULL, " + " fk_user_role_id INTEGER NOT NULL, " + " PRIMARY KEY(user, fk_user_role_id), " + " FOREIGN KEY(fk_user_role_id) REFERENCES " + MedSavantDatabase.UserRoleTableSchema.getTableName() + "(" + "user_role_id" + ") ON UPDATE CASCADE ON DELETE CASCADE " + ")ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin COMMENT='Assignments of users to roles.'";
            LOG.info((Object)q);
            conn.executeUpdate(q);
            q = "CREATE TABLE " + MedSavantDatabase.UserCommentGroupTableSchema.getTableName() + "(" + " user_comment_group_id\tINTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY," + "\tproject_id INTEGER," + "\treference_id INTEGER," + "\tchrom varchar(5)," + "\tstart_position integer," + "\tend_position integer," + "\tref varchar(255)," + "\talt varchar(255),\t" + "\tUNIQUE(project_id, reference_id, chrom, start_position, end_position, ref, alt)," + "\tFOREIGN KEY(project_id) REFERENCES " + MedSavantDatabase.ProjectTableSchema.getTableName() + "(" + "project_id" + ") ON UPDATE CASCADE ON DELETE CASCADE," + "\tFOREIGN KEY(reference_id) REFERENCES " + MedSavantDatabase.ReferenceTableSchema.getTableName() + "(" + "reference_id" + ") ON UPDATE RESTRICT ON DELETE RESTRICT," + " KEY(chrom) " + ")ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin COMMENT='Disease-specific comments, diseases are ontology terms.'";
            LOG.info((Object)q);
            conn.executeUpdate(q);
            q = "CREATE TABLE " + MedSavantDatabase.UserCommentTableSchema.getTableName() + "(" + " user_comment_id INTEGER NOT NULL AUTO_INCREMENT PRIMARY KEY, " + " fk_user_comment_group_id INTEGER NOT NULL, " + " fk_parent_user_comment_id INTEGER, " + "\tuser varchar(200)," + " ontology varchar(10), " + "\tontology_id varchar(30), " + "\tis_approved boolean not null default false," + "\tis_included boolean not null default false," + " is_deleted boolean not null default false," + "\tcreation_date DATE," + "\tlast_modified TIMESTAMP," + "\tvariant_comment text," + " FOREIGN KEY(ontology) REFERENCES " + MedSavantDatabase.OntologyTableSchema.getTableName() + "(" + MedSavantDatabase.OntologyColumns.ONTOLOGY.getColumnName() + ") ON UPDATE CASCADE ON DELETE RESTRICT," + "\tFOREIGN KEY(ontology_id) REFERENCES " + MedSavantDatabase.OntologyTableSchema.getTableName() + "(" + MedSavantDatabase.OntologyColumns.ID.getColumnName() + ") ON UPDATE CASCADE ON DELETE RESTRICT," + "\tFOREIGN KEY(fk_user_comment_group_id) REFERENCES " + MedSavantDatabase.UserCommentGroupTableSchema.getTableName() + "(" + "user_comment_group_id" + ") ON UPDATE RESTRICT ON DELETE RESTRICT," + "\tFOREIGN KEY(fk_parent_user_comment_id) REFERENCES " + MedSavantDatabase.UserCommentTableSchema.getTableName() + "(" + "user_comment_id" + ") ON UPDATE RESTRICT ON DELETE RESTRICT" + ")ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin";
            LOG.info((Object)q);
            conn.executeUpdate(q);
            String createVariantStatement = MedSavantServerEngine.USE_INFINIDB_ENGINE ? "CREATE TABLE  default_variant ( upload_id  INTEGER, file_id  INTEGER, variant_id  INTEGER, dna_id  varchar(100) ,chrom  varchar(5), position  INTEGER, dbsnp_id  varchar(45)  ,ref  varchar(30)  , alt  varchar(30)  , qual  float(10,0) , filter  varchar(500)  , variant_type  varchar(10)  , zygosity  varchar(20)  , gt  varchar(10)  ,custom_info  varchar(8000)  ) ENGINE=INFINIDB;" : "CREATE TABLE  `default_variant` (`upload_id` int(11),`file_id` int(11),`variant_id` int(11),`dna_id` varchar(100) COLLATE latin1_bin NOT NULL,`chrom` varchar(30) COLLATE latin1_bin NOT NULL DEFAULT '',`position` int(11),`dbsnp_id` varchar(45) COLLATE latin1_bin DEFAULT NULL,`ref` varchar(30) COLLATE latin1_bin DEFAULT NULL,`alt` varchar(30) COLLATE latin1_bin DEFAULT NULL,`qual` float(10,0) DEFAULT NULL,`filter` varchar(500) COLLATE latin1_bin DEFAULT NULL,`variant_type` varchar(10) COLLATE latin1_bin DEFAULT NULL,`zygosity` varchar(20) COLLATE latin1_bin DEFAULT NULL,`gt` varchar(10) COLLATE latin1_bin DEFAULT NULL,`custom_info` varchar(10000) COLLATE latin1_bin DEFAULT NULL) ENGINE=BRIGHTHOUSE DEFAULT CHARSET=latin1 COLLATE=latin1_bin;";
            conn.executeUpdate(createVariantStatement);
            conn.executeUpdate(MedSavantDatabase.GeneSetTableSchema.getCreateQuery() + " ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate(MedSavantDatabase.OntologyTableSchema.getCreateQuery() + " ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate(MedSavantDatabase.OntologyInfoTableSchema.getCreateQuery() + " ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.SettingsTableSchema.getTableName() + "` (" + "`setting_key` varchar(100) COLLATE latin1_bin NOT NULL," + "`setting_value` varchar(300) COLLATE latin1_bin NOT NULL," + "PRIMARY KEY (`setting_key`)" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin;");
            conn.executeUpdate(MedSavantDatabase.VariantTagTableSchema.getCreateQuery() + " ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate("CREATE TABLE `" + MedSavantDatabase.VariantStarredTableSchema.getTableName() + "` (" + "`project_id` int(11) unsigned NOT NULL," + "`reference_id` int(11) unsigned NOT NULL," + "`upload_id` int(11) NOT NULL," + "`file_id` int(11) NOT NULL," + "`variant_id` int(11) NOT NULL," + "`user` varchar(200) COLLATE latin1_bin NOT NULL," + "`description` varchar(500) COLLATE latin1_bin DEFAULT NULL," + "`timestamp` datetime NOT NULL" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            conn.executeUpdate("CREATE TABLE  `" + MedSavantDatabase.VariantFileTableSchema.getTableName() + "` (" + "`upload_id` int(11) NOT NULL," + "`file_id` int(11) NOT NULL," + "`project_id` int(11) NOT NULL," + "`reference_id` int(11) NOT NULL," + "`file_name` varchar(500) COLLATE latin1_bin NOT NULL," + "UNIQUE KEY `unique` (`upload_id`,`file_id`)" + ") ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_bin");
            SetupMedSavantDatabase.makeVariantFileTable(sessID, false);
        }
        finally {
            conn.close();
        }
    }

    public static String getVariantFileIBTableName() {
        MedSavantDatabase.VariantFileTableSchema table = MedSavantDatabase.VariantFileIBTableSchema;
        return table.getTableName();
    }

    public static synchronized TableSchema makeTemporaryVariantFileIBTable(String sid) throws IOException, SQLException, SessionExpiredException {
        String suffix;
        String tableName;
        int i = 0;
        String suffixPrefix = "_ib_tmp";
        do {
            suffix = "_ib_tmp" + i;
            tableName = "variant_file" + suffix;
            ++i;
        } while (DBUtils.tableExists(sid, tableName));
        SetupMedSavantDatabase.makeVariantFileTable(sid, true, tableName, BRIGHTHOUSE_ENGINE);
        return new MedSavantDatabase.VariantFileTableSchema(MedSavantDatabase.schema, suffix);
    }

    public static void makeVariantFileIBTable(String sid) throws IOException, SQLException, SessionExpiredException {
        SetupMedSavantDatabase.makeVariantFileTable(sid, true);
    }

    public static void makeVariantFileTable(String sid, boolean brighthouse) throws IOException, SQLException, SessionExpiredException {
        String engine;
        String tableName;
        if (brighthouse) {
            tableName = SetupMedSavantDatabase.getVariantFileIBTableName();
            engine = BRIGHTHOUSE_ENGINE;
        } else {
            tableName = MedSavantDatabase.VariantFileTableSchema.getTableName();
            engine = MYISAM_ENGINE;
        }
        SetupMedSavantDatabase.makeVariantFileTable(sid, brighthouse, tableName, engine);
    }

    private static void makeVariantFileTable(String sid, boolean brighthouse, String tableName, String engine) throws IOException, SQLException, SessionExpiredException {
        MedSavantDatabase.VariantFileTableSchema table = MedSavantDatabase.VariantFileTableSchema;
        String extras = "";
        if (!brighthouse) {
            extras = ",UNIQUE(upload_id, file_id), UNIQUE(file_id)";
        }
        ConnectionController.executeUpdate(sid, "DROP TABLE IF EXISTS " + tableName);
        String query = "CREATE TABLE  `" + tableName + "` (" + "`upload_id` int(11) NOT NULL," + "`file_id` int(11) NOT NULL " + (brighthouse ? "" : "AUTO_INCREMENT") + "," + "`project_id` int(11) NOT NULL," + "`reference_id` int(11) NOT NULL," + "`file_name` varchar(500) COLLATE latin1_bin NOT NULL" + extras + ") ENGINE=" + engine + " DEFAULT CHARSET=latin1 COLLATE=latin1_bin";
        LOG.info((Object)query);
        ConnectionController.executeUpdate(sid, query);
        if (brighthouse) {
            DBUtils.copyTable(sid, MedSavantDatabase.VariantFileTableSchema.getTableName(), SetupMedSavantDatabase.getVariantFileIBTableName());
        }
    }

    private void addRootUser(String sid, Connection c, char[] password) throws SQLException, RemoteException, SessionExpiredException {
        if (!UserManager.getInstance().userExists(sid, "root")) {
            UserManager.getInstance().addUser(sid, "root", password, UserLevel.ADMIN);
        }
    }

    private static void addDefaultReferenceGenomes(String sessionId) throws SQLException, RemoteException, SessionExpiredException {
        ReferenceManager.getInstance().addReference(sessionId, "hg17", Chromosome.getHG17Chromosomes(), null);
        ReferenceManager.getInstance().addReference(sessionId, "hg18", Chromosome.getHG18Chromosomes(), "http://savantbrowser.com/data/hg18/hg18.fa.savant");
        ReferenceManager.getInstance().addReference(sessionId, "hg19", Chromosome.getHG19Chromosomes(), "http://savantbrowser.com/data/hg19/hg19.fa.savant");
    }

    private static void addDBSettings(String sid, String versionString) throws SQLException, RemoteException, SessionExpiredException {
        SettingsManager.getInstance().addSetting(sid, "server version", versionString);
        SettingsManager.getInstance().addSetting(sid, "db lock", Boolean.toString(false));
    }

    private static void populateGenes(String sessID) throws SQLException, RemoteException, SessionExpiredException {
        TabixTableLoader loader = new TabixTableLoader(MedSavantDatabase.GeneSetTableSchema.getTable());
        try {
            loader.loadGenes(sessID, WebResources.REFGENE_HG18_URL.toURI(), "hg18", "RefSeq", null, "transcript", "chrom", null, "start", "end", "codingStart", "codingEnd", null, "exonStarts", "exonEnds", null, "name");
            loader.loadGenes(sessID, WebResources.REFGENE_HG19_URL.toURI(), "hg19", "RefSeq", null, "transcript", "chrom", null, "start", "end", "codingStart", "codingEnd", null, "exonStarts", "exonEnds", null, "name");
        }
        catch (IOException iox) {
            throw new RemoteException("Error populating gene tables.", iox);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

