/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.server.db.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.server.IOJob;
import org.ut.biolab.medsavant.server.MedSavantIOController;
import org.ut.biolab.medsavant.shared.model.Range;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;

public class DistinctValuesCache {
    private static final Log LOG = LogFactory.getLog(DistinctValuesCache.class);
    private static final String CACHE_NULL = "##NULL";
    public static final int CACHE_LIMIT = 10000;

    private static File getDirectory(String dbName, String tableName) {
        return new File(new File(DirectorySettings.getCacheDirectory(), dbName), tableName);
    }

    private static File getFile(File dir, String columnName) {
        return new File(dir, columnName);
    }

    public static boolean isCached(String dbName, String tableName, String columnName) {
        return DistinctValuesCache.getFile(DistinctValuesCache.getDirectory(dbName, tableName), columnName).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheResults(String dbName, String tableName, String columnName, final List result) {
        File dir = DistinctValuesCache.getDirectory(dbName, tableName);
        if (!dir.exists() && !dir.mkdirs()) {
            LOG.error((Object)String.format("Unable to create cache directory %s.", dir.getAbsolutePath()));
            return;
        }
        File f = DistinctValuesCache.getFile(dir, columnName);
        LOG.info((Object)("Marked " + f.getAbsolutePath() + " for deletion on exit."));
        f.deleteOnExit();
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f, false));
            if (result == null) {
                out.write(CACHE_NULL);
            } else {
                final BufferedWriter fout = out;
                MedSavantIOController.requestIO(new IOJob("Cache Results"){
                    private Iterator listIterator;
                    {
                        super(x0);
                        this.listIterator = result.iterator();
                    }

                    @Override
                    protected void doIO() throws IOException {
                        Object o = this.listIterator.next();
                        fout.write(o.toString());
                        fout.newLine();
                    }

                    @Override
                    protected boolean continueIO() throws IOException {
                        return this.listIterator.hasNext();
                    }
                });
            }
            out.close();
        }
        catch (Exception ex) {
            LOG.error((Object)("Error caching results for " + dbName + "." + tableName + "." + columnName), (Throwable)ex);
            f.delete();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)("Couldn't close file " + f), (Throwable)ex);
                    f.delete();
                }
            }
        }
    }

    private static List<String> getResults(String dbName, String tableName, String columnName) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        File dir = DistinctValuesCache.getDirectory(dbName, tableName);
        File f = DistinctValuesCache.getFile(dir, columnName);
        LOG.info((Object)("Marked " + f.getAbsolutePath() + " for deletion on exit."));
        f.deleteOnExit();
        BufferedReader in = new BufferedReader(new FileReader(f));
        while ((line = in.readLine()) != null) {
            if (result.isEmpty() && line.startsWith(CACHE_NULL)) {
                in.close();
                return null;
            }
            result.add(line);
        }
        in.close();
        LOG.info((Object)(result.size() + " values retrieved from " + f.getAbsolutePath()));
        return result;
    }

    public static List<String> getCachedStringList(String dbName, String tableName, String columnName) throws IOException {
        return DistinctValuesCache.getResults(dbName, tableName, columnName);
    }

    public static Range getCachedRange(String dbName, String tableName, String columnName) throws IOException {
        List<String> results = DistinctValuesCache.getResults(dbName, tableName, columnName);
        if (results == null || results.size() != 2) {
            return null;
        }
        return new Range(Double.parseDouble(results.get(0)), Double.parseDouble(results.get(1)));
    }
}

