/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.format;

import java.io.Serializable;
import java.sql.Date;
import java.util.HashSet;
import java.util.Set;
import org.ut.biolab.medsavant.shared.db.ColumnDef;
import org.ut.biolab.medsavant.shared.db.ColumnType;

public class CustomField
extends ColumnDef
implements Serializable {
    public static final String ALLELE_FREQUENCY_TAG = "Allele Frequency";
    public static final String TAG_DELIMITER = ",";
    private final boolean filterable;
    private final String alias;
    private final String description;
    private Set<String> tags = new HashSet<String>();

    public CustomField(String name, String typeStr, boolean filterable, String alias, String description) {
        this(name, typeStr, filterable, alias, description, false);
    }

    public CustomField(String name, String typeStr, boolean filterable, String alias, String description, boolean nonNull) {
        this(name, typeStr, filterable, alias, description, null, nonNull);
    }

    public CustomField(String name, String typeStr, boolean filterable, String alias, String description, String tagStr, boolean nonNull) {
        super(name, ColumnType.fromString(typeStr), CustomField.extractColumnLengthAndScale(typeStr), nonNull);
        this.filterable = filterable;
        this.alias = alias;
        this.description = description;
        if (tagStr != null) {
            this.addTags(tagStr);
        }
    }

    public CustomField(String n, ColumnType t, int l, boolean autoInc, boolean notNull, boolean indexed, String dflt, boolean filterable, String alias, String description) {
        super(n, t, l, 0, autoInc, notNull, indexed, dflt);
        this.filterable = filterable;
        this.alias = alias;
        this.description = description;
    }

    public CustomField addTags(String tagStr) {
        if (tagStr != null && tagStr.trim().length() > 0) {
            String[] tagStrs;
            for (String tag : tagStrs = tagStr.split(TAG_DELIMITER)) {
                this.tags.add(tag);
            }
        }
        return this;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public static int[] extractColumnLengthAndScale(String typeStr) {
        int posLeft = typeStr.indexOf(40);
        if (posLeft == -1) {
            return new int[]{0, 0};
        }
        int posRight = typeStr.indexOf(41);
        if (posRight == -1) {
            return new int[]{0, 0};
        }
        String[] parts = typeStr.substring(posLeft + 1, posRight).split(TAG_DELIMITER);
        if (parts.length == 1) {
            return new int[]{Integer.parseInt(parts[0].trim()), 0};
        }
        if (parts.length == 2) {
            return new int[]{Integer.parseInt(parts[0].trim()), Integer.parseInt(parts[1].trim())};
        }
        return new int[]{0, 0};
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public Class getColumnClass() {
        switch (this.type) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case DATE: {
                return Date.class;
            }
            case DECIMAL: {
                return Double.class;
            }
            case FLOAT: {
                return Float.class;
            }
        }
        return String.class;
    }

    public String generateSchema() {
        return this.generateSchema(false);
    }

    public String generateSchema(boolean forceLowerCase) {
        return "`" + (forceLowerCase ? this.name.toLowerCase() : this.name) + "` " + this.getTypeString() + " DEFAULT NULL,";
    }

    public String getTypeString() {
        switch (this.type) {
            case VARCHAR: {
                return "varchar(" + this.length + ")";
            }
            case BOOLEAN: {
                return "int(1)";
            }
            case INTEGER: {
                return "int(" + this.length + ")";
            }
            case FLOAT: {
                return "float";
            }
            case DECIMAL: {
                return this.length > 0 ? "decimal(" + this.length + ", " + this.scale + ")" : "decimal";
            }
        }
        return this.type.toString();
    }

    public boolean isNumeric() {
        return this.type.isNumeric();
    }

    public String toString() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(CustomField.class)) {
            return false;
        }
        CustomField other = (CustomField)o;
        return this.name.equals(other.name) && this.type == other.type && this.length == other.length;
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 89 * hash + (this.description != null ? this.description.hashCode() : 0);
        return hash;
    }
}

