/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;
import org.ut.biolab.medsavant.shared.util.WebResources;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AnnotationDownloadInformation
implements Serializable {
    private final String name;
    private final String version;
    private final String reference;
    private final String description;
    private final String url;
    private final boolean defaultAnnotation;

    public AnnotationDownloadInformation(String name, String version, String reference, String description, String url) {
        this(name, version, reference, description, url, "N");
    }

    public AnnotationDownloadInformation(String name, String version, String reference, String description, String url, String isDefault) {
        this.name = name;
        this.reference = reference;
        this.version = version;
        this.description = description;
        this.url = url;
        this.defaultAnnotation = isDefault != null && (isDefault.equalsIgnoreCase("yes") || isDefault.equalsIgnoreCase("true") || isDefault.equalsIgnoreCase("y") || isDefault.equalsIgnoreCase("yes"));
    }

    public boolean isDefault() {
        return this.defaultAnnotation;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProgramName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public String getProgramVersion() {
        return this.version;
    }

    public String getReference() {
        return this.reference;
    }

    public String toString() {
        return "AnnotationDownloadInformation{name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", url=" + this.url + ", reference=" + this.reference + '}';
    }

    private static File downloadAnnotationDatabase() throws IOException {
        String targetFileName = "AnnotationDatabase.xml";
        File targetDir = DirectorySettings.getTmpDirectory();
        File tgt = new File(targetDir, targetFileName);
        NetworkUtils.downloadFile(WebResources.ANNOTATION_DIRECTORY_URL, targetDir, targetFileName);
        return tgt;
    }

    public static List<AnnotationDownloadInformation> getDownloadableAnnotations(String versionName) throws XMLStreamException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        return AnnotationDownloadInformation.getDownloadableAnnotations(versionName, null);
    }

    public static List<AnnotationDownloadInformation> getDownloadableAnnotations(String versionName, String referenceName) throws XMLStreamException, FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        System.out.println("Getting downloadable Annotations for version " + versionName);
        File f = AnnotationDownloadInformation.downloadAnnotationDatabase();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(f);
        doc.getDocumentElement().normalize();
        Element annotations = (Element)doc.getElementsByTagName("annotations").item(0);
        NodeList versionList = annotations.getElementsByTagName("version");
        for (int i = 0; i < versionList.getLength(); ++i) {
            Element version = (Element)versionList.item(i);
            if (!version.getAttribute("name").equals(versionName)) continue;
            NodeList referenceList = version.getElementsByTagName("reference");
            ArrayList<AnnotationDownloadInformation> adiList = new ArrayList<AnnotationDownloadInformation>();
            for (int j = 0; j < referenceList.getLength(); ++j) {
                Element reference = (Element)referenceList.item(j);
                if (referenceName != null && !reference.getAttribute("name").equals(referenceName)) continue;
                NodeList annotationList = reference.getElementsByTagName("annotation");
                for (int k = 0; k < annotationList.getLength(); ++k) {
                    Element annotation = (Element)annotationList.item(k);
                    AnnotationDownloadInformation adi = new AnnotationDownloadInformation(annotation.getAttribute("name"), annotation.getAttribute("version"), reference.getAttribute("name"), annotation.getAttribute("description"), annotation.getAttribute("url"), annotation.getAttribute("isDefault"));
                    adiList.add(adi);
                }
            }
            return adiList;
        }
        return null;
    }
}

