/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MedSavantServerJobProgress
implements Serializable {
    private final String userId;
    private final String jobName;
    private String message;
    private ScheduleStatus status;
    private Map<String, String> info;
    public List<MedSavantServerJobProgress> childJobProgresses;

    public MedSavantServerJobProgress(String userId, String jobName) {
        this.userId = userId;
        this.jobName = jobName;
        this.status = ScheduleStatus.NOT_STARTED;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getMessage() {
        return this.message;
    }

    public ScheduleStatus getStatus() {
        return this.status;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }

    public void setInfo(String key, String val) {
        if (this.info == null) {
            this.info = new HashMap<String, String>();
        }
        this.info.put(key, val);
    }

    public void setStatus(ScheduleStatus status) {
        this.status = status;
        if (this.status == ScheduleStatus.FINISHED) {
            this.setMessage("Done.");
        }
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void addChildJobProgress(MedSavantServerJobProgress childJobProgress) {
        if (this.childJobProgresses == null) {
            this.childJobProgresses = new LinkedList<MedSavantServerJobProgress>();
        }
        this.childJobProgresses.add(childJobProgress);
    }

    public static enum ScheduleStatus {
        RUNNING_AS_LONGJOB{

            public String toString() {
                return "RUNNING_IN_QUEUE";
            }
        }
        ,
        RUNNING_AS_SHORTJOB{

            public String toString() {
                return "RUNNING";
            }
        }
        ,
        SCHEDULED_AS_SHORTJOB{

            public String toString() {
                return "ABOUT_TO_RUN";
            }
        }
        ,
        SCHEDULED_AS_LONGJOB{

            public String toString() {
                return "QUEUED";
            }
        }
        ,
        NOT_STARTED,
        FINISHED,
        CANCELLED;

    }
}

