/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.File;
import java.io.IOException;
import java.util.GregorianCalendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DirectorySettings {
    private static File medSavantDir;
    private static File tmpDir;
    private static Log LOG;
    private static final String CHMOD = "/bin/chmod";

    public static File getMedSavantDirectory() {
        return medSavantDir;
    }

    public static File getDatabaseWorkingDir() throws IOException {
        File f = new File(DirectorySettings.getTmpDirectory(), "database_work");
        if (!f.exists()) {
            f.mkdirs();
        }
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec("/bin/chmod -R 777 " + f.getAbsolutePath());
        try {
            proc.waitFor();
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't chmod on database working dir ", (Throwable)ex);
        }
        return f;
    }

    private static File getDirectory(String parent, String dirName) {
        File result = new File(parent, dirName);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public static File getAnnotatedTSVDirectory() {
        return new File(DirectorySettings.getMedSavantDirectory().getAbsolutePath() + File.separator + "annotatedTSV");
    }

    public static File getAnnotatedTSVDirectory(String database, int projectId, int refId) {
        return new File(DirectorySettings.getAnnotatedTSVDirectory(), database + "_" + projectId + "_" + refId);
    }

    public static File getGenoTypeDirectory() {
        return new File(DirectorySettings.getMedSavantDirectory().getAbsolutePath() + File.separator + "genotypes");
    }

    public static File getGenoTypeDirectory(String database, int projectId) {
        File f = new File(DirectorySettings.getGenoTypeDirectory(), database + "_" + projectId);
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static File getAnnotatedTSVDirectory(String database, int projectId) {
        File f = new File(DirectorySettings.getGenoTypeDirectory(database, projectId), "annotatedTSV");
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public static File getTmpDirectory() {
        return tmpDir;
    }

    public static File getCacheDirectory() {
        return DirectorySettings.getDirectory(DirectorySettings.getMedSavantDirectory().getAbsolutePath(), "cache");
    }

    public static File generateDateStampDirectory(File parent) throws IOException {
        File dir;
        do {
            GregorianCalendar today = new GregorianCalendar();
            String dateStamp = today.get(1) + "_" + (today.get(2) + 1) + "_" + today.get(5) + "_" + today.get(11) + "_" + today.get(12) + "_" + today.get(13) + "_" + today.get(14);
            dir = new File(parent.getCanonicalFile(), dateStamp);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
        } while (dir.exists());
        dir.mkdirs();
        return dir;
    }

    public static void setTmpDirectory(String path) {
        tmpDir = new File(path);
        tmpDir.mkdirs();
    }

    public static void setMedSavantDirectory(String path) {
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        medSavantDir = f;
    }

    static {
        LOG = LogFactory.getLog(DirectorySettings.class);
    }
}

