/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ut.biolab.medsavant.shared.util.DirectorySettings;
import org.ut.biolab.medsavant.shared.util.NetworkUtils;

public class RemoteFileCache {
    private static final Log LOG = LogFactory.getLog(RemoteFileCache.class);
    private static final Object indexLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getCacheFile(URL url, String source, int bufferSize, long length) throws IOException {
        Object object = indexLock;
        synchronized (object) {
            BufferedWriter out;
            String line;
            File cacheDir = DirectorySettings.getCacheDirectory();
            File index = new File(cacheDir, "cacheIndex");
            index.createNewFile();
            String newETag = NetworkUtils.getHash(url);
            boolean entryFound = false;
            boolean entryInvalid = false;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(index));
            ArrayList<String> allLines = new ArrayList<String>();
            File cacheFile = null;
            while ((line = bufferedReader.readLine()) != null) {
                String[] lineArray;
                if (!entryFound && source.equals((lineArray = line.split(","))[0])) {
                    entryFound = true;
                    cacheFile = new File(lineArray[4]);
                    if (!lineArray[1].equals(newETag) || bufferSize != Integer.parseInt(lineArray[3])) {
                        LOG.info((Object)("Removed out-of-date cache file " + cacheFile + " for " + url));
                        entryInvalid = true;
                        cacheFile.delete();
                        continue;
                    }
                }
                allLines.add(line);
            }
            if (entryInvalid) {
                out = new BufferedWriter(new FileWriter(index, false));
                for (String l : allLines) {
                    out.write(l);
                    out.newLine();
                }
                out.close();
            }
            if (entryInvalid || !entryFound) {
                if (bufferSize == 0) {
                    bufferSize = -1;
                }
                out = new BufferedWriter(new FileWriter(index, true));
                cacheFile = new File(cacheDir, source.replaceAll("[\\:/]", "+"));
                out.write(source + "," + newETag + "," + length + "," + bufferSize + "," + cacheFile);
                out.newLine();
                out.close();
            }
            return cacheFile;
        }
    }

    public static File getCacheFile(URL url) throws IOException {
        File result = RemoteFileCache.findCacheEntry(url.toString());
        if (result == null) {
            LOG.info((Object)(url + " not found in cache, downloading..."));
            result = RemoteFileCache.getCacheFile(url, url.toString(), 0, 0L);
            NetworkUtils.downloadFile(url, result.getParentFile(), result.getName());
            RemoteFileCache.updateCacheEntry(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCacheEntry(File f) throws IOException {
        Object object = indexLock;
        synchronized (object) {
            String line;
            File cacheDir = DirectorySettings.getCacheDirectory();
            File index = new File(cacheDir, "cacheIndex");
            index.createNewFile();
            String path = f.getAbsolutePath();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(index));
            ArrayList<String> allLines = new ArrayList<String>();
            String[] updatedLine = null;
            while ((line = bufferedReader.readLine()) != null) {
                String[] lineArray;
                if (updatedLine == null && path.equals((lineArray = line.split(","))[4])) {
                    updatedLine = lineArray;
                    continue;
                }
                allLines.add(line);
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(index, false));
            for (String l : allLines) {
                out.write(l);
                out.newLine();
            }
            if (updatedLine != null && f.exists()) {
                out.write(updatedLine[0] + "," + updatedLine[1] + "," + updatedLine[2] + ",0," + updatedLine[4]);
                out.newLine();
            }
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCacheEntry(String source) throws IOException {
        Object object = indexLock;
        synchronized (object) {
            File oldFile = RemoteFileCache.findCacheEntry(source);
            oldFile.delete();
            RemoteFileCache.updateCacheEntry(oldFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File findCacheEntry(String source) {
        BufferedReader reader = null;
        try {
            File cacheDir = DirectorySettings.getCacheDirectory();
            File index = new File(cacheDir, "cacheIndex");
            index.createNewFile();
            reader = new BufferedReader(new FileReader(index));
            while (true) {
                String line;
                if ((line = reader.readLine()) != null) {
                    String[] lineArray = line.split(",");
                    if (!source.equals(lineArray[0]) || lineArray[3].equals("-1")) continue;
                    File file = new File(lineArray[4]);
                    return file;
                    continue;
                }
                break;
            }
        }
        catch (IOException x) {
            LOG.error((Object)"Error reading cache.", (Throwable)x);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

