/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.util.ArrayList;
import junit.framework.Test;
import junit.runner.Version;
import org.junit.internal.runners.OldTestClassRunner;
import org.junit.internal.runners.TextListener;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

public class JUnitCore {
    private RunNotifier fNotifier = new RunNotifier();

    public static void main(String ... args) {
        Result result = new JUnitCore().runMain(args);
        JUnitCore.killAllThreads(result);
    }

    private static void killAllThreads(Result result) {
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    public static Result runClasses(Class ... classes) {
        return new JUnitCore().run(classes);
    }

    public Result runMain(String ... args) {
        System.out.println("JUnit version " + Version.id());
        ArrayList classes = new ArrayList();
        String[] stringArray = args;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String each = stringArray[n];
            try {
                classes.add(Class.forName(each));
            }
            catch (ClassNotFoundException e) {
                System.out.println("Could not find class: " + each);
            }
            ++n;
        }
        TextListener listener = new TextListener();
        this.addListener(listener);
        return this.run(classes.toArray(new Class[0]));
    }

    public String getVersion() {
        return Version.id();
    }

    public Result run(Class ... classes) {
        return this.run(Request.classes("All", classes));
    }

    public Result run(Request request) {
        return this.run(request.getRunner());
    }

    public Result run(Test test) {
        return this.run(new OldTestClassRunner(test));
    }

    public Result run(Runner runner) {
        Result result = new Result();
        RunListener listener = result.createListener();
        this.addListener(listener);
        try {
            this.fNotifier.fireTestRunStarted(runner.getDescription());
            runner.run(this.fNotifier);
            this.fNotifier.fireTestRunFinished(result);
        }
        finally {
            this.removeListener(listener);
        }
        return result;
    }

    public void addListener(RunListener listener) {
        this.fNotifier.addListener(listener);
    }

    public void removeListener(RunListener listener) {
        this.fNotifier.removeListener(listener);
    }
}

