/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.annotation.AnnotationList;
import jannovar.common.Constants;
import jannovar.common.VariantType;
import jannovar.exception.AnnotationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;

public class AnnotatedVariantFactory
implements Constants {
    private ArrayList<Annotation> annotationLst = null;
    private HashSet<String> geneSymbolSet = null;
    private boolean hasExonic;
    private boolean hasSplicing;
    private boolean hasNcRna;
    private boolean hasUTR5;
    private boolean hasUTR3;
    private boolean hasSynonymous;
    private boolean hasIntronic;
    private boolean hasNcrnaIntronic;
    private boolean hasUpstream;
    private boolean hasDownstream;
    private boolean hasIntergenic;
    private boolean hasError;
    private boolean hasGenicMutation;
    private int annotationCount;

    public AnnotatedVariantFactory(int initialCapacity) {
        this.annotationLst = new ArrayList(initialCapacity);
        this.geneSymbolSet = new HashSet();
    }

    public void clearAnnotationLists() {
        this.annotationLst.clear();
        this.geneSymbolSet.clear();
        this.hasExonic = false;
        this.hasSplicing = false;
        this.hasNcRna = false;
        this.hasUTR5 = false;
        this.hasUTR3 = false;
        this.hasIntronic = false;
        this.hasSynonymous = false;
        this.hasNcrnaIntronic = false;
        this.hasUpstream = false;
        this.hasDownstream = false;
        this.hasIntergenic = false;
        this.hasError = false;
        this.hasGenicMutation = false;
        this.annotationCount = 0;
    }

    public int getAnnotationCount() {
        return this.annotationCount;
    }

    public boolean isEmpty() {
        return this.annotationCount == 0;
    }

    public boolean isNS_SS_I() {
        return this.hasExonic || this.hasSplicing;
    }

    public boolean hasGenic() {
        return this.hasGenicMutation;
    }

    public AnnotationList getAnnotationList() throws AnnotationException {
        Collections.sort(this.annotationLst);
        AnnotationList annL = new AnnotationList(this.annotationLst);
        if (this.geneSymbolSet.size() > 1) {
            annL.setHasMultipleGeneSymbols();
        }
        annL.sortAnnotations();
        VariantType vt = this.getMostPathogenicVariantType();
        annL.setMostPathogenicVariantType(vt);
        return annL;
    }

    private VariantType getMostPathogenicVariantType() {
        Collections.sort(this.annotationLst);
        Annotation a = this.annotationLst.get(0);
        VariantType vt = a.getVariantType();
        return vt;
    }

    public void addNonCodingRNAExonicAnnotation(Annotation ann) {
        this.annotationLst.add(ann);
        this.hasNcRna = true;
        ++this.annotationCount;
    }

    public void addUTR5Annotation(Annotation ann) {
        this.annotationLst.add(ann);
        this.hasUTR5 = true;
        this.hasGenicMutation = true;
        ++this.annotationCount;
    }

    public void addUTR3Annotation(Annotation ann) {
        this.annotationLst.add(ann);
        this.hasUTR3 = true;
        this.hasGenicMutation = true;
        ++this.annotationCount;
    }

    public void addIntergenicAnnotation(Annotation ann) {
        this.annotationLst.add(ann);
        this.hasIntergenic = true;
        ++this.annotationCount;
    }

    public void addExonicAnnotation(Annotation ann) {
        this.annotationLst.add(ann);
        if (ann.getVariantType() == VariantType.SYNONYMOUS) {
            this.hasSynonymous = true;
        } else if (ann.getVariantType() == VariantType.SPLICING) {
            this.hasSplicing = true;
        } else {
            this.hasExonic = true;
        }
        this.geneSymbolSet.add(ann.getGeneSymbol());
        this.hasGenicMutation = true;
        ++this.annotationCount;
    }

    public void addNcRNASplicing(Annotation ann) {
        String s = String.format("%s", ann.getVariantAnnotation());
        this.hasNcRna = true;
        ann.setVariantAnnotation(s);
        this.annotationLst.add(ann);
    }

    public void addIntronicAnnotation(Annotation ann) {
        this.geneSymbolSet.add(ann.getGeneSymbol());
        if (ann.getVariantType() == VariantType.INTRONIC || ann.getVariantType() == VariantType.ncRNA_INTRONIC) {
            for (Annotation a : this.annotationLst) {
                if (!a.equals(ann)) continue;
                return;
            }
            this.annotationLst.add(ann);
        }
        if (ann.getVariantType() == VariantType.INTRONIC) {
            this.hasIntronic = true;
        } else if (ann.getVariantType() == VariantType.ncRNA_INTRONIC) {
            this.hasNcrnaIntronic = true;
        }
        this.hasGenicMutation = true;
        ++this.annotationCount;
    }

    public void addErrorAnnotation(Annotation ann) {
        this.annotationLst.add(ann);
        this.hasError = true;
        ++this.annotationCount;
    }

    public void addUpDownstreamAnnotation(Annotation ann) {
        for (Annotation a : this.annotationLst) {
            if (!a.equals(ann)) continue;
            return;
        }
        this.annotationLst.add(ann);
        VariantType type = ann.getVariantType();
        if (type == VariantType.DOWNSTREAM) {
            this.hasDownstream = true;
        } else if (type == VariantType.UPSTREAM) {
            this.hasUpstream = true;
        } else {
            System.err.println("Warning [AnnotatedVar.java]: Was expecting UPSTREAM or DOWNSTREAM type of variant but got " + (Object)((Object)type));
            System.exit(1);
        }
        ++this.annotationCount;
    }

    public void debugPrint() {
        System.out.println("[AnnotatedVariantFactory]:debugPrint");
        System.out.println("Total annotations: " + this.annotationCount);
        for (Annotation a : this.annotationLst) {
            System.out.println("\t[" + a.getVariantTypeAsString() + "] \"" + a.getGeneSymbol() + "\" -> " + a.getVariantAnnotation());
        }
    }
}

