/*
 * Decompiled with CFR 0.152.
 */
package jannovar.annotation;

import jannovar.annotation.Annotation;
import jannovar.common.VariantType;
import jannovar.reference.TranscriptModel;

public class SpliceAnnotation {
    public static final int SPLICING_THRESHOLD = 2;

    public static boolean isSpliceVariant(TranscriptModel tmdl, int start, int end, String ref, String alt, int k) {
        if (tmdl.getExonCount() == 1) {
            return false;
        }
        if (tmdl.isMinusStrand()) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        int exonStart = tmdl.getExonStart(k);
        int exonEnd = tmdl.getExonEnd(k);
        if (start >= exonStart && end <= exonEnd) {
            return false;
        }
        if (k > 0) {
            if (exonStart - start > 0 && exonStart - start <= 2) {
                return true;
            }
            if (exonStart - end > 0 && exonStart - end <= 2) {
                return true;
            }
            if (start <= exonStart - 2 && end >= exonStart) {
                return true;
            }
        }
        if (k < tmdl.getExonCount()) {
            if (start - exonEnd > 0 && start - exonEnd <= 2) {
                return true;
            }
            if (end - exonEnd > 0 && end - exonEnd <= 2) {
                return true;
            }
            if (start <= exonEnd - 2 && end >= exonEnd) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpliceVariantPlusStrand(TranscriptModel kgl, int start, int end, String ref, String alt, int k) {
        if (kgl.getExonCount() == 1) {
            return false;
        }
        int exonend = kgl.getExonEnd(k);
        int exonstart = kgl.getExonStart(k);
        if (k == 0 && start > exonend && start <= exonend + 2) {
            return true;
        }
        if (k == kgl.getExonCount() - 1 && start >= exonstart - 2 && start < exonstart) {
            return true;
        }
        if (k > 0 && k < kgl.getExonCount() - 1) {
            if (start >= exonstart - 2 && start < exonstart) {
                return true;
            }
            if (start > exonend && start <= exonend + 2) {
                return true;
            }
        }
        if (k == 0 && end > exonend && end <= exonend + 2) {
            return true;
        }
        if (k == kgl.getExonCount() - 1 && end >= exonstart - 2 && end < exonstart) {
            return true;
        }
        if (k > 0 && k < kgl.getExonCount() - 1) {
            if (end >= exonstart - 2 && end < exonstart) {
                return true;
            }
            if (end > exonend && end <= exonend + 2) {
                return true;
            }
        }
        if (k == 0 && start <= exonend && end > exonend) {
            return true;
        }
        if (k == kgl.getExonCount() - 1 && start < exonstart && end >= exonstart) {
            return true;
        }
        if (k > 0 && k < kgl.getExonCount() - 1) {
            if (start < exonstart && end >= exonstart) {
                return true;
            }
            if (start <= exonend && end > exonend) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpliceVariantMinusStrand(TranscriptModel kgl, int start, int end, String ref, String alt, int k) {
        if (kgl.getExonCount() == 1) {
            return false;
        }
        int exonend = kgl.getExonEnd(k);
        int exonstart = kgl.getExonStart(k);
        int exoncount = kgl.getExonCount();
        if (k == 0 && start > exonend && start <= exonend + 2) {
            return true;
        }
        if (k == exoncount - 1 && start >= exonstart - 2 && start < exonstart) {
            return true;
        }
        if (k > 0 && k < exoncount - 1) {
            if (start >= exonstart - 2 && start < exonstart) {
                return true;
            }
            if (start > exonend && start <= exonend + 2) {
                return true;
            }
        }
        if (k == 0 && end > exonend && end <= exonend + 2) {
            return true;
        }
        if (k == exoncount - 1 && end >= exonstart - 2 && end < exonstart) {
            return true;
        }
        if (k > 0 && k < exoncount - 1) {
            if (end >= exonstart - 2 && end < exonstart) {
                return true;
            }
            if (end > exonend && end <= exonend + 2) {
                return true;
            }
        }
        if (k == 0 && start <= exonend && end > exonend) {
            return true;
        }
        if (k == exoncount - 1 && start < exonstart && end >= exonstart) {
            return true;
        }
        if (k > 0 && k < exoncount - 1) {
            if (start < exonstart && end >= exonstart) {
                return true;
            }
            if (start <= exonend && end > exonend) {
                return true;
            }
        }
        return false;
    }

    public static Annotation getSpliceAnnotationPlusStrand(TranscriptModel kgl, int start, int end, String ref, String alt, int k, int cumlenexon) {
        int cdsstart = kgl.getCDSStart();
        if (start == end && start >= cdsstart) {
            int exonend = kgl.getExonEnd(k);
            int exonstart = kgl.getExonStart(k);
            if (start >= exonstart - 2 && start < exonstart) {
                String anno = kgl.isNonCodingGene() ? String.format("%s:exon%d:n.%d-%d%s>%s", kgl.getName(), k + 1, cumlenexon, exonstart - start, ref, alt) : String.format("%s:exon%d:c.%d-%d%s>%s", kgl.getName(), k + 1, cumlenexon -= exonend - exonstart, exonstart - start, ref, alt);
                int refvarstart = cumlenexon;
                Annotation ann = new Annotation(kgl, anno, VariantType.SPLICING, refvarstart);
                return ann;
            }
            if (start > exonend && start <= exonend + 2) {
                String anno = kgl.isNonCodingGene() ? String.format("%s:exon%d:n.%d+%d%s>%s", kgl.getName(), k + 1, cumlenexon, start - exonend, ref, alt) : String.format("%s:exon%d:c.%d+%d%s>%s", kgl.getName(), k + 1, cumlenexon, start - exonend, ref, alt);
                int refvarstart = cumlenexon;
                Annotation ann = new Annotation(kgl, anno, VariantType.SPLICING, refvarstart);
                return ann;
            }
        }
        String anno = String.format("%s:exon%d:complicated splice mutation", kgl.getName(), k + 1);
        Annotation ann = new Annotation(kgl, anno, VariantType.SPLICING, 0);
        return ann;
    }

    public static Annotation getSpliceAnnotationMinusStrand(TranscriptModel kgl, int start, int end, String ref, String alt, int k, int cumlenexon) {
        int cdsend = kgl.getCDSEnd();
        int exonend = kgl.getExonEnd(k);
        int exonstart = kgl.getExonStart(k);
        int exoncount = kgl.getExonCount();
        if (start == end && start <= cdsend) {
            if (start >= exonstart - 2 && start < exonstart) {
                String anno = kgl.isNonCodingGene() ? String.format("%s:exon%d:n.%d+%d%s>%s", kgl.getName(), exoncount - k, cumlenexon, exonstart - start, SpliceAnnotation.revcom(ref), SpliceAnnotation.revcom(alt)) : String.format("%s:exon%d:c.%d+%d%s>%s", kgl.getName(), exoncount - k, cumlenexon, exonstart - start, SpliceAnnotation.revcom(ref), SpliceAnnotation.revcom(alt));
                int refvarstart = cumlenexon;
                Annotation ann = new Annotation(kgl, anno, VariantType.SPLICING, refvarstart);
                return ann;
            }
            if (start > exonend && start <= exonend + 2) {
                String anno = kgl.isNonCodingGene() ? String.format("%s:exon%d:n.%d-%d%s>%s", kgl.getName(), exoncount - k, cumlenexon, start - exonend, SpliceAnnotation.revcom(ref), SpliceAnnotation.revcom(alt)) : String.format("%s:exon%d:c.%d-%d%s>%s", kgl.getName(), exoncount - k, cumlenexon -= exonend - exonstart, start - exonend, SpliceAnnotation.revcom(ref), SpliceAnnotation.revcom(alt));
                int refvarstart = cumlenexon;
                Annotation ann = new Annotation(kgl, anno, VariantType.SPLICING, refvarstart);
                return ann;
            }
        }
        String anno = String.format("%s:exon%d:complicated splice mutation", kgl.getName(), k + 1);
        Annotation ann = new Annotation(kgl, anno, VariantType.SPLICING, 0);
        return ann;
    }

    private static String revcom(String sq) {
        if (sq.equals("-")) {
            return sq;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = sq.length() - 1; i >= 0; --i) {
            char c = sq.charAt(i);
            char match = '\u0000';
            switch (c) {
                case 'A': {
                    match = 'T';
                    break;
                }
                case 'C': {
                    match = 'G';
                    break;
                }
                case 'G': {
                    match = 'C';
                    break;
                }
                case 'T': {
                    match = 'A';
                }
            }
            if (match <= '\u0000') continue;
            sb.append(match);
        }
        return sb.toString();
    }
}

