/*
 * Decompiled with CFR 0.152.
 */
package jannovar.genotype;

import jannovar.common.Genotype;
import jannovar.exception.VCFParseException;
import jannovar.genotype.GenotypeCall;

public abstract class GenotypeFactoryA {
    public abstract GenotypeCall createGenotype(String[] var1) throws VCFParseException;

    protected int parseGenotypeQuality(String q) throws NumberFormatException {
        int qual;
        int pos = q.indexOf(".");
        if (pos < 0) {
            qual = Integer.parseInt(q);
        } else {
            Float fQ = Float.valueOf(Float.parseFloat(q));
            float f = Math.round(fQ.floatValue());
            qual = (int)f;
        }
        return qual;
    }

    protected int parseGenotypeDepth(String DP) throws NumberFormatException {
        int d;
        int pos = DP.indexOf(".");
        if (pos < 0) {
            d = Integer.parseInt(DP);
        } else {
            Float fQ = Float.valueOf(Float.parseFloat(DP));
            float f = Math.round(fQ.floatValue());
            d = (int)f;
        }
        return d;
    }

    Genotype parseGenotypeString(String genot) {
        Genotype call = Genotype.UNINITIALIZED;
        if (genot.equals("0/1") || genot.equals("0|1") || genot.equals("1|0") || genot.equals("0/2")) {
            call = Genotype.HETEROZYGOUS;
        } else if (genot.equals("1/1") || genot.equals("1|1") || genot.equals("2/2") || genot.equals("1")) {
            call = Genotype.HOMOZYGOUS_ALT;
        } else if (genot.equals("0/0") || genot.equals("0|0")) {
            call = Genotype.HOMOZYGOUS_REF;
        } else if (genot.equals("1")) {
            call = Genotype.HOMOZYGOUS_ALT;
        } else if (genot.equals("./.") || genot.equals(".")) {
            call = Genotype.NOT_OBSERVED;
        }
        return call;
    }
}

