/*
 * Decompiled with CFR 0.152.
 */
package jannovar.gff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RNA2GeneIDMapper {
    private static final String ensemblRegex = "ENS[MUS]*G0+([0-9]+)";
    private static final Pattern ensemblPattern = Pattern.compile("ENS[MUS]*G0+([0-9]+)");
    private static final String refseqRegex = "gene([0-9]+)";
    private static final Pattern refseqPattern = Pattern.compile("gene([0-9]+)");

    public static int getGeneID(String geneName) {
        Matcher matcher = ensemblPattern.matcher(geneName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        matcher = refseqPattern.matcher(geneName);
        if (matcher.matches()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }
}

