/*
 * Decompiled with CFR 0.152.
 */
package org.ut.biolab.medsavant.shared.util;

import java.util.Comparator;

public class ChromosomeComparator
implements Comparator<String> {
    @Override
    public int compare(String chr1, String chr2) {
        try {
            int idx2;
            if (chr1.equals("chrM") || chr1.equals("MT")) {
                return 1;
            }
            if (chr2.equals("chrM") || chr2.equals("MT")) {
                return -1;
            }
            int idx1 = this.findDigitIndex(chr1);
            if (idx1 == (idx2 = this.findDigitIndex(chr2))) {
                String alpha2;
                String alpha1 = idx1 == -1 ? chr1 : chr1.substring(0, idx1);
                int alphaCmp = alpha1.compareTo(alpha2 = idx2 == -1 ? chr2 : chr2.substring(0, idx2));
                if (alphaCmp != 0) {
                    return alphaCmp;
                }
                int dig1 = Integer.parseInt(chr1.substring(idx1));
                int dig2 = Integer.parseInt(chr2.substring(idx2));
                return dig1 - dig2;
            }
            if (idx1 == -1) {
                return 1;
            }
            if (idx2 == -1) {
                return -1;
            }
            return idx1 - idx2;
        }
        catch (Exception numberFormatException) {
            return 0;
        }
    }

    private int findDigitIndex(String chr) {
        int n = chr.length() - 1;
        if (!Character.isDigit(chr.charAt(n))) {
            return -1;
        }
        for (int i = n - 1; i > 0; --i) {
            if (Character.isDigit(chr.charAt(i))) continue;
            return i + 1;
        }
        return 0;
    }
}

